/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench.gui;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ToolType;
import se.mickelus.mgui.gui.GuiAttachment;
import se.mickelus.mgui.gui.GuiClickable;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiStringOutline;
import se.mickelus.mgui.gui.GuiTexture;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;
import se.mickelus.tetra.util.CastOptional;

public class CraftButtonGui
extends GuiClickable {
    private final GuiStringOutline label;
    private final GuiTexture backdrop = new GuiTexture(0, 0, this.width, this.height, 176, 16, GuiTextures.workbench);
    private boolean enabled = true;
    private String tooltip;
    private int labelColor = 0xFFFFFF;
    private int backdropColor = 0xFFFFFF;

    public CraftButtonGui(int x, int y, Runnable onClickHandler) {
        super(x, y, 46, 15, onClickHandler);
        this.backdrop.setAttachment(GuiAttachment.middleCenter);
        this.addChild((GuiElement)this.backdrop);
        this.label = new GuiStringOutline(0, 1, I18n.func_135052_a((String)"tetra.workbench.schematic_detail.craft", (Object[])new Object[0]));
        this.label.setAttachment(GuiAttachment.middleCenter);
        this.addChild((GuiElement)this.label);
    }

    public boolean onMouseClick(int x, int y, int button) {
        return this.enabled && super.onMouseClick(x, y, button);
    }

    public void update(UpgradeSchematic schematic, PlayerEntity player, ItemStack itemStack, ItemStack previewStack, ItemStack[] materials, String slot, Map<ToolType, Integer> availableTools) {
        this.enabled = schematic.canApplyUpgrade(player, itemStack, materials, slot, availableTools);
        this.tooltip = null;
        if (this.enabled) {
            this.labelColor = 0xFFFFFF;
            this.backdropColor = 0xFFFFFF;
            if (!schematic.willReplace(itemStack, materials, slot)) {
                float severity = schematic.getSeverity(itemStack, materials, slot);
                List<String> destabilizationChance = this.getDestabilizationChance(previewStack.func_190926_b() ? itemStack : previewStack, severity);
                if (!destabilizationChance.isEmpty()) {
                    this.backdropColor = 0xEE5599;
                    this.tooltip = TextFormatting.GRAY + I18n.func_135052_a((String)"tetra.workbench.schematic_detail.destabilize_tooltip", (Object[])new Object[0]) + "\n";
                    this.tooltip = this.tooltip + String.join((CharSequence)"\n", destabilizationChance);
                }
            } else {
                boolean willRepair = CastOptional.cast(itemStack.func_77973_b(), IModularItem.class).map(item -> item.getRepairSlot(itemStack)).map(repairSlot -> repairSlot.equals(slot)).orElse(false);
                if (willRepair) {
                    this.tooltip = I18n.func_135052_a((String)"tetra.workbench.schematic_detail.repair_tooltip", (Object[])new Object[0]);
                }
            }
        } else {
            this.labelColor = 0x7F7F7F;
            this.backdropColor = 0xFF5555;
            this.tooltip = "";
            if (!schematic.isMaterialsValid(itemStack, slot, materials)) {
                if (this.hasEmptyMaterial(schematic, materials)) {
                    this.tooltip = this.tooltip + I18n.func_135052_a((String)"tetra.workbench.schematic_detail.no_material_tooltip", (Object[])new Object[0]);
                    this.backdropColor = 0x7F7F7F;
                } else {
                    this.tooltip = this.hasInsufficientQuantities(schematic, itemStack, slot, materials) ? this.tooltip + I18n.func_135052_a((String)"tetra.workbench.schematic_detail.material_count_tooltip", (Object[])new Object[0]) : this.tooltip + I18n.func_135052_a((String)"tetra.workbench.schematic_detail.material_tooltip", (Object[])new Object[0]);
                }
            } else {
                if (schematic.isIntegrityViolation(player, itemStack, materials, slot)) {
                    this.tooltip = this.tooltip + I18n.func_135052_a((String)"tetra.workbench.schematic_detail.integrity_tooltip", (Object[])new Object[0]);
                }
                if (!schematic.checkTools(itemStack, materials, availableTools)) {
                    this.tooltip = this.tooltip + I18n.func_135052_a((String)"tetra.workbench.schematic_detail.tools_tooltip", (Object[])new Object[0]);
                }
                if (!player.func_184812_l_() && player.field_71068_ca < schematic.getExperienceCost(itemStack, materials, slot)) {
                    this.tooltip = this.tooltip + I18n.func_135052_a((String)"tetra.workbench.schematic_detail.level_tooltip", (Object[])new Object[0]);
                }
            }
        }
        this.updateColors();
    }

    private List<String> getDestabilizationChance(ItemStack itemStack, float severity) {
        return CastOptional.cast(itemStack.func_77973_b(), IModularItem.class).map(item -> item.getMajorModules(itemStack)).map(Arrays::stream).orElseGet(Stream::empty).filter(Objects::nonNull).filter(module -> module.getMagicCapacity(itemStack) < 0).map(module -> String.format("  %s%s: %s%.0f%%", TextFormatting.WHITE, module.getName(itemStack), TextFormatting.YELLOW, Float.valueOf(module.getDestabilizationChance(itemStack, severity) * 100.0f))).collect(Collectors.toList());
    }

    private boolean hasEmptyMaterial(UpgradeSchematic schematic, ItemStack[] materials) {
        for (int i = 0; i < schematic.getNumMaterialSlots(); ++i) {
            if (!materials[i].func_190926_b()) continue;
            return true;
        }
        return false;
    }

    private boolean hasInsufficientQuantities(UpgradeSchematic schematic, ItemStack itemStack, String slot, ItemStack[] materials) {
        for (int i = 0; i < schematic.getNumMaterialSlots(); ++i) {
            if (!schematic.acceptsMaterial(itemStack, slot, i, materials[i])) continue;
            int requiredCount = schematic.getRequiredQuantity(itemStack, i, materials[i]);
            if (materials[i].func_190926_b() || requiredCount <= materials[i].func_190916_E()) continue;
            return true;
        }
        return false;
    }

    protected void onFocus() {
        this.updateColors();
    }

    protected void onBlur() {
        this.updateColors();
    }

    private void updateColors() {
        if (this.enabled && this.hasFocus()) {
            this.label.setColor(0xFFFFCC);
            this.backdrop.setColor(0xFFFFCC);
        } else {
            this.label.setColor(this.labelColor);
            this.backdrop.setColor(this.backdropColor);
        }
    }

    public List<String> getTooltipLines() {
        if (this.tooltip != null && this.hasFocus()) {
            return Collections.singletonList(this.tooltip);
        }
        return null;
    }
}

