/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench.action;

import java.io.IOException;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import se.mickelus.tetra.blocks.workbench.WorkbenchTile;
import se.mickelus.tetra.network.BlockPosPacket;

public class WorkbenchActionPacket
extends BlockPosPacket {
    private String actionKey;

    public WorkbenchActionPacket() {
    }

    public WorkbenchActionPacket(BlockPos pos, String actionKey) {
        super(pos);
        this.actionKey = actionKey;
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        super.toBytes(buffer);
        try {
            WorkbenchActionPacket.writeString(this.actionKey, buffer);
        }
        catch (IOException exception) {
            System.err.println("An error occurred when writing action name to packet buffer");
        }
    }

    @Override
    public void fromBytes(PacketBuffer buffer) {
        super.fromBytes(buffer);
        try {
            this.actionKey = WorkbenchActionPacket.readString(buffer);
        }
        catch (IOException exception) {
            System.err.println("An error occurred when reading action name from packet buffer");
        }
    }

    @Override
    public void handle(PlayerEntity player) {
        WorkbenchTile workbench = (WorkbenchTile)player.field_70170_p.func_175625_s(this.pos);
        if (workbench != null) {
            workbench.performAction(player, this.actionKey);
        }
    }
}

