/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.salvage;

import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;
import se.mickelus.tetra.blocks.salvage.InteractionOutcome;
import se.mickelus.tetra.util.TileEntityOptional;

public class TileBlockInteraction<T extends TileEntity>
extends BlockInteraction {
    private final Function<T, Boolean> predicate;
    private final Class<T> tileEntityClass;

    public TileBlockInteraction(ToolType requiredTool, int requiredLevel, Direction face, float minX, float maxX, float minY, float maxY, Class<T> tileEntityClass, Function<T, Boolean> predicate, InteractionOutcome outcome) {
        super(requiredTool, requiredLevel, face, minX, maxX, minY, maxY, outcome);
        this.tileEntityClass = tileEntityClass;
        this.predicate = predicate;
    }

    @Override
    public boolean applicableForBlock(World world, BlockPos pos, BlockState blockState) {
        return TileEntityOptional.from((IBlockReader)world, pos, this.tileEntityClass).map(this.predicate::apply).orElse(false);
    }
}

