/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.salvage;

import com.google.common.base.Predicates;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import se.mickelus.tetra.advancements.BlockInteractionCriterion;
import se.mickelus.tetra.blocks.PropertyMatcher;
import se.mickelus.tetra.blocks.salvage.IInteractiveBlock;
import se.mickelus.tetra.blocks.salvage.InteractionOutcome;
import se.mickelus.tetra.blocks.salvage.InteractiveBlockOverlay;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.properties.PropertyHelper;
import se.mickelus.tetra.util.CastOptional;
import se.mickelus.tetra.util.RotationHelper;

public class BlockInteraction {
    public ToolType requiredTool;
    public int requiredLevel;
    public boolean alwaysReveal = true;
    public Direction face;
    public float minX;
    public float minY;
    public float maxX;
    public float maxY;
    public Predicate<BlockState> predicate;
    public InteractionOutcome outcome;
    protected boolean applyUsageEffects = true;

    public <V extends Comparable<V>> BlockInteraction(ToolType requiredTool, int requiredLevel, Direction face, float minX, float maxX, float minY, float maxY, InteractionOutcome outcome) {
        this.requiredTool = requiredTool;
        this.requiredLevel = requiredLevel;
        this.face = face;
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        this.outcome = outcome;
    }

    public BlockInteraction(ToolType requiredTool, int requiredLevel, Direction face, float minX, float maxX, float minY, float maxY, Predicate<BlockState> predicate, InteractionOutcome outcome) {
        this(requiredTool, requiredLevel, face, minX, maxX, minY, maxY, outcome);
        this.predicate = predicate;
    }

    public <V extends Comparable<V>> BlockInteraction(ToolType requiredTool, int requiredLevel, Direction face, float minX, float maxX, float minY, float maxY, Property<V> property, V propertyValue, InteractionOutcome outcome) {
        this(requiredTool, requiredLevel, face, minX, maxX, minY, maxY, new PropertyMatcher().where(property, Predicates.equalTo(propertyValue)), outcome);
    }

    public boolean applicableForBlock(World world, BlockPos pos, BlockState blockState) {
        return this.predicate.test(blockState);
    }

    public boolean isWithinBounds(double x, double y) {
        return (double)this.minX <= x && x <= (double)this.maxX && (double)this.minY <= y && y <= (double)this.maxY;
    }

    public boolean isPotentialInteraction(World world, BlockPos pos, BlockState blockState, Direction hitFace, Collection<ToolType> availableTools) {
        return this.isPotentialInteraction(world, pos, blockState, Direction.NORTH, hitFace, availableTools);
    }

    public boolean isPotentialInteraction(World world, BlockPos pos, BlockState blockState, Direction blockFacing, Direction hitFace, Collection<ToolType> availableTools) {
        return this.applicableForBlock(world, pos, blockState) && RotationHelper.rotationFromFacing(blockFacing).func_185831_a(this.face).equals((Object)hitFace) && (this.alwaysReveal || availableTools.contains(this.requiredTool));
    }

    public void applyOutcome(World world, BlockPos pos, BlockState blockState, @Nullable PlayerEntity player, @Nullable Hand hand, Direction hitFace) {
        this.outcome.apply(world, pos, blockState, player, hand, hitFace);
    }

    public static ActionResultType attemptInteraction(World world, BlockState blockState, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTrace) {
        ItemStack heldStack = player.func_184586_b(hand);
        Set<ToolType> availableTools = PropertyHelper.getItemTools(heldStack);
        AxisAlignedBB boundingBox = blockState.func_215700_a((IBlockReader)world, pos, ISelectionContext.func_216374_a((Entity)player)).func_197752_a();
        double hitU = 16.0 * BlockInteraction.getHitU(rayTrace.func_216354_b(), boundingBox, rayTrace.func_216347_e().field_72450_a - (double)pos.func_177958_n(), rayTrace.func_216347_e().field_72448_b - (double)pos.func_177956_o(), rayTrace.func_216347_e().field_72449_c - (double)pos.func_177952_p());
        double hitV = 16.0 * BlockInteraction.getHitV(rayTrace.func_216354_b(), boundingBox, rayTrace.func_216347_e().field_72450_a - (double)pos.func_177958_n(), rayTrace.func_216347_e().field_72448_b - (double)pos.func_177956_o(), rayTrace.func_216347_e().field_72449_c - (double)pos.func_177952_p());
        BlockInteraction possibleInteraction = CastOptional.cast(blockState.func_177230_c(), IInteractiveBlock.class).map(block -> block.getPotentialInteractions(world, pos, blockState, rayTrace.func_216354_b(), availableTools)).map(Arrays::stream).orElseGet(Stream::empty).filter(interaction -> interaction.isWithinBounds(hitU, hitV)).filter(interaction -> PropertyHelper.getItemToolLevel(heldStack, interaction.requiredTool) >= interaction.requiredLevel).findFirst().orElse(null);
        if (possibleInteraction != null) {
            if (Hand.MAIN_HAND == hand) {
                if ((double)player.func_184825_o(0.0f) < 0.8) {
                    if (player.func_184592_cb().func_190926_b()) {
                        player.func_184821_cY();
                        return ActionResultType.FAIL;
                    }
                    return ActionResultType.PASS;
                }
            } else if (player.func_184811_cZ().func_185141_a(heldStack.func_77973_b())) {
                return ActionResultType.FAIL;
            }
            possibleInteraction.applyOutcome(world, pos, blockState, player, hand, rayTrace.func_216354_b());
            if (availableTools.contains(possibleInteraction.requiredTool) && heldStack.func_77984_f()) {
                if (heldStack.func_77973_b() instanceof IModularItem) {
                    IModularItem item2 = (IModularItem)heldStack.func_77973_b();
                    item2.applyDamage(2, heldStack, (LivingEntity)player);
                    if (possibleInteraction.applyUsageEffects) {
                        item2.applyUsageEffects((LivingEntity)player, heldStack, possibleInteraction.requiredLevel * 2);
                    }
                } else {
                    heldStack.func_222118_a(2, (LivingEntity)player, breaker -> breaker.func_213334_d(breaker.func_184600_cs()));
                }
            }
            if (player instanceof ServerPlayerEntity) {
                BlockState newState = world.func_180495_p(pos);
                BlockInteractionCriterion.trigger((ServerPlayerEntity)player, newState, possibleInteraction.requiredTool, possibleInteraction.requiredLevel);
            }
            if (Hand.MAIN_HAND == hand) {
                player.func_184821_cY();
            } else {
                int cooldown = CastOptional.cast(heldStack.func_77973_b(), ItemModularHandheld.class).map(item -> (int)(20.0 * item.getCooldownBase(heldStack))).orElse(10);
                player.func_184811_cZ().func_185145_a(heldStack.func_77973_b(), cooldown);
            }
            if (player.field_70170_p.field_72995_K) {
                InteractiveBlockOverlay.markDirty();
            }
            return ActionResultType.func_233537_a_((boolean)player.field_70170_p.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    public static BlockInteraction getInteractionAtPoint(PlayerEntity player, BlockState blockState, BlockPos pos, Direction hitFace, double hitX, double hitY, double hitZ) {
        AxisAlignedBB boundingBox = blockState.func_196954_c((IBlockReader)player.field_70170_p, pos).func_197752_a();
        double hitU = BlockInteraction.getHitU(hitFace, boundingBox, hitX, hitY, hitZ);
        double hitV = BlockInteraction.getHitV(hitFace, boundingBox, hitX, hitY, hitZ);
        return CastOptional.cast(blockState.func_177230_c(), IInteractiveBlock.class).map(block -> block.getPotentialInteractions(player.field_70170_p, pos, blockState, hitFace, PropertyHelper.getPlayerTools(player))).map(Arrays::stream).orElseGet(Stream::empty).filter(interaction -> interaction.isWithinBounds(hitU * 16.0, hitV * 16.0)).findFirst().orElse(null);
    }

    private static double getHitU(Direction facing, AxisAlignedBB boundingBox, double hitX, double hitY, double hitZ) {
        switch (facing) {
            case DOWN: {
                return boundingBox.field_72336_d - hitX;
            }
            case UP: {
                return boundingBox.field_72336_d - hitX;
            }
            case NORTH: {
                return boundingBox.field_72336_d - hitX;
            }
            case SOUTH: {
                return hitX - boundingBox.field_72340_a;
            }
            case WEST: {
                return hitZ - boundingBox.field_72339_c;
            }
            case EAST: {
                return boundingBox.field_72334_f - hitZ;
            }
        }
        return 0.0;
    }

    private static double getHitV(Direction facing, AxisAlignedBB boundingBox, double hitX, double hitY, double hitZ) {
        switch (facing) {
            case DOWN: {
                return boundingBox.field_72334_f - hitZ;
            }
            case UP: {
                return boundingBox.field_72334_f - hitZ;
            }
            case NORTH: {
                return boundingBox.field_72337_e - hitY;
            }
            case SOUTH: {
                return boundingBox.field_72337_e - hitY;
            }
            case WEST: {
                return boundingBox.field_72337_e - hitY;
            }
            case EAST: {
                return boundingBox.field_72337_e - hitY;
            }
        }
        return 0.0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockInteraction that = (BlockInteraction)o;
        return this.requiredLevel == that.requiredLevel && Float.compare(that.minX, this.minX) == 0 && Float.compare(that.minY, this.minY) == 0 && Float.compare(that.maxX, this.maxX) == 0 && Float.compare(that.maxY, this.maxY) == 0 && Objects.equals(this.requiredTool, that.requiredTool) && this.face == that.face;
    }

    public int hashCode() {
        return Objects.hash(this.requiredTool, this.requiredLevel, this.face, Float.valueOf(this.minX), Float.valueOf(this.minY), Float.valueOf(this.maxX), Float.valueOf(this.maxY));
    }

    public static List<ItemStack> getLoot(ResourceLocation lootTable, PlayerEntity player, Hand hand, ServerWorld world, BlockState blockState) {
        LootTable table = world.func_73046_m().func_200249_aQ().func_186521_a(lootTable);
        LootContext context = new LootContext.Builder(world).func_186469_a(player.func_184817_da()).func_216015_a(LootParameters.field_216281_a, (Object)player).func_216015_a(LootParameters.field_216287_g, (Object)blockState).func_216015_a(LootParameters.field_216289_i, (Object)player.func_184586_b(hand)).func_216015_a(LootParameters.field_237457_g_, (Object)player.func_213303_ch()).func_216022_a(LootParameterSets.field_216267_h);
        return table.func_216113_a(context);
    }

    public static List<ItemStack> getLoot(ResourceLocation lootTable, ServerWorld world, BlockPos pos, BlockState blockState) {
        LootTable table = world.func_73046_m().func_200249_aQ().func_186521_a(lootTable);
        LootContext context = new LootContext.Builder(world).func_216015_a(LootParameters.field_216287_g, (Object)blockState).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)pos)).func_216022_a(LootParameterSets.field_216267_h);
        return table.func_216113_a(context);
    }

    public static void dropLoot(ResourceLocation lootTable, @Nullable PlayerEntity player, @Nullable Hand hand, ServerWorld world, BlockState blockState) {
        BlockInteraction.getLoot(lootTable, player, hand, world, blockState).forEach(itemStack -> {
            if (!player.field_71071_by.func_70441_a(itemStack)) {
                player.func_71019_a(itemStack, false);
            }
        });
    }

    public static void dropLoot(ResourceLocation lootTable, ServerWorld world, BlockPos pos, BlockState blockState) {
        BlockInteraction.getLoot(lootTable, world, pos, blockState).forEach(itemStack -> Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)itemStack));
    }
}

