/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.geode;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.blocks.TetraBlock;
import se.mickelus.tetra.network.PacketHandler;

public class GeodeBlock
extends TetraBlock {
    public static final String unlocalizedName = "block_geode";
    @ObjectHolder(value="tetra:block_geode")
    public static GeodeBlock instance;
    private ConfiguredFeature configuredFeature;

    public GeodeBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185851_d).harvestTool(ToolType.PICKAXE).harvestLevel(0).func_200948_a(1.5f, 6.0f));
        this.setRegistryName(unlocalizedName);
        int density = (Integer)ConfigHandler.geodeDensity.get();
        if (density > 0) {
            int size = 3;
            int maxHeight = 32;
            OreFeatureConfig config = new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, this.func_176223_P(), size);
            this.configuredFeature = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)config).func_242733_d(maxHeight)).func_242728_a()).func_242732_c(density);
        }
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return Blocks.field_150348_b.getPickBlock(state, target, world, pos, player);
    }

    @Override
    public void init(PacketHandler packetHandler) {
        if (this.configuredFeature != null) {
            Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("tetra", unlocalizedName), (Object)this.configuredFeature);
        }
    }

    public static void registerFeature(BiomeGenerationSettingsBuilder builder) {
        if (GeodeBlock.instance.configuredFeature != null) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GeodeBlock.instance.configuredFeature);
        }
    }
}

