/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.container;

import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerBlock;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerContainer;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;
import se.mickelus.tetra.util.TileEntityOptional;

public class ForgedContainerTile
extends TileEntity
implements INamedContainerProvider {
    @ObjectHolder(value="tetra:forged_container")
    public static TileEntityType<ForgedContainerTile> type;
    private static final String inventoryKey = "inv";
    public static int lockIntegrityMax;
    public static int lockCount;
    private int[] lockIntegrity;
    public static int lidIntegrityMax;
    private int lidIntegrity = 0;
    private static final ResourceLocation lockLootTable;
    public static int compartmentCount;
    public static int compartmentSize;
    public long openTime = -1L;
    private LazyOptional<ItemStackHandler> handler = LazyOptional.of(() -> new ItemStackHandler(compartmentSize * compartmentCount));

    public ForgedContainerTile() {
        super(type);
        this.lockIntegrity = new int[lockCount];
    }

    public Optional<ForgedContainerTile> getOrDelegate() {
        if (this.field_145850_b != null && this.func_195044_w().func_177230_c() instanceof ForgedContainerBlock && this.isFlipped()) {
            return TileEntityOptional.from((IBlockReader)this.field_145850_b, this.field_174879_c.func_177972_a(this.getFacing().func_176735_f()), ForgedContainerTile.class);
        }
        return Optional.of(this);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getOrDelegate().map(primary -> primary.handler.cast()).orElseGet(LazyOptional::empty);
        }
        return super.getCapability(cap, side);
    }

    public void open(@Nullable PlayerEntity player) {
        if (this.lidIntegrity > 0) {
            --this.lidIntegrity;
            this.func_70296_d();
            if (!this.field_145850_b.field_72995_K) {
                ServerWorld worldServer = (ServerWorld)this.field_145850_b;
                if (this.lidIntegrity == 0) {
                    this.causeOpeningEffects(worldServer);
                } else {
                    worldServer.func_184133_a(null, this.field_174879_c, SoundEvents.field_187614_cJ, SoundCategory.PLAYERS, 0.5f, 1.3f);
                }
                Optional.ofNullable(player).filter(p -> !p.func_70644_a(Effects.field_76420_g)).ifPresent(p -> p.func_195064_c(new EffectInstance(Effects.field_76419_f, 200, 5)));
            } else if (this.lidIntegrity == 0) {
                this.openTime = System.currentTimeMillis();
            }
            this.updateBlockState();
        }
    }

    private void causeOpeningEffects(ServerWorld worldServer) {
        Direction facing = (Direction)worldServer.func_180495_p(this.field_174879_c).func_177229_b((Property)HorizontalBlock.field_185512_D);
        Vector3d smokeDirection = Vector3d.func_237491_b_((Vector3i)facing.func_176746_e().func_176730_m());
        Random random = new Random();
        int smokeCount = 5 + random.nextInt(4);
        BlockPos smokeOrigin = this.field_174879_c;
        if (Direction.SOUTH.equals((Object)facing)) {
            smokeOrigin = smokeOrigin.func_177982_a(1, 0, 0);
        } else if (Direction.WEST.equals((Object)facing)) {
            smokeOrigin = smokeOrigin.func_177982_a(1, 0, 1);
        } else if (Direction.NORTH.equals((Object)facing)) {
            smokeOrigin = smokeOrigin.func_177982_a(0, 0, 1);
        }
        for (int i = 0; i < smokeCount; ++i) {
            worldServer.func_195598_a((IParticleData)ParticleTypes.field_197601_L, (double)smokeOrigin.func_177958_n() + smokeDirection.field_72450_a * (double)i * 2.0 / (double)(smokeCount - 1), (double)smokeOrigin.func_177956_o() + 0.8, (double)smokeOrigin.func_177952_p() + smokeDirection.field_72449_c * (double)i * 2.0 / (double)(smokeCount - 1), 1, 0.0, 0.0, 0.0, 0.0);
        }
        worldServer.func_184133_a(null, this.field_174879_c, SoundEvents.field_187617_cK, SoundCategory.PLAYERS, 1.0f, 0.5f);
        worldServer.func_184133_a(null, this.field_174879_c, SoundEvents.field_187659_cY, SoundCategory.PLAYERS, 0.2f, 0.8f);
    }

    private void updateBlockState() {
        this.field_145850_b.func_180501_a(this.field_174879_c, ForgedContainerTile.getUpdatedBlockState(this.func_195044_w(), this.lockIntegrity, this.lidIntegrity), 3);
        BlockPos offsetPos = this.field_174879_c.func_177972_a(this.getFacing().func_176746_e());
        this.field_145850_b.func_180501_a(offsetPos, ForgedContainerTile.getUpdatedBlockState(this.field_145850_b.func_180495_p(offsetPos), this.lockIntegrity, this.lidIntegrity), 3);
    }

    public static BlockState getUpdatedBlockState(BlockState blockState, int[] lockIntegrity, int lidIntegrity) {
        if (((Boolean)blockState.func_177229_b((Property)ForgedContainerBlock.flippedProp)).booleanValue()) {
            return (BlockState)((BlockState)((BlockState)((BlockState)blockState.func_206870_a((Property)ForgedContainerBlock.locked1Prop, (Comparable)Boolean.valueOf(lockIntegrity[2] > 0))).func_206870_a((Property)ForgedContainerBlock.locked2Prop, (Comparable)Boolean.valueOf(lockIntegrity[3] > 0))).func_206870_a((Property)ForgedContainerBlock.anyLockedProp, (Comparable)Boolean.valueOf(Arrays.stream(lockIntegrity).anyMatch(integrity -> integrity > 0)))).func_206870_a((Property)ForgedContainerBlock.openProp, (Comparable)Boolean.valueOf(lidIntegrity <= 0));
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)blockState.func_206870_a((Property)ForgedContainerBlock.locked1Prop, (Comparable)Boolean.valueOf(lockIntegrity[0] > 0))).func_206870_a((Property)ForgedContainerBlock.locked2Prop, (Comparable)Boolean.valueOf(lockIntegrity[1] > 0))).func_206870_a((Property)ForgedContainerBlock.anyLockedProp, (Comparable)Boolean.valueOf(Arrays.stream(lockIntegrity).anyMatch(integrity -> integrity > 0)))).func_206870_a((Property)ForgedContainerBlock.openProp, (Comparable)Boolean.valueOf(lidIntegrity <= 0));
    }

    public Direction getFacing() {
        return (Direction)this.func_195044_w().func_177229_b((Property)ForgedContainerBlock.facingProp);
    }

    public boolean isFlipped() {
        return (Boolean)this.func_195044_w().func_177229_b((Property)ForgedContainerBlock.flippedProp);
    }

    public boolean isOpen() {
        return this.lidIntegrity <= 0;
    }

    public boolean isLocked(int index) {
        return this.lockIntegrity[index] > 0;
    }

    public Boolean[] isLocked() {
        return (Boolean[])Arrays.stream(this.lockIntegrity).mapToObj(integrity -> integrity > 0).toArray(Boolean[]::new);
    }

    public void breakLock(@Nullable PlayerEntity player, int index, @Nullable Hand hand) {
        if (this.lockIntegrity[index] > 0) {
            int n = index;
            this.lockIntegrity[n] = this.lockIntegrity[n] - 1;
            if (this.lockIntegrity[index] == 0) {
                this.field_145850_b.func_184133_a(player, this.field_174879_c, SoundEvents.field_187769_eM, SoundCategory.PLAYERS, 1.0f, 0.5f);
            } else {
                this.field_145850_b.func_184133_a(player, this.field_174879_c, SoundEvents.field_187928_hb, SoundCategory.PLAYERS, 1.0f, 0.5f);
            }
            if (!this.field_145850_b.field_72995_K && this.lockIntegrity[index] == 0) {
                if (player != null) {
                    BlockInteraction.dropLoot(lockLootTable, player, hand, (ServerWorld)this.field_145850_b, this.func_195044_w());
                } else {
                    BlockInteraction.dropLoot(lockLootTable, (ServerWorld)this.field_145850_b, this.func_174877_v(), this.func_195044_w());
                }
            }
        }
        this.updateBlockState();
        this.func_70296_d();
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent("forged_container");
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ForgedContainerContainer(windowId, this, (IInventory)playerInventory, playerEntity);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.handler.ifPresent(handler -> handler.deserializeNBT(compound.func_74775_l(inventoryKey)));
        for (int i = 0; i < this.lockIntegrity.length; ++i) {
            this.lockIntegrity[i] = compound.func_74762_e("lock_integrity" + i);
        }
        this.lidIntegrity = compound.func_74762_e("lid_integrity");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        this.handler.ifPresent(handler -> compound.func_218657_a(inventoryKey, (INBT)handler.serializeNBT()));
        ForgedContainerTile.writeLockData(compound, this.lockIntegrity);
        ForgedContainerTile.writeLidData(compound, this.lidIntegrity);
        return compound;
    }

    public static void writeLockData(CompoundNBT compound, int[] lockIntegrity) {
        for (int i = 0; i < lockIntegrity.length; ++i) {
            compound.func_74768_a("lock_integrity" + i, lockIntegrity[i]);
        }
    }

    public static void writeLidData(CompoundNBT compound, int lidIntegrity) {
        compound.func_74768_a("lid_integrity", lidIntegrity);
    }

    static {
        lockIntegrityMax = 4;
        lockCount = 4;
        lidIntegrityMax = 5;
        lockLootTable = new ResourceLocation("tetra", "forged/lock_break");
        compartmentCount = 3;
        compartmentSize = 54;
    }
}

