/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra;

import com.mojang.brigadier.CommandDispatcher;
import java.util.Arrays;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.command.CommandSource;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.potion.Effect;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.ClientScheduler;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.LooseItemPredicate;
import se.mickelus.tetra.ServerScheduler;
import se.mickelus.tetra.advancements.BlockInteractionCriterion;
import se.mickelus.tetra.advancements.BlockLookTrigger;
import se.mickelus.tetra.advancements.BlockUseCriterion;
import se.mickelus.tetra.advancements.ImprovementCraftCriterion;
import se.mickelus.tetra.advancements.ModuleCraftCriterion;
import se.mickelus.tetra.blocks.ITetraBlock;
import se.mickelus.tetra.blocks.forged.BlockForgedPillar;
import se.mickelus.tetra.blocks.forged.BlockForgedPlatform;
import se.mickelus.tetra.blocks.forged.BlockForgedPlatformSlab;
import se.mickelus.tetra.blocks.forged.BlockForgedWall;
import se.mickelus.tetra.blocks.forged.ForgedCrateBlock;
import se.mickelus.tetra.blocks.forged.ForgedVentBlock;
import se.mickelus.tetra.blocks.forged.ForgedWorkbenchBlock;
import se.mickelus.tetra.blocks.forged.chthonic.ChthonicExtractorBlock;
import se.mickelus.tetra.blocks.forged.chthonic.ChthonicExtractorTile;
import se.mickelus.tetra.blocks.forged.chthonic.DepletedBedrockBlock;
import se.mickelus.tetra.blocks.forged.chthonic.ExtractorProjectileEntity;
import se.mickelus.tetra.blocks.forged.chthonic.FracturedBedrockBlock;
import se.mickelus.tetra.blocks.forged.chthonic.FracturedBedrockTile;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerBlock;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerContainer;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerRenderer;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerTile;
import se.mickelus.tetra.blocks.forged.extractor.CoreExtractorBaseBlock;
import se.mickelus.tetra.blocks.forged.extractor.CoreExtractorBaseTile;
import se.mickelus.tetra.blocks.forged.extractor.CoreExtractorPipeBlock;
import se.mickelus.tetra.blocks.forged.extractor.CoreExtractorPistonBlock;
import se.mickelus.tetra.blocks.forged.extractor.CoreExtractorPistonTile;
import se.mickelus.tetra.blocks.forged.extractor.SeepingBedrockBlock;
import se.mickelus.tetra.blocks.forged.hammer.HammerBaseBlock;
import se.mickelus.tetra.blocks.forged.hammer.HammerBaseRenderer;
import se.mickelus.tetra.blocks.forged.hammer.HammerBaseTile;
import se.mickelus.tetra.blocks.forged.hammer.HammerHeadBlock;
import se.mickelus.tetra.blocks.forged.hammer.HammerHeadTile;
import se.mickelus.tetra.blocks.forged.transfer.TransferUnitBlock;
import se.mickelus.tetra.blocks.forged.transfer.TransferUnitTile;
import se.mickelus.tetra.blocks.geode.GeodeBlock;
import se.mickelus.tetra.blocks.geode.GeodeItem;
import se.mickelus.tetra.blocks.geode.PristineDiamondItem;
import se.mickelus.tetra.blocks.geode.PristineEmeraldItem;
import se.mickelus.tetra.blocks.geode.PristineLapisItem;
import se.mickelus.tetra.blocks.rack.RackBlock;
import se.mickelus.tetra.blocks.rack.RackTile;
import se.mickelus.tetra.blocks.scroll.OpenScrollBlock;
import se.mickelus.tetra.blocks.scroll.RolledScrollBlock;
import se.mickelus.tetra.blocks.scroll.ScrollItem;
import se.mickelus.tetra.blocks.scroll.ScrollRenderer;
import se.mickelus.tetra.blocks.scroll.ScrollTile;
import se.mickelus.tetra.blocks.scroll.WallScrollBlock;
import se.mickelus.tetra.blocks.workbench.BasicWorkbenchBlock;
import se.mickelus.tetra.blocks.workbench.WorkbenchContainer;
import se.mickelus.tetra.blocks.workbench.WorkbenchTile;
import se.mickelus.tetra.client.model.ModularModelLoader;
import se.mickelus.tetra.compat.curios.CuriosCompat;
import se.mickelus.tetra.crafting.ScrollIngredient;
import se.mickelus.tetra.craftingeffect.CraftingEffectRegistry;
import se.mickelus.tetra.craftingeffect.condition.CraftTypeCondition;
import se.mickelus.tetra.craftingeffect.condition.LockedCondition;
import se.mickelus.tetra.craftingeffect.condition.MaterialCondition;
import se.mickelus.tetra.craftingeffect.condition.ToolCondition;
import se.mickelus.tetra.craftingeffect.outcome.ApplyImprovementOutcome;
import se.mickelus.tetra.craftingeffect.outcome.MaterialReductionOutcome;
import se.mickelus.tetra.craftingeffect.outcome.RemoveImprovementOutcome;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.data.UpdateDataPacket;
import se.mickelus.tetra.data.provider.ModuleProvider;
import se.mickelus.tetra.effect.ItemEffectHandler;
import se.mickelus.tetra.effect.LungeEchoPacket;
import se.mickelus.tetra.effect.TruesweepPacket;
import se.mickelus.tetra.effect.howling.HowlingPacket;
import se.mickelus.tetra.effect.howling.HowlingPotionEffect;
import se.mickelus.tetra.effect.potion.BleedingPotionEffect;
import se.mickelus.tetra.effect.potion.EarthboundPotionEffect;
import se.mickelus.tetra.effect.potion.ExhaustedPotionEffect;
import se.mickelus.tetra.effect.potion.PriedPotionEffect;
import se.mickelus.tetra.effect.potion.PuncturedPotionEffect;
import se.mickelus.tetra.effect.potion.SeveredPotionEffect;
import se.mickelus.tetra.effect.potion.SmallAbsorbPotionEffect;
import se.mickelus.tetra.effect.potion.SmallHealthPotionEffect;
import se.mickelus.tetra.effect.potion.SmallStrengthPotionEffect;
import se.mickelus.tetra.effect.potion.SteeledPotionEffect;
import se.mickelus.tetra.effect.potion.StunPotionEffect;
import se.mickelus.tetra.effect.potion.UnwaveringPotionEffect;
import se.mickelus.tetra.effect.revenge.AddRevengePacket;
import se.mickelus.tetra.effect.revenge.RemoveRevengePacket;
import se.mickelus.tetra.generation.FeatureEntry;
import se.mickelus.tetra.generation.TGenCommand;
import se.mickelus.tetra.items.ITetraItem;
import se.mickelus.tetra.items.TetraItemGroup;
import se.mickelus.tetra.items.cell.ItemCellMagmatic;
import se.mickelus.tetra.items.forged.CombustionChamberItem;
import se.mickelus.tetra.items.forged.EarthpiercerItem;
import se.mickelus.tetra.items.forged.InsulatedPlateItem;
import se.mickelus.tetra.items.forged.ItemBeam;
import se.mickelus.tetra.items.forged.ItemBolt;
import se.mickelus.tetra.items.forged.ItemMesh;
import se.mickelus.tetra.items.forged.ItemMetalScrap;
import se.mickelus.tetra.items.forged.ItemQuickLatch;
import se.mickelus.tetra.items.forged.LubricantDispenser;
import se.mickelus.tetra.items.forged.PlanarStabilizerItem;
import se.mickelus.tetra.items.forged.StonecutterItem;
import se.mickelus.tetra.items.forged.VibrationDebuffer;
import se.mickelus.tetra.items.loot.DragonSinewItem;
import se.mickelus.tetra.items.modular.ChargedAbilityPacket;
import se.mickelus.tetra.items.modular.ItemPredicateModular;
import se.mickelus.tetra.items.modular.MaterialItemPredicate;
import se.mickelus.tetra.items.modular.SecondaryAbilityPacket;
import se.mickelus.tetra.items.modular.ThrownModularItemEntity;
import se.mickelus.tetra.items.modular.impl.ModularBladedItem;
import se.mickelus.tetra.items.modular.impl.ModularDoubleHeadedItem;
import se.mickelus.tetra.items.modular.impl.ModularSingleHeadedItem;
import se.mickelus.tetra.items.modular.impl.bow.ModularBowItem;
import se.mickelus.tetra.items.modular.impl.bow.ProjectileMotionPacket;
import se.mickelus.tetra.items.modular.impl.crossbow.ModularCrossbowItem;
import se.mickelus.tetra.items.modular.impl.holo.ModularHolosphereItem;
import se.mickelus.tetra.items.modular.impl.shield.ModularShieldItem;
import se.mickelus.tetra.items.modular.impl.toolbelt.ModularToolbeltItem;
import se.mickelus.tetra.items.modular.impl.toolbelt.ToolbeltContainer;
import se.mickelus.tetra.items.modular.impl.toolbelt.ToolbeltModule;
import se.mickelus.tetra.items.modular.impl.toolbelt.suspend.SuspendPotionEffect;
import se.mickelus.tetra.loot.FortuneBonusCondition;
import se.mickelus.tetra.loot.ReplaceTableModifier;
import se.mickelus.tetra.loot.ScrollDataFunction;
import se.mickelus.tetra.module.BasicMajorModule;
import se.mickelus.tetra.module.BasicModule;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.module.ModuleDevCommand;
import se.mickelus.tetra.module.ModuleRegistry;
import se.mickelus.tetra.module.MultiSlotMajorModule;
import se.mickelus.tetra.module.MultiSlotModule;
import se.mickelus.tetra.module.RepairRegistry;
import se.mickelus.tetra.module.SchematicRegistry;
import se.mickelus.tetra.module.improvement.DestabilizationEffect;
import se.mickelus.tetra.module.improvement.HonePacket;
import se.mickelus.tetra.module.improvement.SettlePacket;
import se.mickelus.tetra.module.schematic.BookEnchantSchematic;
import se.mickelus.tetra.module.schematic.CleanseSchematic;
import se.mickelus.tetra.network.PacketHandler;
import se.mickelus.tetra.properties.TetraAttributes;
import se.mickelus.tetra.proxy.ClientProxy;
import se.mickelus.tetra.proxy.IProxy;
import se.mickelus.tetra.proxy.ServerProxy;
import se.mickelus.tetra.trades.TradeHandler;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
@Mod(value="tetra")
public class TetraMod {
    private static final Logger logger = LogManager.getLogger();
    public static final String MOD_ID = "tetra";
    public static IProxy proxy = (IProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    public static TetraMod instance;
    private static Item[] items;
    private static Block[] blocks;
    public static PacketHandler packetHandler;

    public TetraMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(CuriosCompat::enqueueIMC);
        TetraAttributes.registry.register(FMLJavaModLoadingContext.get().getModEventBus());
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new ItemEffectHandler());
        MinecraftForge.EVENT_BUS.register((Object)new TradeHandler());
        MinecraftForge.EVENT_BUS.register((Object)new DataManager());
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        MinecraftForge.EVENT_BUS.register((Object)new VibrationDebuffer());
        MinecraftForge.EVENT_BUS.register(ServerScheduler.class);
        MinecraftForge.EVENT_BUS.register(ClientScheduler.class);
        if (((Boolean)ConfigHandler.enableLookTrigger.get()).booleanValue()) {
            MinecraftForge.EVENT_BUS.register((Object)BlockLookTrigger.instance);
        }
        ConfigHandler.setup();
        ItemPredicate.register((ResourceLocation)new ResourceLocation("tetra:modular_item"), ItemPredicateModular::new);
        ItemPredicate.register((ResourceLocation)new ResourceLocation("tetra:material"), MaterialItemPredicate::new);
        ItemPredicate.register((ResourceLocation)new ResourceLocation("tetra:loose"), LooseItemPredicate::new);
        Registry.func_218322_a((Registry)Registry.field_239704_ba_, (ResourceLocation)FortuneBonusCondition.identifier, (Object)FortuneBonusCondition.type);
        Registry.func_218322_a((Registry)Registry.field_239694_aZ_, (ResourceLocation)ScrollDataFunction.identifier, (Object)ScrollDataFunction.type);
        new CraftingEffectRegistry();
        CraftingEffectRegistry.registerConditionType("tetra:craft_type", CraftTypeCondition.class);
        CraftingEffectRegistry.registerConditionType("tetra:locked", LockedCondition.class);
        CraftingEffectRegistry.registerConditionType("tetra:material", MaterialCondition.class);
        CraftingEffectRegistry.registerConditionType("tetra:tool", ToolCondition.class);
        CraftingEffectRegistry.registerEffectType("tetra:apply_improvements", ApplyImprovementOutcome.class);
        CraftingEffectRegistry.registerEffectType("tetra:remove_improvements", RemoveImprovementOutcome.class);
        CraftingEffectRegistry.registerEffectType("tetra:material_reduction", MaterialReductionOutcome.class);
        new RepairRegistry();
        SchematicRegistry schematicRegistry = new SchematicRegistry();
        schematicRegistry.registerSchematic(new BookEnchantSchematic());
        new ItemUpgradeRegistry();
        ModuleRegistry moduleRegistry = new ModuleRegistry();
        moduleRegistry.registerModuleType(new ResourceLocation(MOD_ID, "basic_module"), BasicModule::new);
        moduleRegistry.registerModuleType(new ResourceLocation(MOD_ID, "multi_module"), MultiSlotModule::new);
        moduleRegistry.registerModuleType(new ResourceLocation(MOD_ID, "basic_major_module"), BasicMajorModule::new);
        moduleRegistry.registerModuleType(new ResourceLocation(MOD_ID, "multi_major_module"), MultiSlotMajorModule::new);
        moduleRegistry.registerModuleType(new ResourceLocation(MOD_ID, "toolbelt_module"), ToolbeltModule::new);
        new TetraItemGroup();
        CriteriaTriggers.func_192118_a((ICriterionTrigger)BlockLookTrigger.instance);
        CriteriaTriggers.func_192118_a(BlockUseCriterion.trigger);
        CriteriaTriggers.func_192118_a(BlockInteractionCriterion.trigger);
        CriteriaTriggers.func_192118_a(ModuleCraftCriterion.trigger);
        CriteriaTriggers.func_192118_a(ImprovementCraftCriterion.trigger);
        RolledScrollBlock scrollRolled = new RolledScrollBlock();
        blocks = new Block[]{new BasicWorkbenchBlock(), new GeodeBlock(), new HammerHeadBlock(), new HammerBaseBlock(), new BlockForgedWall(), new BlockForgedPillar(), new BlockForgedPlatform(), new BlockForgedPlatformSlab(), new ForgedVentBlock(), new ForgedWorkbenchBlock(), new ForgedContainerBlock(), new ForgedCrateBlock(), new TransferUnitBlock(), new CoreExtractorBaseBlock(), new CoreExtractorPistonBlock(), new CoreExtractorPipeBlock(), new SeepingBedrockBlock(), new RackBlock(), new ChthonicExtractorBlock(), new FracturedBedrockBlock(), new DepletedBedrockBlock(), scrollRolled, new WallScrollBlock(), new OpenScrollBlock()};
        items = new Item[]{new ModularBladedItem(), new ModularDoubleHeadedItem(), new GeodeItem(), new PristineLapisItem(), new PristineEmeraldItem(), new PristineDiamondItem(), new ModularToolbeltItem(), new ItemCellMagmatic(), new ItemBolt(), new ItemBeam(), new ItemMesh(), new ItemQuickLatch(), new ItemMetalScrap(), new InsulatedPlateItem(), new CombustionChamberItem(), new PlanarStabilizerItem(), new LubricantDispenser(), new ModularHolosphereItem(), new EarthpiercerItem(), new DragonSinewItem(), new ScrollItem(scrollRolled)};
        if (((Boolean)ConfigHandler.enableBow.get()).booleanValue()) {
            items = (Item[])ArrayUtils.addAll((Object[])items, (Object[])new Item[]{new ModularBowItem()});
        }
        if (((Boolean)ConfigHandler.enableCrossbow.get()).booleanValue()) {
            items = (Item[])ArrayUtils.addAll((Object[])items, (Object[])new Item[]{new ModularCrossbowItem()});
        }
        if (((Boolean)ConfigHandler.enableSingle.get()).booleanValue()) {
            items = (Item[])ArrayUtils.addAll((Object[])items, (Object[])new Item[]{new ModularSingleHeadedItem()});
        }
        if (((Boolean)ConfigHandler.enableShield.get()).booleanValue()) {
            items = (Item[])ArrayUtils.addAll((Object[])items, (Object[])new Item[]{new ModularShieldItem()});
        }
        if (((Boolean)ConfigHandler.enableStonecutter.get()).booleanValue()) {
            items = (Item[])ArrayUtils.addAll((Object[])items, (Object[])new Item[]{new StonecutterItem()});
        }
        proxy.preInit((ITetraItem[])Arrays.stream(items).filter(item -> item instanceof ITetraItem).map(item -> (ITetraItem)item).toArray(ITetraItem[]::new), (ITetraBlock[])Arrays.stream(blocks).filter(block -> block instanceof ITetraBlock).map(block -> (ITetraBlock)block).toArray(ITetraBlock[]::new));
    }

    public void setup(FMLCommonSetupEvent event) {
        proxy.init(event, (ITetraItem[])Arrays.stream(items).filter(item -> item instanceof ITetraItem).map(item -> (ITetraItem)item).toArray(ITetraItem[]::new), (ITetraBlock[])Arrays.stream(blocks).filter(block -> block instanceof ITetraBlock).map(block -> (ITetraBlock)block).toArray(ITetraBlock[]::new));
        packetHandler = new PacketHandler(MOD_ID, "main");
        Arrays.stream(items).filter(item -> item instanceof ITetraItem).map(item -> (ITetraItem)item).forEach(item -> item.init(packetHandler));
        Arrays.stream(blocks).filter(block -> block instanceof ITetraBlock).map(block -> (ITetraBlock)block).forEach(block -> block.init(packetHandler));
        packetHandler.registerPacket(HonePacket.class, HonePacket::new);
        packetHandler.registerPacket(SettlePacket.class, SettlePacket::new);
        packetHandler.registerPacket(UpdateDataPacket.class, UpdateDataPacket::new);
        packetHandler.registerPacket(SecondaryAbilityPacket.class, SecondaryAbilityPacket::new);
        packetHandler.registerPacket(ChargedAbilityPacket.class, ChargedAbilityPacket::new);
        packetHandler.registerPacket(TruesweepPacket.class, TruesweepPacket::new);
        packetHandler.registerPacket(HowlingPacket.class, HowlingPacket::new);
        packetHandler.registerPacket(ProjectileMotionPacket.class, ProjectileMotionPacket::new);
        packetHandler.registerPacket(AddRevengePacket.class, AddRevengePacket::new);
        packetHandler.registerPacket(RemoveRevengePacket.class, RemoveRevengePacket::new);
        packetHandler.registerPacket(LungeEchoPacket.class, LungeEchoPacket::new);
        WorkbenchTile.init(packetHandler);
        proxy.postInit();
        DestabilizationEffect.init();
        SchematicRegistry.instance.registerSchematic(new CleanseSchematic());
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation(MOD_ID, "feature"), FeatureEntry.configuredInstance);
    }

    @SubscribeEvent
    public void serverStarting(FMLServerAboutToStartEvent event) {
        FeatureEntry.instance.setup(event.getServer());
    }

    @SubscribeEvent
    public void serverStarting(FMLServerStartingEvent event) {
        ModuleDevCommand.register((CommandDispatcher<CommandSource>)event.getServer().func_195571_aL().func_197054_a());
        TGenCommand.register((CommandDispatcher<CommandSource>)event.getServer().func_195571_aL().func_197054_a());
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void provideTextures(TextureStitchEvent.Pre event) {
        if (AtlasTexture.field_110575_b.equals((Object)event.getMap().func_229223_g_())) {
            Minecraft.func_71410_x().func_195551_G().func_199003_a("textures/items/module", s -> s.endsWith(".png")).stream().filter(resourceLocation -> MOD_ID.equals(resourceLocation.func_110624_b())).map(rl -> new ResourceLocation(rl.func_110624_b(), rl.func_110623_a().substring(9, rl.func_110623_a().length() - 4))).forEach(arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0));
            event.addSprite(ForgedContainerRenderer.material.func_229313_b_());
            event.addSprite(HammerBaseRenderer.material.func_229313_b_());
            event.addSprite(ScrollRenderer.material.func_229313_b_());
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void modelRegistryReady(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation(MOD_ID, "modular_loader"), (IModelLoader)new ModularModelLoader());
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator dataGenerator = event.getGenerator();
        if (event.includeServer()) {
            dataGenerator.func_200390_a((IDataProvider)new ModuleProvider(dataGenerator, event.getExistingFileHelper()));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBiomeLoading(BiomeLoadingEvent event) {
        GeodeBlock.registerFeature(event.getGeneration());
        if (((Boolean)ConfigHandler.generateFeatures.get()).booleanValue()) {
            FeatureEntry.instance.registerFeatures(event);
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
            event.getRegistry().register((IForgeRegistryEntry)FeatureEntry.instance);
        }

        @SubscribeEvent
        public static void registerModifierSerializers(RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
            event.getRegistry().register((IForgeRegistryEntry)new ReplaceTableModifier.Serializer().setRegistryName(new ResourceLocation(TetraMod.MOD_ID, "replace_table")));
        }

        @SubscribeEvent
        public static void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
            CraftingHelper.register((ResourceLocation)new ResourceLocation(TetraMod.MOD_ID, "scroll"), (IIngredientSerializer)ScrollIngredient.Serializer.INSTANCE);
        }

        @SubscribeEvent
        public static void registerEffects(RegistryEvent.Register<Effect> event) {
            event.getRegistry().register((IForgeRegistryEntry)new BleedingPotionEffect());
            event.getRegistry().register((IForgeRegistryEntry)new EarthboundPotionEffect());
            event.getRegistry().register((IForgeRegistryEntry)new StunPotionEffect());
            event.getRegistry().register((IForgeRegistryEntry)new HowlingPotionEffect());
            event.getRegistry().register((IForgeRegistryEntry)new SeveredPotionEffect());
            event.getRegistry().register((IForgeRegistryEntry)new PuncturedPotionEffect());
            event.getRegistry().register((IForgeRegistryEntry)new PriedPotionEffect());
            event.getRegistry().register((IForgeRegistryEntry)new ExhaustedPotionEffect());
            event.getRegistry().register((IForgeRegistryEntry)new SteeledPotionEffect());
            event.getRegistry().register((IForgeRegistryEntry)new SmallStrengthPotionEffect());
            event.getRegistry().register((IForgeRegistryEntry)new UnwaveringPotionEffect());
            event.getRegistry().register((IForgeRegistryEntry)new SmallHealthPotionEffect());
            event.getRegistry().register((IForgeRegistryEntry)new SmallAbsorbPotionEffect());
            event.getRegistry().register((IForgeRegistryEntry)new SuspendPotionEffect());
        }

        @SubscribeEvent
        public static void registerContainerTypes(RegistryEvent.Register<ContainerType<?>> event) {
            ContainerType toolbeltContainerType = (ContainerType)IForgeContainerType.create((windowId, inv, data) -> ToolbeltContainer.create(windowId, inv)).setRegistryName(TetraMod.MOD_ID, "modular_toolbelt");
            event.getRegistry().register((IForgeRegistryEntry)toolbeltContainerType);
            ContainerType workbenchContainerType = (ContainerType)IForgeContainerType.create((windowId, inv, data) -> {
                BlockPos pos = data.func_179259_c();
                return WorkbenchContainer.create(windowId, pos, inv);
            }).setRegistryName(TetraMod.MOD_ID, "workbench");
            event.getRegistry().register((IForgeRegistryEntry)workbenchContainerType);
            ContainerType forgedContainerContainerType = (ContainerType)IForgeContainerType.create((windowId, inv, data) -> {
                BlockPos pos = data.func_179259_c();
                return ForgedContainerContainer.create(windowId, pos, inv);
            }).setRegistryName(TetraMod.MOD_ID, "forged_container");
            event.getRegistry().register((IForgeRegistryEntry)forgedContainerContainerType);
        }

        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])blocks);
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])items);
            Arrays.stream(blocks).filter(block -> block instanceof ITetraBlock).map(block -> (ITetraBlock)block).filter(ITetraBlock::hasItem).forEach(block -> block.registerItem((IForgeRegistry<Item>)event.getRegistry()));
        }

        @SubscribeEvent
        public static void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(WorkbenchTile::new, (Block[])new Block[]{BasicWorkbenchBlock.instance, ForgedWorkbenchBlock.instance}).func_206865_a(null).setRegistryName(TetraMod.MOD_ID, "workbench"));
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(HammerBaseTile::new, (Block[])new Block[]{HammerBaseBlock.instance}).func_206865_a(null).setRegistryName(TetraMod.MOD_ID, "hammer_base"));
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(HammerHeadTile::new, (Block[])new Block[]{HammerHeadBlock.instance}).func_206865_a(null).setRegistryName(TetraMod.MOD_ID, "hammer_head"));
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(TransferUnitTile::new, (Block[])new Block[]{TransferUnitBlock.instance}).func_206865_a(null).setRegistryName(TetraMod.MOD_ID, "transfer_unit"));
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(CoreExtractorBaseTile::new, (Block[])new Block[]{CoreExtractorBaseBlock.instance}).func_206865_a(null).setRegistryName(TetraMod.MOD_ID, "core_extractor"));
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(CoreExtractorPistonTile::new, (Block[])new Block[]{CoreExtractorPistonBlock.instance}).func_206865_a(null).setRegistryName(TetraMod.MOD_ID, "extractor_piston"));
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(ForgedContainerTile::new, (Block[])new Block[]{ForgedContainerBlock.instance}).func_206865_a(null).setRegistryName(TetraMod.MOD_ID, "forged_container"));
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(ChthonicExtractorTile::new, (Block[])new Block[]{ChthonicExtractorBlock.instance}).func_206865_a(null).setRegistryName(TetraMod.MOD_ID, "chthonic_extractor"));
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(FracturedBedrockTile::new, (Block[])new Block[]{FracturedBedrockBlock.instance}).func_206865_a(null).setRegistryName(TetraMod.MOD_ID, "fractured_bedrock"));
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(RackTile::new, (Block[])new Block[]{RackBlock.instance}).func_206865_a(null).setRegistryName(TetraMod.MOD_ID, "rack"));
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(ScrollTile::new, (Block[])new Block[]{OpenScrollBlock.instance, WallScrollBlock.instance, RolledScrollBlock.instance}).func_206865_a(null).setRegistryName(TetraMod.MOD_ID, "scroll"));
        }

        @SubscribeEvent
        public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityType[]{(EntityType)EntityType.Builder.func_220322_a(ThrownModularItemEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(ThrownModularItemEntity::new).func_220321_a(0.5f, 0.5f).func_206830_a("thrown_modular_item").setRegistryName(TetraMod.MOD_ID, "thrown_modular_item")});
            event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityType[]{(EntityType)EntityType.Builder.func_220322_a(ExtractorProjectileEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(ExtractorProjectileEntity::new).func_220321_a(0.5f, 0.5f).func_206830_a("extractor_projectile").setRegistryName(TetraMod.MOD_ID, "extractor_projectile")});
        }
    }
}

