/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.items;

import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.api.event.ProjectorEvent;
import flaxbeard.immersivepetroleum.client.ClientProxy;
import flaxbeard.immersivepetroleum.client.ShaderUtil;
import flaxbeard.immersivepetroleum.client.render.IPRenderTypes;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.items.IPItemBase;
import flaxbeard.immersivepetroleum.common.util.projector.MultiblockProjection;
import flaxbeard.immersivepetroleum.common.util.projector.Settings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.lwjgl.glfw.GLFW;

public class ProjectorItem
extends IPItemBase {
    static final Map<Class<? extends MultiblockHandler.IMultiblock>, String> nameCache = new HashMap<Class<? extends MultiblockHandler.IMultiblock>, String>();

    public ProjectorItem(String name) {
        super(name, new Item.Properties().func_200917_a(1));
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        Settings settings;
        String selfKey = this.func_77667_c(stack);
        if (stack.func_77942_o() && (settings = ProjectorItem.getSettings(stack)).getMultiblock() != null) {
            TranslationTextComponent name = new TranslationTextComponent("desc.immersiveengineering.info.multiblock.IE:" + ProjectorItem.getActualMBName(settings.getMultiblock()));
            return new TranslationTextComponent(selfKey + ".specific", new Object[]{name}).func_240699_a_(TextFormatting.GOLD);
        }
        return new TranslationTextComponent(selfKey).func_240699_a_(TextFormatting.GOLD);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        Settings settings = ProjectorItem.getSettings(stack);
        if (settings.getMultiblock() != null) {
            IFormattableTextComponent text;
            Vector3i size = settings.getMultiblock().getSize(worldIn);
            String name = ProjectorItem.getActualMBName(settings.getMultiblock());
            tooltip.add((ITextComponent)new TranslationTextComponent("desc.immersivepetroleum.info.projector.build0"));
            tooltip.add((ITextComponent)new TranslationTextComponent("desc.immersivepetroleum.info.projector.build1", new Object[]{new TranslationTextComponent("desc.immersiveengineering.info.multiblock.IE:" + name)}));
            if (this.isPressing(340) || this.isPressing(344)) {
                IFormattableTextComponent mbSize = new TranslationTextComponent("desc.immersivepetroleum.info.projector.size", new Object[]{size.func_177958_n(), size.func_177956_o(), size.func_177952_p()}).func_240699_a_(TextFormatting.DARK_GRAY);
                tooltip.add((ITextComponent)mbSize);
                Direction dir = Direction.func_176731_b((int)settings.getRotation().ordinal());
                IFormattableTextComponent rotation = new TranslationTextComponent("desc.immersivepetroleum.info.projector.rotated." + dir).func_240699_a_(TextFormatting.DARK_GRAY);
                IFormattableTextComponent flip = settings.isMirrored() ? new TranslationTextComponent("desc.immersivepetroleum.info.projector.flipped.true").func_240699_a_(TextFormatting.DARK_GRAY) : new TranslationTextComponent("desc.immersivepetroleum.info.projector.flipped.false").func_240699_a_(TextFormatting.DARK_GRAY);
                if (settings.getPos() != null) {
                    int x = settings.getPos().func_177958_n();
                    int y = settings.getPos().func_177956_o();
                    int z = settings.getPos().func_177952_p();
                    tooltip.add((ITextComponent)new TranslationTextComponent("desc.immersivepetroleum.info.projector.center", new Object[]{x, y, z}).func_240699_a_(TextFormatting.DARK_GRAY));
                }
                tooltip.add((ITextComponent)rotation);
                tooltip.add((ITextComponent)flip);
            } else {
                text = new StringTextComponent("[").func_230529_a_((ITextComponent)new TranslationTextComponent("desc.immersivepetroleum.info.projector.holdshift")).func_240702_b_("] ").func_230529_a_((ITextComponent)new TranslationTextComponent("desc.immersivepetroleum.info.projector.holdshift.text")).func_240699_a_(TextFormatting.DARK_AQUA);
                tooltip.add((ITextComponent)text);
            }
            if (this.isPressing(341) || this.isPressing(345)) {
                IFormattableTextComponent ctrl0 = new TranslationTextComponent("desc.immersivepetroleum.info.projector.control1").func_240699_a_(TextFormatting.DARK_GRAY);
                IFormattableTextComponent ctrl1 = new TranslationTextComponent("desc.immersivepetroleum.info.projector.control2", new Object[]{ClientProxy.keybind_preview_flip.func_238171_j_()}).func_240699_a_(TextFormatting.DARK_GRAY);
                IFormattableTextComponent ctrl2 = new TranslationTextComponent("desc.immersivepetroleum.info.projector.control3").func_240699_a_(TextFormatting.DARK_GRAY);
                tooltip.add((ITextComponent)ctrl0);
                tooltip.add((ITextComponent)ctrl1);
                tooltip.add((ITextComponent)ctrl2);
            } else {
                text = new StringTextComponent("[").func_230529_a_((ITextComponent)new TranslationTextComponent("desc.immersivepetroleum.info.projector.holdctrl")).func_240702_b_("] ").func_230529_a_((ITextComponent)new TranslationTextComponent("desc.immersivepetroleum.info.projector.holdctrl.text")).func_240699_a_(TextFormatting.DARK_PURPLE);
                tooltip.add((ITextComponent)text);
            }
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("desc.immersivepetroleum.info.projector.noMultiblock"));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean isPressing(int key) {
        long window = Minecraft.func_71410_x().func_228018_at_().func_198092_i();
        return GLFW.glfwGetKey((long)window, (int)key) == 1;
    }

    public static String getActualMBName(MultiblockHandler.IMultiblock multiblock) {
        if (!nameCache.containsKey(multiblock.getClass())) {
            String name = multiblock.getClass().getSimpleName();
            switch (name = name.substring(0, name.indexOf("Multiblock"))) {
                case "LightningRod": {
                    name = "Lightningrod";
                    break;
                }
                case "ImprovedBlastfurnace": {
                    name = "BlastFurnaceAdvanced";
                }
            }
            nameCache.put(multiblock.getClass(), name);
        }
        return nameCache.get(multiblock.getClass());
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)new ItemStack((IItemProvider)this, 1));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack held = playerIn.func_184586_b(handIn);
        boolean changeMode = false;
        Settings settings = ProjectorItem.getSettings(held);
        switch (settings.getMode()) {
            case PROJECTION: {
                if (!worldIn.field_72995_K || !playerIn.func_225608_bj_()) break;
                if (settings.getPos() != null) {
                    settings.setPos(null);
                    settings.sendPacketToServer(handIn);
                    break;
                }
                changeMode = true;
                break;
            }
            case MULTIBLOCK_SELECTION: {
                if (!worldIn.field_72995_K) break;
                if (!playerIn.func_225608_bj_()) {
                    ImmersivePetroleum.proxy.openProjectorGui(handIn, held);
                    break;
                }
                changeMode = true;
                break;
            }
        }
        if (worldIn.field_72995_K && changeMode) {
            int modeId = settings.getMode().ordinal() + 1;
            settings.setMode(Settings.Mode.values()[modeId >= Settings.Mode.values().length ? 0 : modeId]);
            settings.applyTo(held);
            settings.sendPacketToServer(handIn);
            playerIn.func_146105_b(settings.getMode().getTranslated(), true);
        }
        return ActionResult.func_226248_a_((Object)held);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        PlayerEntity playerIn = context.func_195999_j();
        Hand hand = context.func_221531_n();
        BlockPos pos = context.func_195995_a();
        Direction facing = context.func_196000_l();
        ItemStack stack = playerIn.func_184586_b(hand);
        Settings settings = ProjectorItem.getSettings(stack);
        if (playerIn.func_225608_bj_() && settings.getPos() != null) {
            if (world.field_72995_K) {
                settings.setPos(null);
                settings.applyTo(stack);
                settings.sendPacketToServer(hand);
            }
            return ActionResultType.SUCCESS;
        }
        if (settings.getMode() == Settings.Mode.PROJECTION && settings.getPos() == null && settings.getMultiblock() != null) {
            BlockState state = world.func_180495_p(pos);
            BlockPos.Mutable hit = pos.func_239590_i_();
            if (!state.func_185904_a().func_76222_j() && facing == Direction.UP) {
                hit.func_239621_a_((Vector3i)hit, 0, 1, 0);
            }
            Vector3i size = settings.getMultiblock().getSize(world);
            ProjectorItem.alignHit(hit, playerIn, size, settings.getRotation(), settings.isMirrored());
            if (playerIn.func_225608_bj_() && playerIn.func_184812_l_()) {
                if (!world.field_72995_K) {
                    if (settings.getMultiblock().getUniqueName().func_110623_a().contains("excavator_demo") || settings.getMultiblock().getUniqueName().func_110623_a().contains("bucket_wheel")) {
                        hit.func_239621_a_((Vector3i)hit, 0, -2, 0);
                    }
                    Predicate<MultiblockProjection.Info> pred = layer -> {
                        BlockState tstate = layer.blockAccess.func_180495_p(layer.templatePos);
                        ProjectorEvent.PlaceBlock event = new ProjectorEvent.PlaceBlock(layer.blockAccess, layer.templatePos, world, layer.tPos, tstate = tstate.rotate((IWorld)world, pos, settings.getRotation()), settings.getRotation());
                        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                            tstate = event.getState();
                            world.func_175656_a(layer.tPos.func_177971_a((Vector3i)hit), tstate);
                            ProjectorEvent.PlaceBlockPost postEvent = new ProjectorEvent.PlaceBlockPost(layer.blockAccess, event.getTemplatePos(), world, layer.tPos, event.getState(), settings.getRotation());
                            MinecraftForge.EVENT_BUS.post((Event)postEvent);
                        }
                        return false;
                    };
                    MultiblockProjection projection = new MultiblockProjection(world, settings.getMultiblock());
                    projection.setFlip(settings.isMirrored());
                    projection.setRotation(settings.getRotation());
                    for (int i = 0; i < projection.getLayerCount(); ++i) {
                        projection.process(i, pred);
                    }
                }
                return ActionResultType.SUCCESS;
            }
            if (world.field_72995_K) {
                settings.setPos((BlockPos)hit);
                settings.applyTo(stack);
                settings.sendPacketToServer(hand);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public static Settings getSettings(@Nullable ItemStack stack) {
        return new Settings(stack);
    }

    private static void alignHit(BlockPos.Mutable hit, PlayerEntity playerIn, Vector3i size, Rotation rotation, boolean mirror) {
        int x = (rotation.ordinal() % 2 == 0 ? size.func_177958_n() : size.func_177952_p()) / 2;
        int z = (rotation.ordinal() % 2 == 0 ? size.func_177952_p() : size.func_177958_n()) / 2;
        Direction facing = playerIn.func_174811_aO();
        switch (facing) {
            case NORTH: {
                hit.func_239621_a_((Vector3i)hit, 0, 0, -z);
                break;
            }
            case SOUTH: {
                hit.func_239621_a_((Vector3i)hit, 0, 0, z);
                break;
            }
            case EAST: {
                hit.func_239621_a_((Vector3i)hit, x, 0, 0);
                break;
            }
            case WEST: {
                hit.func_239621_a_((Vector3i)hit, -x, 0, 0);
                break;
            }
        }
    }

    private static class RenderInfo {
        public final Layer layer;
        public final MultiblockProjection.IMultiblockBlockReader blockAccess;
        public final BlockPos templatePos;
        public final BlockPos worldPos;
        public final PlacementSettings settings;

        public RenderInfo(Layer layer, MultiblockProjection.IMultiblockBlockReader blockAccess, BlockPos templatePos, PlacementSettings settings, BlockPos worldPos) {
            this.layer = layer;
            this.blockAccess = blockAccess;
            this.templatePos = templatePos;
            this.worldPos = worldPos;
            this.settings = settings;
        }

        public BlockState getState() {
            return this.blockAccess.func_180495_p(this.templatePos);
        }

        public static enum Layer {
            ALL,
            BAD,
            PERFECT;

        }
    }

    @Mod.EventBusSubscriber(modid="immersivepetroleum", value={Dist.CLIENT})
    public static class ClientInputHandler {
        static boolean shiftHeld = false;

        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            if (event.side == LogicalSide.CLIENT && event.player != null && event.player == ClientUtils.mc().func_175606_aa() && event.phase == TickEvent.Phase.END && !ClientProxy.keybind_preview_flip.func_197986_j() && ClientProxy.keybind_preview_flip.func_151468_f()) {
                ClientInputHandler.doAFlip();
            }
        }

        @SubscribeEvent
        public static void handleScroll(InputEvent.MouseScrollEvent event) {
            double delta = event.getScrollDelta();
            if (shiftHeld && delta != 0.0) {
                boolean off;
                ClientPlayerEntity player = ClientUtils.mc().field_71439_g;
                ItemStack mainItem = player.func_184614_ca();
                ItemStack secondItem = player.func_184592_cb();
                boolean main = !mainItem.func_190926_b() && mainItem.func_77973_b() == IPContent.Items.projector && ItemNBTHelper.hasKey((ItemStack)mainItem, (String)"settings", (int)10);
                boolean bl = off = !secondItem.func_190926_b() && secondItem.func_77973_b() == IPContent.Items.projector && ItemNBTHelper.hasKey((ItemStack)secondItem, (String)"settings", (int)10);
                if (main || off) {
                    ItemStack target;
                    ItemStack itemStack = target = main ? mainItem : secondItem;
                    if (shiftHeld) {
                        Settings settings = ProjectorItem.getSettings(target);
                        if (delta > 0.0) {
                            settings.rotateCCW();
                        } else {
                            settings.rotateCW();
                        }
                        settings.applyTo(target);
                        settings.sendPacketToServer(main ? Hand.MAIN_HAND : Hand.OFF_HAND);
                        Direction facing = Direction.func_176731_b((int)settings.getRotation().ordinal());
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("desc.immersivepetroleum.info.projector.rotated." + facing), true);
                        event.setCanceled(true);
                    }
                }
            }
        }

        @SubscribeEvent
        public static void handleKey(InputEvent.KeyInputEvent event) {
            if (event.getKey() == 344 || event.getKey() == 340) {
                switch (event.getAction()) {
                    case 1: {
                        shiftHeld = true;
                        return;
                    }
                    case 0: {
                        shiftHeld = false;
                        return;
                    }
                }
            }
        }

        private static void doAFlip() {
            ItemStack target;
            ClientPlayerEntity player = ClientUtils.mc().field_71439_g;
            ItemStack mainItem = player.func_184614_ca();
            ItemStack secondItem = player.func_184592_cb();
            boolean main = !mainItem.func_190926_b() && mainItem.func_77973_b() == IPContent.Items.projector && ItemNBTHelper.hasKey((ItemStack)mainItem, (String)"settings", (int)10);
            boolean off = !secondItem.func_190926_b() && secondItem.func_77973_b() == IPContent.Items.projector && ItemNBTHelper.hasKey((ItemStack)secondItem, (String)"settings", (int)10);
            ItemStack itemStack = target = main ? mainItem : secondItem;
            if (main || off) {
                Settings settings = ProjectorItem.getSettings(target);
                settings.flip();
                settings.applyTo(target);
                settings.sendPacketToServer(main ? Hand.MAIN_HAND : Hand.OFF_HAND);
                TranslationTextComponent flip = settings.isMirrored() ? new TranslationTextComponent("desc.immersivepetroleum.info.projector.flipped.true") : new TranslationTextComponent("desc.immersivepetroleum.info.projector.flipped.false");
                player.func_146105_b((ITextComponent)flip, true);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="immersivepetroleum", value={Dist.CLIENT})
    public static class ClientRenderHandler {
        static final BlockPos.Mutable FULL_MAX = new BlockPos.Mutable(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);

        @SubscribeEvent
        public static void renderLast(RenderWorldLastEvent event) {
            Minecraft mc = ClientUtils.mc();
            if (mc.field_71439_g != null) {
                MatrixStack matrix = event.getMatrixStack();
                matrix.func_227860_a_();
                Vector3d renderView = ClientUtils.mc().field_71460_t.func_215316_n().func_216785_c();
                matrix.func_227861_a_(-renderView.field_72450_a, -renderView.field_72448_b, -renderView.field_72449_c);
                ItemStack secondItem = mc.field_71439_g.func_184592_cb();
                boolean off = !secondItem.func_190926_b() && secondItem.func_77973_b() == IPContent.Items.projector && ItemNBTHelper.hasKey((ItemStack)secondItem, (String)"settings");
                for (int i = 0; i <= 10; ++i) {
                    ItemStack stack;
                    ItemStack itemStack = stack = i == 10 ? secondItem : mc.field_71439_g.field_71071_by.func_70301_a(i);
                    if (stack.func_190926_b() || stack.func_77973_b() != IPContent.Items.projector || !ItemNBTHelper.hasKey((ItemStack)stack, (String)"settings")) continue;
                    Settings settings = ProjectorItem.getSettings(stack);
                    matrix.func_227860_a_();
                    boolean renderMoving = i == mc.field_71439_g.field_71071_by.field_70461_c || i == 10 && off;
                    ClientRenderHandler.renderSchematic(matrix, settings, (PlayerEntity)mc.field_71439_g, mc.field_71439_g.field_70170_p, event.getPartialTicks(), renderMoving);
                    matrix.func_227865_b_();
                }
                matrix.func_227865_b_();
            }
        }

        public static void renderSchematic(MatrixStack matrix, Settings settings, PlayerEntity player, World world, float partialTicks, boolean renderMoving) {
            if (settings.getMultiblock() == null) {
                return;
            }
            Vector3i size = settings.getMultiblock().getSize(world);
            BlockPos.Mutable hit = new BlockPos.Mutable(FULL_MAX.func_177958_n(), FULL_MAX.func_177956_o(), FULL_MAX.func_177952_p());
            MutableBoolean isPlaced = new MutableBoolean(false);
            if (settings.getPos() != null) {
                hit.func_189533_g((Vector3i)settings.getPos());
                isPlaced.setTrue();
            } else if (renderMoving && ClientUtils.mc().field_71476_x != null && ClientUtils.mc().field_71476_x.func_216346_c() == RayTraceResult.Type.BLOCK) {
                BlockRayTraceResult blockRTResult = (BlockRayTraceResult)ClientUtils.mc().field_71476_x;
                BlockPos pos = blockRTResult.func_216350_a();
                BlockState state = world.func_180495_p(pos);
                if (state.func_185904_a().func_76222_j() || blockRTResult.func_216354_b() != Direction.UP) {
                    hit.func_189533_g((Vector3i)pos);
                } else {
                    hit.func_239621_a_((Vector3i)pos, 0, 1, 0);
                }
                ProjectorItem.alignHit(hit, player, size, settings.getRotation(), settings.isMirrored());
            }
            if (!hit.equals((Object)FULL_MAX)) {
                ResourceLocation name = settings.getMultiblock().getUniqueName();
                if (name.func_110623_a().contains("excavator_demo") || name.func_110623_a().contains("bucket_wheel")) {
                    hit.func_239621_a_((Vector3i)hit, 0, -2, 0);
                }
                MultiblockProjection projection = new MultiblockProjection(world, settings.getMultiblock());
                projection.setRotation(settings.getRotation());
                projection.setFlip(settings.isMirrored());
                ArrayList toRender = new ArrayList();
                MutableInt currentLayer = new MutableInt();
                MutableInt badBlocks = new MutableInt();
                MutableInt goodBlocks = new MutableInt();
                BiPredicate<Integer, MultiblockProjection.Info> bipred = (layer, info) -> {
                    if (badBlocks.getValue() == 0 && layer > currentLayer.getValue()) {
                        currentLayer.setValue((Number)layer);
                    } else if (layer != currentLayer.getValue()) {
                        return true;
                    }
                    if (isPlaced.booleanValue()) {
                        if (layer == currentLayer.getValue()) {
                            boolean skip = false;
                            BlockState toCompare = world.func_180495_p(info.tPos.func_177971_a((Vector3i)hit));
                            if (info.blockAccess.func_180495_p(info.templatePos).func_177230_c() == toCompare.func_177230_c()) {
                                toRender.add(new RenderInfo(RenderInfo.Layer.PERFECT, info.blockAccess, info.templatePos, info.settings, info.tPos));
                                goodBlocks.increment();
                                skip = true;
                            } else {
                                if (toCompare.func_177230_c() != Blocks.field_150350_a) {
                                    toRender.add(new RenderInfo(RenderInfo.Layer.BAD, info.blockAccess, info.templatePos, info.settings, info.tPos));
                                    skip = true;
                                }
                                badBlocks.increment();
                            }
                            if (!skip) {
                                toRender.add(new RenderInfo(RenderInfo.Layer.ALL, info.blockAccess, info.templatePos, info.settings, info.tPos));
                            }
                        }
                    } else {
                        toRender.add(new RenderInfo(RenderInfo.Layer.ALL, info.blockAccess, info.templatePos, info.settings, info.tPos));
                    }
                    return false;
                };
                projection.processAll(bipred);
                boolean perfect = goodBlocks.getValue().intValue() == projection.getBlockCount();
                BlockPos.Mutable min = new BlockPos.Mutable(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
                BlockPos.Mutable max = new BlockPos.Mutable(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
                float flicker = world.field_73012_v.nextInt(10) == 0 ? 0.75f : (world.field_73012_v.nextInt(20) == 0 ? 0.5f : 1.0f);
                matrix.func_227861_a_((double)hit.func_177958_n(), (double)hit.func_177956_o(), (double)hit.func_177952_p());
                toRender.sort((a, b) -> {
                    if (a.layer.ordinal() > b.layer.ordinal()) {
                        return 1;
                    }
                    if (a.layer.ordinal() < b.layer.ordinal()) {
                        return -1;
                    }
                    return 0;
                });
                ItemStack heldStack = player.func_184614_ca();
                for (RenderInfo rInfo : toRender) {
                    switch (rInfo.layer) {
                        case ALL: {
                            float alpha = heldStack.func_77973_b() == rInfo.getState().func_177230_c().func_199767_j() ? 0.75f : 0.25f;
                            matrix.func_227860_a_();
                            ClientRenderHandler.renderPhantom(matrix, projection.getMultiblockBlockAccess(), world, rInfo.templatePos, rInfo.worldPos, rInfo.settings.func_186215_c(), settings.isMirrored(), flicker, alpha, partialTicks);
                            matrix.func_227865_b_();
                            break;
                        }
                        case BAD: {
                            matrix.func_227860_a_();
                            matrix.func_227861_a_((double)rInfo.worldPos.func_177958_n(), (double)rInfo.worldPos.func_177956_o(), (double)rInfo.worldPos.func_177952_p());
                            ClientRenderHandler.renderCenteredOutlineBox(matrix, 0xFF0000, flicker);
                            matrix.func_227865_b_();
                            break;
                        }
                        case PERFECT: {
                            int x = rInfo.worldPos.func_177958_n();
                            int y = rInfo.worldPos.func_177956_o();
                            int z = rInfo.worldPos.func_177952_p();
                            min.func_181079_c(x < min.func_177958_n() ? x : min.func_177958_n(), y < min.func_177956_o() ? y : min.func_177956_o(), z < min.func_177952_p() ? z : min.func_177952_p());
                            max.func_181079_c(x > max.func_177958_n() ? x : max.func_177958_n(), y > max.func_177956_o() ? y : max.func_177956_o(), z > max.func_177952_p() ? z : max.func_177952_p());
                            break;
                        }
                    }
                }
                if (perfect) {
                    matrix.func_227860_a_();
                    ClientRenderHandler.renderOutlineBox(matrix, (Vector3i)min, (Vector3i)max, 48896, flicker);
                    matrix.func_227865_b_();
                    if (!player.func_184592_cb().func_190926_b() && player.func_184592_cb().func_77973_b() == IPContent.debugItem) {
                        matrix.func_227860_a_();
                        matrix.func_227861_a_((double)min.func_177958_n(), (double)min.func_177956_o(), (double)min.func_177952_p());
                        ClientRenderHandler.renderCenteredOutlineBox(matrix, 0xFF0000, flicker);
                        matrix.func_227865_b_();
                        matrix.func_227860_a_();
                        matrix.func_227861_a_((double)max.func_177958_n(), (double)max.func_177956_o(), (double)max.func_177952_p());
                        ClientRenderHandler.renderCenteredOutlineBox(matrix, 65280, flicker);
                        matrix.func_227865_b_();
                        matrix.func_227860_a_();
                        BlockPos center = min.func_185334_h().func_177971_a((Vector3i)max);
                        matrix.func_227861_a_((double)(center.func_177958_n() / 2), (double)(center.func_177956_o() / 2), (double)(center.func_177952_p() / 2));
                        ClientRenderHandler.renderCenteredOutlineBox(matrix, 255, flicker);
                        matrix.func_227865_b_();
                    }
                }
            }
        }

        private static void renderPhantom(MatrixStack matrix, MultiblockProjection.IMultiblockBlockReader blockAccess, World world, BlockPos templatePos, BlockPos worldPos, Rotation rotation, boolean mirror, float flicker, float alpha, float partialTicks) {
            BlockRendererDispatcher dispatcher = ClientUtils.mc().func_175602_ab();
            BlockModelRenderer blockRenderer = dispatcher.func_175019_b();
            BlockColors blockColors = ClientUtils.mc().func_184125_al();
            matrix.func_227861_a_((double)worldPos.func_177958_n(), (double)worldPos.func_177956_o(), (double)worldPos.func_177952_p());
            IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            BlockState state = blockAccess.func_180495_p(templatePos);
            state = state.rotate((IWorld)world, worldPos, rotation);
            ProjectorEvent.RenderBlock renderEvent = new ProjectorEvent.RenderBlock(blockAccess, templatePos, world, worldPos, state, rotation);
            if (!MinecraftForge.EVENT_BUS.post((Event)renderEvent)) {
                BlockRenderType blockrendertype;
                state = renderEvent.getState();
                EmptyModelData modelData = EmptyModelData.INSTANCE;
                TileEntity te = blockAccess.func_175625_s(templatePos);
                if (te != null) {
                    te.field_195045_e = state;
                    modelData = te.getModelData();
                }
                if ((blockrendertype = state.func_185901_i()) != BlockRenderType.INVISIBLE) {
                    if (blockrendertype == BlockRenderType.MODEL) {
                        IBakedModel ibakedmodel = dispatcher.func_184389_a(state);
                        int i = blockColors.func_228054_a_(state, null, null, 0);
                        float red = (float)(i >> 16 & 0xFF) / 255.0f;
                        float green = (float)(i >> 8 & 0xFF) / 255.0f;
                        float blue = (float)(i & 0xFF) / 255.0f;
                        blockRenderer.renderModel(matrix.func_227866_c_(), buffer.getBuffer(RenderType.func_228645_f_()), state, ibakedmodel, red, green, blue, 0xF000F0, OverlayTexture.field_229196_a_, (IModelData)modelData);
                    } else if (blockrendertype == BlockRenderType.ENTITYBLOCK_ANIMATED) {
                        ItemStack stack = new ItemStack((IItemProvider)state.func_177230_c());
                        stack.func_77973_b().getItemStackTileEntityRenderer().func_239207_a_(stack, ItemCameraTransforms.TransformType.NONE, matrix, (IRenderTypeBuffer)buffer, 0xF000F0, OverlayTexture.field_229196_a_);
                    }
                }
            }
            ShaderUtil.alpha_static(flicker * alpha, (float)ClientUtils.mc().field_71439_g.field_70173_aa + partialTicks);
            buffer.func_228461_a_();
            ShaderUtil.releaseShader();
        }

        private static void renderOutlineBox(MatrixStack matrix, Vector3i min, Vector3i max, int rgb, float flicker) {
            IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            IVertexBuilder builder = buffer.getBuffer(IPRenderTypes.TRANSLUCENT_LINES);
            float alpha = 0.25f + 0.5f * flicker;
            float xMin = min.func_177958_n();
            float yMin = min.func_177956_o();
            float zMin = min.func_177952_p();
            float xMax = (float)max.func_177958_n() + 1.0f;
            float yMax = (float)max.func_177956_o() + 1.0f;
            float zMax = (float)max.func_177952_p() + 1.0f;
            float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
            float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
            float b = (float)(rgb >> 0 & 0xFF) / 255.0f;
            Matrix4f mat = matrix.func_227866_c_().func_227870_a_();
            builder.func_227888_a_(mat, xMin, yMax, zMin).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, xMax, yMax, zMin).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, xMax, yMax, zMin).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, xMax, yMax, zMax).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, xMax, yMax, zMax).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, xMin, yMax, zMax).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, xMin, yMax, zMax).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, xMin, yMax, zMin).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, xMin, yMax, zMin).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, xMin, yMin, zMin).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, xMax, yMax, zMin).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, xMax, yMin, zMin).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, xMin, yMax, zMax).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, xMin, yMin, zMax).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, xMax, yMax, zMax).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, xMax, yMin, zMax).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, xMin, yMin, zMin).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, xMax, yMin, zMin).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, xMax, yMin, zMin).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, xMax, yMin, zMax).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, xMax, yMin, zMax).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, xMin, yMin, zMax).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, xMin, yMin, zMax).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, xMin, yMin, zMin).func_227885_a_(r, g, b, alpha).func_181675_d();
            buffer.func_228461_a_();
        }

        private static void renderCenteredOutlineBox(MatrixStack matrix, int rgb, float flicker) {
            IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            IVertexBuilder builder = buffer.getBuffer(IPRenderTypes.TRANSLUCENT_LINES);
            matrix.func_227861_a_(0.5, 0.5, 0.5);
            matrix.func_227862_a_(1.01f, 1.01f, 1.01f);
            Matrix4f mat = matrix.func_227866_c_().func_227870_a_();
            float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
            float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
            float b = (float)(rgb >> 0 & 0xFF) / 255.0f;
            float alpha = 0.375f * flicker;
            float s = 0.5f;
            builder.func_227888_a_(mat, -s, s, -s).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, s, s, -s).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, s, s, -s).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, s, s, s).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, s, s, s).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, -s, s, s).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, -s, s, s).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, -s, s, -s).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, -s, s, -s).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, -s, -s, -s).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, s, s, -s).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, s, -s, -s).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, -s, s, s).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, -s, -s, s).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, s, s, s).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, s, -s, s).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, -s, -s, -s).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, s, -s, -s).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, s, -s, -s).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, s, -s, s).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, s, -s, s).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, -s, -s, s).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, -s, -s, s).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, -s, -s, -s).func_227885_a_(r, g, b, alpha).func_181675_d();
            buffer.func_228461_a_();
        }
    }
}

