/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.tileentities;

import flaxbeard.immersivepetroleum.api.crafting.FlarestackHandler;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FlarestackTileEntity
extends TileEntity
implements ITickableTileEntity {
    public static TileEntityType<FlarestackTileEntity> TYPE;
    protected boolean isActive;
    protected FluidTank tank = new FluidTank(1000, fstack -> fstack != null && FlarestackHandler.isBurnable(fstack));
    private LazyOptional<IFluidHandler> inputHandler;

    public FlarestackTileEntity() {
        this(TYPE);
    }

    public FlarestackTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.isActive = nbt.func_74767_n("active");
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("active", this.isActive);
        CompoundNBT tank = this.tank.writeToNBT(new CompoundNBT());
        compound.func_218657_a("tank", (INBT)tank);
        return compound;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public void readTank(CompoundNBT nbt) {
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
    }

    public void writeTank(CompoundNBT nbt, boolean toItem) {
        boolean write = this.tank.getFluidAmount() > 0;
        CompoundNBT tankTag = this.tank.writeToNBT(new CompoundNBT());
        if (!toItem || write) {
            nbt.func_218657_a("tank", (INBT)tankTag);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (side == null || side == Direction.DOWN)) {
            if (this.inputHandler == null) {
                this.inputHandler = LazyOptional.of(() -> {
                    TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v());
                    if (te != null && te instanceof FlarestackTileEntity) {
                        return ((FlarestackTileEntity)te).tank;
                    }
                    return null;
                });
            }
            return this.inputHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.inputHandler != null) {
            this.inputHandler.invalidate();
        }
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        if (this.inputHandler != null) {
            this.inputHandler.invalidate();
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        this.field_145850_b.func_195593_d(this.field_174879_c, state.func_177230_c());
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 4L == 0L) {
                if (this.isActive) {
                    Random lastRand = new Random((int)Math.floor((float)this.field_145850_b.func_82737_E() / 20.0f));
                    Random thisRand = new Random((int)Math.ceil((float)this.field_145850_b.func_82737_E() / 20.0f));
                    float lastDirection = lastRand.nextFloat() * 360.0f;
                    float thisDirection = thisRand.nextFloat() * 360.0f;
                    float interpDirection = (thisDirection - lastDirection) * ((float)(this.field_145850_b.func_82737_E() % 20L) / 20.0f) + lastDirection;
                    float xSpeed = (float)Math.sin(interpDirection) * 0.1f;
                    float zSpeed = (float)Math.cos(interpDirection) * 0.1f;
                    for (int i = 0; i < 10; ++i) {
                        float xPos = (float)this.field_174879_c.func_177958_n() + 0.5f + (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.4375f;
                        float zPos = (float)this.field_174879_c.func_177952_p() + 0.5f + (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.4375f;
                        float yPos = (float)this.field_174879_c.func_177956_o() + 1.875f + (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 1.0f;
                        this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)xPos, (double)yPos, (double)zPos, (double)xSpeed, (double)0.2f, (double)zSpeed);
                        if (!(Math.random() <= 0.1)) continue;
                        this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197594_E, (double)xPos, (double)yPos, (double)zPos, (double)xSpeed, (double)0.15f, (double)zSpeed);
                    }
                } else {
                    float xPos = (float)this.field_174879_c.func_177958_n() + 0.5f + (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.4375f;
                    float zPos = (float)this.field_174879_c.func_177952_p() + 0.5f + (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.4375f;
                    float yPos = (float)this.field_174879_c.func_177956_o() + 1.6f;
                    float xa = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.00625f;
                    float ya = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.00625f;
                    this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)xPos, (double)yPos, (double)zPos, (double)xa, (double)0.025f, (double)ya);
                }
            }
        } else {
            boolean lastActive = this.isActive;
            if (this.tank.getFluidAmount() > 0) {
                if (this.tank.drain(100, IFluidHandler.FluidAction.EXECUTE).getAmount() > 0 && !this.isActive) {
                    this.isActive = true;
                }
            } else if (this.isActive) {
                this.isActive = false;
            }
            if (this.isActive && this.field_145850_b.func_82737_E() % 10L == 0L) {
                BlockPos min = this.field_174879_c.func_177982_a(-1, 2, -1);
                BlockPos max = min.func_177982_a(3, 3, 3);
                List list = this.func_145831_w().func_217357_a(Entity.class, new AxisAlignedBB(min, max));
                if (!list.isEmpty()) {
                    list.forEach(e -> {
                        if (!e.func_230279_az_()) {
                            e.func_70015_d(8);
                        }
                    });
                }
            }
            if (lastActive != this.isActive) {
                this.func_70296_d();
            }
        }
    }
}

