/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.render;

import blusunrize.immersiveengineering.client.ClientUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import flaxbeard.immersivepetroleum.client.model.ModelSpeedboat;
import flaxbeard.immersivepetroleum.common.entity.SpeedboatEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SpeedboatRenderer
extends EntityRenderer<SpeedboatEntity> {
    private static String texture = "immersivepetroleum:textures/models/boat_motor.png";
    private static String textureArmor = "immersivepetroleum:textures/models/boat_motor_armor.png";
    protected ModelSpeedboat modelBoat = new ModelSpeedboat();

    public SpeedboatRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn);
        this.field_76989_e = 0.5f;
    }

    public void render(SpeedboatEntity entity, float entityYaw, float partialTicks, MatrixStack transform, IRenderTypeBuffer bufferIn, int packedLightIn) {
        transform.func_227860_a_();
        transform.func_227861_a_(entity.func_213303_ch().field_72450_a, entity.func_213303_ch().field_72448_b, entity.func_213303_ch().field_72449_c);
        this.setupRotation(entity, entityYaw, partialTicks, transform);
        ClientUtils.bindTexture((String)(entity.isFireproof ? textureArmor : texture));
        if (entity.func_180799_ab()) {
            transform.func_227861_a_(0.0, (double)-0.24375f, 0.0);
        }
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(this.modelBoat.func_228282_a_(this.getEntityTexture(entity)));
        this.modelBoat.func_225598_a_(transform, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (entity.hasIcebreaker) {
            ClientUtils.bindTexture((String)textureArmor);
        }
        if (entity.hasRudders) {
            ClientUtils.bindTexture((String)textureArmor);
        }
        if (entity.hasTank) {
            ClientUtils.bindTexture((String)textureArmor);
        }
        if (entity.hasPaddles) {
            ClientUtils.bindTexture((String)texture);
        }
        transform.func_227865_b_();
        super.func_225623_a_((Entity)entity, entityYaw, partialTicks, transform, bufferIn, packedLightIn);
    }

    public void renderMultipass(SpeedboatEntity entity, double x, double y, double z, float yaw, float partialTicks, MatrixStack transform) {
        transform.func_227860_a_();
        transform.func_227861_a_(x, y + 0.375, z);
        this.setupRotation(entity, yaw, partialTicks, transform);
        ClientUtils.bindTexture((String)texture);
        transform.func_227865_b_();
    }

    public ResourceLocation getEntityTexture(SpeedboatEntity entity) {
        return new ResourceLocation(texture);
    }

    public void setupRotation(SpeedboatEntity boat, float yaw, float partialTicks, MatrixStack transform) {
        transform.func_227863_a_(new Quaternion(0.0f, 180.0f - yaw, 0.0f, true));
        float f = (float)boat.func_70268_h() - partialTicks;
        float f1 = boat.func_70271_g() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            transform.func_227863_a_(new Quaternion(MathHelper.func_76126_a((float)f) * f * f1 / 10.0f * (float)boat.func_70267_i(), 0.0f, 0.0f, true));
        }
        if (boat.isBoosting) {
            transform.func_227863_a_(new Quaternion(3.0f, 0.0f, 0.0f, true));
        }
        transform.func_227862_a_(-1.0f, -1.0f, 1.0f);
    }

    public void setupTranslation(MatrixStack transform, double x, double y, double z) {
        transform.func_227861_a_(x, y + 0.375, z);
    }
}

