/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.render;

import blusunrize.immersiveengineering.client.ClientUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import flaxbeard.immersivepetroleum.api.crafting.LubricatedHandler;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.AutoLubricatorTileEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

public class AutoLubricatorRenderer
extends TileEntityRenderer<AutoLubricatorTileEntity> {
    public AutoLubricatorRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public boolean isGlobalRenderer(AutoLubricatorTileEntity te) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(AutoLubricatorTileEntity te, float partialTicks, MatrixStack transform, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        TileEntity master;
        if (te == null || te.isSlave) {
            return;
        }
        FluidStack fs = te.tank.getFluid();
        float level = 0.0f;
        if (fs != null && !fs.isEmpty()) {
            level = (float)fs.getAmount() / (float)te.tank.getCapacity();
        }
        if (level > 0.0f) {
            float height = 16.0f;
            transform.func_227860_a_();
            float scale = 0.0625f;
            transform.func_227861_a_(0.25, 0.875, 0.25);
            transform.func_227862_a_(scale, scale, scale);
            IVertexBuilder builder = bufferIn.getBuffer(RenderType.func_228645_f_());
            float h = height * level;
            ClientUtils.drawRepeatedFluidSprite((IVertexBuilder)builder, (MatrixStack)transform, (FluidStack)fs, (float)0.0f, (float)0.0f, (float)8.0f, (float)h);
            transform.func_227863_a_(new Quaternion(0.0f, 90.0f, 0.0f, true));
            transform.func_227861_a_(-7.98, 0.0, 0.0);
            ClientUtils.drawRepeatedFluidSprite((IVertexBuilder)builder, (MatrixStack)transform, (FluidStack)fs, (float)0.0f, (float)0.0f, (float)8.0f, (float)h);
            transform.func_227863_a_(new Quaternion(0.0f, 90.0f, 0.0f, true));
            transform.func_227861_a_(-7.98, 0.0, 0.0);
            ClientUtils.drawRepeatedFluidSprite((IVertexBuilder)builder, (MatrixStack)transform, (FluidStack)fs, (float)0.0f, (float)0.0f, (float)8.0f, (float)h);
            transform.func_227863_a_(new Quaternion(0.0f, 90.0f, 0.0f, true));
            transform.func_227861_a_(-7.98, 0.0, 0.0);
            ClientUtils.drawRepeatedFluidSprite((IVertexBuilder)builder, (MatrixStack)transform, (FluidStack)fs, (float)0.0f, (float)0.0f, (float)8.0f, (float)h);
            if (h < height) {
                transform.func_227863_a_(new Quaternion(90.0f, 0.0f, 0.0f, true));
                transform.func_227861_a_(0.0, 0.0, (double)(-h));
                ClientUtils.drawRepeatedFluidSprite((IVertexBuilder)builder, (MatrixStack)transform, (FluidStack)fs, (float)0.0f, (float)0.0f, (float)8.0f, (float)8.0f);
            }
            transform.func_227865_b_();
        }
        transform.func_227860_a_();
        BlockPos target = te.func_174877_v().func_177972_a(te.getFacing());
        TileEntity test = te.func_145831_w().func_175625_s(target);
        LubricatedHandler.ILubricationHandler<TileEntity> handler = LubricatedHandler.getHandlerForTile(test);
        if (handler != null && (master = handler.isPlacedCorrectly(te.func_145831_w(), te, te.getFacing())) != null) {
            handler.renderPipes(te, master, transform, bufferIn, combinedLightIn, combinedOverlayIn);
        }
        transform.func_227865_b_();
    }
}

