/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;

public class ResourceUtils {
    public static InputStream getResourceAsStream(ResourceLocation resource) throws IOException {
        return ResourceUtils.getResource(resource).func_199027_b();
    }

    public static IReloadableResourceManager getResourceManager() {
        return (IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G();
    }

    public static IResource getResource(String location) throws IOException {
        return ResourceUtils.getResource(new ResourceLocation(location));
    }

    public static IResource getResource(ResourceLocation location) throws IOException {
        return ResourceUtils.getResourceManager().func_199002_a(location);
    }

    public static void registerReloadListener(ISelectiveResourceReloadListener reloadListener) {
        ResourceUtils.getResourceManager().func_219534_a((IFutureReloadListener)reloadListener);
    }

    public static File ensureExists(File file) {
        if (!file.exists()) {
            try {
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                file.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException("Error whilst creating file!", e);
            }
        }
        return file;
    }
}

