/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.pipeline.attribute;

import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.util.SneakyUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;

public class AttributeKey<T> {
    private final String name;
    private final IntFunction<T> factory;
    public final int attributeKeyIndex;
    public final int operationIndex;

    public AttributeKey(String name, IntFunction<T> factory) {
        this.name = name;
        this.factory = factory;
        this.attributeKeyIndex = AttributeKeyRegistry.registerAttributeKey(this);
        this.operationIndex = IVertexOperation.registerOperation();
    }

    public T newArray(int length) {
        return this.factory.apply(length);
    }

    public static class AttributeKeyRegistry {
        private static final Map<String, AttributeKey<?>> nameMap = new HashMap();
        private static final List<AttributeKey<?>> attributeKeys = new ArrayList();

        private static int registerAttributeKey(AttributeKey<?> attr) {
            if (nameMap.containsKey(((AttributeKey)attr).name)) {
                throw new IllegalArgumentException("Duplicate registration of attribute with name: " + ((AttributeKey)attr).name);
            }
            nameMap.put(((AttributeKey)attr).name, attr);
            attributeKeys.add(attr);
            return attributeKeys.size() - 1;
        }

        public static <T> AttributeKey<T> getAttributeKey(int index) {
            return (AttributeKey)SneakyUtils.unsafeCast(attributeKeys.get(index));
        }

        public static int numAttributes() {
            return attributeKeys.size();
        }
    }
}

