/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.item;

import java.util.function.Supplier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.LazyValue;
import net.minecraft.util.SoundEvent;

public class SimpleArmorMaterial
implements IArmorMaterial {
    private final int[] durability;
    private final int[] damageReduction;
    private final int enchantability;
    private final SoundEvent soundEvent;
    private final LazyValue<Ingredient> repairMaterial;
    private final String textureName;
    private final float toughness;
    private final float knockbackResistance;

    public SimpleArmorMaterial(int[] durability, int[] damageReduction, int enchantability, SoundEvent soundEvent, Supplier<Ingredient> repairMaterial, String textureName, float toughness, float knockbackResistance) {
        this.durability = durability;
        this.damageReduction = damageReduction;
        this.enchantability = enchantability;
        this.soundEvent = soundEvent;
        this.repairMaterial = new LazyValue(repairMaterial);
        this.textureName = textureName;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int func_200896_a(EquipmentSlotType slot) {
        return this.durability[slot.func_188454_b()];
    }

    public int func_200902_b(EquipmentSlotType slot) {
        return this.damageReduction[slot.func_188454_b()];
    }

    public int func_200900_a() {
        return this.enchantability;
    }

    public SoundEvent func_200899_b() {
        return this.soundEvent;
    }

    public Ingredient func_200898_c() {
        return (Ingredient)this.repairMaterial.func_179281_c();
    }

    public String func_200897_d() {
        return this.textureName;
    }

    public float func_200901_e() {
        return this.toughness;
    }

    public float func_230304_f_() {
        return this.knockbackResistance;
    }

    public static class Builder {
        private final int[] durability = new int[4];
        private final int[] damageReduction = new int[4];
        private int enchantability;
        private SoundEvent soundEvent;
        private Supplier<Ingredient> repairMaterial;
        private String textureName;
        private float toughness;
        private float knockbackResistance;

        private Builder() {
        }

        public Builder durability(EquipmentSlotType slot, int value) {
            this.durability[slot.func_188454_b()] = value;
            return this;
        }

        public Builder durabilityFactor(int factor) {
            for (int i = 0; i < 4; ++i) {
                this.durability[i] = ArmorMaterial.field_77882_bY[i] * factor;
            }
            return this;
        }

        public Builder durability(int[] durability) {
            System.arraycopy(durability, 0, this.durability, 0, 4);
            return this;
        }

        public Builder damageReduction(EquipmentSlotType slot, int value) {
            this.damageReduction[slot.func_188454_b()] = value;
            return this;
        }

        public Builder damageReduction(int[] damageReduction) {
            System.arraycopy(damageReduction, 0, this.damageReduction, 0, 4);
            return this;
        }

        public Builder enchantability(int enchantability) {
            this.enchantability = enchantability;
            return this;
        }

        public Builder soundEvent(SoundEvent soundEvent) {
            this.soundEvent = soundEvent;
            return this;
        }

        public Builder repairMaterial(Supplier<Ingredient> repairMaterial) {
            this.repairMaterial = repairMaterial;
            return this;
        }

        public Builder textureName(String textureName) {
            this.textureName = textureName;
            return this;
        }

        public Builder toughness(float toughness) {
            this.toughness = toughness;
            return this;
        }

        public Builder knockbackResistance(float knockbackResistance) {
            this.knockbackResistance = knockbackResistance;
            return this;
        }

        public SimpleArmorMaterial build() {
            return new SimpleArmorMaterial(this.durability, this.damageReduction, this.enchantability, this.soundEvent, this.repairMaterial, this.textureName, this.toughness, this.knockbackResistance);
        }
    }
}

