/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration;

import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fml.DistExecutor;
import slimeknights.mantle.client.model.fluid.FluidTextureModel;

public class ModelFluidAttributes
extends FluidAttributes {
    public static final IFluidModelProvider MODEL_PROVIDER = (IFluidModelProvider)DistExecutor.unsafeRunForDist(() -> () -> FluidTextureModel.LOADER, () -> () -> IFluidModelProvider.EMPTY);
    private final Fluid fluid;

    public static FluidAttributes.Builder builder() {
        return new Builder(ModelFluidAttributes::new);
    }

    protected ModelFluidAttributes(FluidAttributes.Builder builder, Fluid fluid) {
        super(builder, fluid);
        this.fluid = fluid;
    }

    public ResourceLocation getStillTexture() {
        ResourceLocation texture = MODEL_PROVIDER.getStillTexture(this.fluid);
        if (texture == null) {
            return super.getStillTexture();
        }
        return texture;
    }

    public ResourceLocation getFlowingTexture() {
        ResourceLocation texture = MODEL_PROVIDER.getFlowingTexture(this.fluid);
        if (texture == null) {
            return super.getFlowingTexture();
        }
        return texture;
    }

    @Nullable
    public ResourceLocation getOverlayTexture() {
        return MODEL_PROVIDER.getOverlayTexture(this.fluid);
    }

    public int getColor() {
        return MODEL_PROVIDER.getColor(this.fluid);
    }

    public static interface IFluidModelProvider {
        public static final IFluidModelProvider EMPTY = new IFluidModelProvider(){};

        @Nullable
        default public ResourceLocation getStillTexture(Fluid fluid) {
            return null;
        }

        @Nullable
        default public ResourceLocation getFlowingTexture(Fluid fluid) {
            return null;
        }

        @Nullable
        default public ResourceLocation getOverlayTexture(Fluid fluid) {
            return null;
        }

        default public int getColor(Fluid fluid) {
            return -1;
        }
    }

    public static class Builder
    extends FluidAttributes.Builder {
        private static final ResourceLocation FALLBACK_STILL = new ResourceLocation("block/water_still");
        private static final ResourceLocation FALLBACK_FLOWING = new ResourceLocation("block/water_flow");

        protected Builder(BiFunction<FluidAttributes.Builder, Fluid, FluidAttributes> factory) {
            super(FALLBACK_STILL, FALLBACK_FLOWING, factory);
        }
    }
}

