/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.loot;

import com.google.gson.JsonDeserializer;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ObjectHolder;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.loot.AddEntryLootModifier;
import slimeknights.mantle.loot.ReplaceItemLootModifier;
import slimeknights.mantle.loot.RetexturedLootFunction;
import slimeknights.mantle.loot.condition.BlockTagLootCondition;
import slimeknights.mantle.loot.condition.ContainsItemModifierLootCondition;
import slimeknights.mantle.loot.condition.EmptyModifierLootCondition;
import slimeknights.mantle.loot.condition.ILootModifierCondition;
import slimeknights.mantle.loot.condition.InvertedModifierLootCondition;
import slimeknights.mantle.loot.function.SetFluidLootFunction;
import slimeknights.mantle.registration.RegistrationHelper;
import slimeknights.mantle.registration.adapter.RegistryAdapter;

@ObjectHolder(value="mantle")
public class MantleLoot {
    public static LootConditionType BLOCK_TAG_CONDITION;
    static LootFunctionType RETEXTURED_FUNCTION;
    public static LootFunctionType SET_FLUID_FUNCTION;
    public static final AddEntryLootModifier.Serializer ADD_ENTRY;
    public static final ReplaceItemLootModifier.Serializer REPLACE_ITEM;

    public static void registerGlobalLootModifiers(RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
        RegistryAdapter adapter = new RegistryAdapter(event.getRegistry());
        adapter.register(new AddEntryLootModifier.Serializer(), "add_entry");
        adapter.register(new ReplaceItemLootModifier.Serializer(), "replace_item");
        RETEXTURED_FUNCTION = MantleLoot.registerFunction("fill_retextured_block", (ILootSerializer<? extends ILootFunction>)new RetexturedLootFunction.Serializer());
        SET_FLUID_FUNCTION = MantleLoot.registerFunction("set_fluid", (ILootSerializer<? extends ILootFunction>)SetFluidLootFunction.SERIALIZER);
        BLOCK_TAG_CONDITION = MantleLoot.registerCondition("block_tag", BlockTagLootCondition.SERIALIZER);
        MantleLoot.registerCondition(InvertedModifierLootCondition.ID, (JsonDeserializer<? extends ILootModifierCondition>)((JsonDeserializer)InvertedModifierLootCondition::deserialize));
        MantleLoot.registerCondition(EmptyModifierLootCondition.ID, EmptyModifierLootCondition.INSTANCE);
        MantleLoot.registerCondition(ContainsItemModifierLootCondition.ID, (JsonDeserializer<? extends ILootModifierCondition>)((JsonDeserializer)ContainsItemModifierLootCondition::deserialize));
    }

    private static LootFunctionType registerFunction(String name, ILootSerializer<? extends ILootFunction> serializer) {
        return (LootFunctionType)Registry.func_218322_a((Registry)Registry.field_239694_aZ_, (ResourceLocation)Mantle.getResource(name), (Object)new LootFunctionType(serializer));
    }

    private static LootConditionType registerCondition(String name, ILootSerializer<? extends ILootCondition> serializer) {
        return (LootConditionType)Registry.func_218322_a((Registry)Registry.field_239704_ba_, (ResourceLocation)Mantle.getResource(name), (Object)new LootConditionType(serializer));
    }

    private static void registerCondition(ResourceLocation id, JsonDeserializer<? extends ILootModifierCondition> deserializer) {
        ILootModifierCondition.MODIFIER_CONDITIONS.registerDeserializer(id, deserializer);
    }

    private MantleLoot() {
    }

    static {
        ADD_ENTRY = (AddEntryLootModifier.Serializer)((Object)RegistrationHelper.injected());
        REPLACE_ITEM = (ReplaceItemLootModifier.Serializer)((Object)RegistrationHelper.injected());
    }
}

