/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.loot;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootSerializers;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.LootFunctionManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.loot.MantleLoot;
import slimeknights.mantle.loot.builder.AbstractLootModifierBuilder;
import slimeknights.mantle.loot.condition.EmptyModifierLootCondition;
import slimeknights.mantle.loot.condition.ILootModifierCondition;

public class AddEntryLootModifier
extends LootModifier {
    static final Gson GSON = LootSerializers.func_237387_b_().registerTypeHierarchyAdapter(ILootModifierCondition.class, ILootModifierCondition.MODIFIER_CONDITIONS).create();
    private final ILootModifierCondition[] modifierConditions;
    private final LootEntry entry;
    private final ILootFunction[] functions;
    private final BiFunction<ItemStack, LootContext, ItemStack> combinedFunctions;

    protected AddEntryLootModifier(ILootCondition[] conditionsIn, ILootModifierCondition[] modifierConditions, LootEntry entry, ILootFunction[] functions) {
        super(conditionsIn);
        this.modifierConditions = modifierConditions;
        this.entry = entry;
        this.functions = functions;
        this.combinedFunctions = LootFunctionManager.func_216241_a((BiFunction[])functions);
    }

    @Deprecated
    protected AddEntryLootModifier(ILootCondition[] conditionsIn, LootEntry entry, ILootFunction[] functions, boolean requireEmpty) {
        ILootModifierCondition[] iLootModifierConditionArray;
        if (requireEmpty) {
            ILootModifierCondition[] iLootModifierConditionArray2 = new ILootModifierCondition[1];
            iLootModifierConditionArray = iLootModifierConditionArray2;
            iLootModifierConditionArray2[0] = EmptyModifierLootCondition.INSTANCE;
        } else {
            iLootModifierConditionArray = new ILootModifierCondition[]{};
        }
        this(conditionsIn, iLootModifierConditionArray, entry, functions);
    }

    public static Builder builder(LootEntry entry) {
        return new Builder(entry);
    }

    public static Builder builder(LootEntry.Builder<?> builder) {
        return AddEntryLootModifier.builder(builder.func_216081_b());
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        for (ILootModifierCondition modifierCondition : this.modifierConditions) {
            if (modifierCondition.test(generatedLoot, context)) continue;
            return generatedLoot;
        }
        Consumer consumer = ILootFunction.func_215858_a(this.combinedFunctions, generatedLoot::add, (LootContext)context);
        this.entry.expand(context, generator -> generator.func_216188_a(consumer, context));
        return generatedLoot;
    }

    public static class Builder
    extends AbstractLootModifierBuilder<Builder> {
        private final List<ILootModifierCondition> modifierConditions = new ArrayList<ILootModifierCondition>();
        private final LootEntry entry;
        private final List<ILootFunction> functions = new ArrayList<ILootFunction>();

        public Builder addCondition(ILootModifierCondition condition) {
            this.modifierConditions.add(condition);
            return this;
        }

        public Builder addFunction(ILootFunction function) {
            this.functions.add(function);
            return this;
        }

        @Override
        public void build(String name, GlobalLootModifierProvider provider) {
            provider.add(name, (GlobalLootModifierSerializer)MantleLoot.ADD_ENTRY, (IGlobalLootModifier)new AddEntryLootModifier(this.getConditions(), this.modifierConditions.toArray(new ILootModifierCondition[0]), this.entry, this.functions.toArray(new ILootFunction[0])));
        }

        private Builder(LootEntry entry) {
            this.entry = entry;
        }
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AddEntryLootModifier> {
        public AddEntryLootModifier read(ResourceLocation location, JsonObject object, ILootCondition[] conditions) {
            LootEntry entry = (LootEntry)GSON.fromJson((JsonElement)JSONUtils.func_152754_s((JsonObject)object, (String)"entry"), LootEntry.class);
            ILootModifierCondition[] modifierConditions = object.has("post_conditions") ? (ILootModifierCondition[])GSON.fromJson((JsonElement)JSONUtils.func_151214_t((JsonObject)object, (String)"modifier_conditions"), ILootModifierCondition[].class) : new ILootModifierCondition[]{};
            if (JSONUtils.func_151209_a((JsonObject)object, (String)"require_empty", (boolean)false)) {
                Mantle.logger.warn("Using deprecated Loot Modifier property require_empty, use the mantle:empty post_condition instead");
                modifierConditions = Arrays.copyOf(modifierConditions, modifierConditions.length + 1);
                modifierConditions[modifierConditions.length - 1] = EmptyModifierLootCondition.INSTANCE;
            }
            ILootFunction[] functions = object.has("functions") ? (ILootFunction[])GSON.fromJson((JsonElement)JSONUtils.func_151214_t((JsonObject)object, (String)"functions"), ILootFunction[].class) : new ILootFunction[]{};
            return new AddEntryLootModifier(conditions, modifierConditions, entry, functions);
        }

        public JsonObject write(AddEntryLootModifier instance) {
            JsonObject object = this.makeConditions(instance.conditions);
            if (instance.modifierConditions.length > 0) {
                object.add("modifier_conditions", GSON.toJsonTree((Object)instance.modifierConditions, ILootModifierCondition[].class));
            }
            object.add("entry", GSON.toJsonTree((Object)instance.entry, LootEntry.class));
            if (instance.functions.length > 0) {
                object.add("functions", GSON.toJsonTree((Object)instance.functions, ILootFunction[].class));
            }
            return object;
        }
    }
}

