/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tags.ITag;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.io.IOUtils;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.command.MantleCommand;
import slimeknights.mantle.command.TagCollectionArgument;
import slimeknights.mantle.command.ViewTagCommand;

public class DumpTagCommand {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Dynamic2CommandExceptionType ERROR_READING_TAG = new Dynamic2CommandExceptionType((type, name) -> new TranslationTextComponent("command.mantle.dump_tag.read_error", new Object[]{type, name}));

    public static void register(LiteralArgumentBuilder<CommandSource> subCommand) {
        ((LiteralArgumentBuilder)subCommand.requires(sender -> sender.func_197034_c(1))).then(Commands.func_197056_a((String)"type", (ArgumentType)TagCollectionArgument.collection()).then(Commands.func_197056_a((String)"name", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(MantleCommand.VALID_TAGS).executes(DumpTagCommand::run)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int run(CommandContext<CommandSource> context) throws CommandSyntaxException {
        TagCollectionArgument.Result type = (TagCollectionArgument.Result)context.getArgument("type", TagCollectionArgument.Result.class);
        ResourceLocation name = (ResourceLocation)context.getArgument("name", ResourceLocation.class);
        IResourceManager manager = ((CommandSource)context.getSource()).func_197028_i().getDataPackRegistries().func_240970_h_();
        ResourceLocation path = new ResourceLocation(name.func_110624_b(), "tags/" + type.getTagFolder() + "/" + name.func_110623_a() + ".json");
        try {
            List resources = manager.func_199004_b(path);
            ITag.Builder builder = ITag.Builder.func_200047_a();
            int tagsProcessed = 0;
            for (IResource resource : resources) {
                try {
                    InputStream inputstream = resource.func_199027_b();
                    Throwable throwable = null;
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));
                        Throwable throwable2 = null;
                        try {
                            JsonObject json = (JsonObject)JSONUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
                            if (json == null) {
                                Mantle.logger.error("Couldn't load {} tag list {} from {} in data pack {} as it is empty or null", (Object)type.getName(), (Object)name, (Object)path, (Object)resource.func_199026_d());
                                continue;
                            }
                            builder.func_232956_a_(json, resource.func_199026_d());
                            ++tagsProcessed;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (reader == null) continue;
                            if (throwable2 != null) {
                                try {
                                    ((Reader)reader).close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            ((Reader)reader).close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (inputstream == null) continue;
                        if (throwable != null) {
                            try {
                                inputstream.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        inputstream.close();
                    }
                }
                catch (IOException | RuntimeException ex) {
                    Mantle.logger.error("Couldn't read {} tag list {} from {} in data pack {}", (Object)type.getName(), (Object)name, (Object)path, (Object)resource.func_199026_d(), (Object)ex);
                }
                finally {
                    IOUtils.closeQuietly((Closeable)resource);
                }
            }
            TranslationTextComponent message = new TranslationTextComponent("command.mantle.dump_tag.success", new Object[]{type.getName(), name});
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)message, true);
            Mantle.logger.info("Tag dump of {} tag '{}':\n{}", (Object)type.getName(), (Object)name, (Object)GSON.toJson((JsonElement)builder.func_232965_c_()));
            return tagsProcessed;
        }
        catch (IOException | RuntimeException ex) {
            if (type.getCollection().func_199910_a(name) == null) {
                throw ViewTagCommand.TAG_NOT_FOUND.create((Object)type.getName(), (Object)name);
            }
            Mantle.logger.error("Couldn't read {} tag list {} from {}", (Object)type.getName(), (Object)name, (Object)path, (Object)ex);
            throw ERROR_READING_TAG.create((Object)type.getName(), (Object)name);
        }
    }
}

