/*
 * Decompiled with CFR 0.152.
 */
package com.kotakotik.createautomated.register.config;

import com.kotakotik.createautomated.api.NodeInfo;
import com.kotakotik.createautomated.register.config.ModConfig;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.foundation.block.BlockStressDefaults;
import com.simibubi.create.foundation.block.BlockStressValues;
import com.simibubi.create.foundation.config.ConfigBase;
import com.simibubi.create.foundation.config.ContraptionMovementSetting;
import com.simibubi.create.foundation.config.ui.ConfigAnnotations;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.StringUtils;

public class ModServerConfig
extends ModConfig.Config {
    public Machines machines = (Machines)this.nested(0, Machines::new, new String[0]);

    public static class Machines
    extends ModConfig.Config {
        public Picker picker = (Picker)this.nested(1, Picker::new, new String[0]);
        public Extractor extractor = (Extractor)this.nested(1, Extractor::new, new String[0]);
        public Stress stress = (Stress)this.nested(1, Stress::new, new String[0]);
    }

    public static class Stress
    extends ModConfig.Config
    implements BlockStressValues.IStressValueProvider {
        protected Map<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>> impacts = new HashMap<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>>();

        @Override
        protected void registerAll(ForgeConfigSpec.Builder builder) {
            builder.comment(new String[]{"", " [in Stress Units]", "Configure the individual stress impact of mechanical blocks. Note that this cost is doubled for every speed increase it receives"}).push("impact");
            BlockStressDefaults.DEFAULT_IMPACTS.forEach((r, i) -> {
                if (r.func_110624_b().equals("createautomated")) {
                    this.impacts.put((ResourceLocation)r, (ForgeConfigSpec.ConfigValue<Double>)builder.define(r.func_110623_a(), i));
                }
            });
            builder.pop();
            BlockStressValues.registerProvider((String)"createautomated", (BlockStressValues.IStressValueProvider)this);
            super.registerAll(builder);
        }

        public double getCapacity(Block block) {
            return 0.0;
        }

        public boolean hasImpact(Block block) {
            return this.impacts.containsKey(block.getRegistryName());
        }

        public double getImpact(Block block) {
            ResourceLocation key = block.getRegistryName();
            ForgeConfigSpec.ConfigValue<Double> value = this.impacts.get(key);
            return value != null ? (Double)value.get() : 0.0;
        }

        public boolean hasCapacity(Block block) {
            return false;
        }
    }

    public static class Picker
    extends ModConfig.Config {
        public ConfigBase.ConfigInt useTime = this.i(16, 0, "useTime", new String[]{"[in ticks]", "How long it takes to pick"});
        public ConfigBase.ConfigInt durability = this.i(32, 0, "durability", new String[]{"How many items you can pick before the picker breaks"});
    }

    public static class Extractor
    extends ModConfig.Config {
        public ConfigBase.ConfigEnum<InventoryAbility> extractionAbility = this.e(InventoryAbility.HOPPERS_ONLY, "extractionAbility", new String[]{"How ore pieces can be extracted", "Hoppers and arms allows mechanical arms and any block of the hopper sort (funnel, chute, etc), hoppers only allows only blocks of the hopper sort, none allows none"});
        public ConfigBase.ConfigEnum<InventoryAbility> insertionAbility = this.e(InventoryAbility.HOPPERS_AND_ARMS, "insertionAbility", new String[]{"How drills can be inserted", "Hoppers and arms allows mechanical arms and any block of the hopper sort (funnel, chute, etc), hoppers only allows only blocks of the hopper sort, none allows none", "Deployers will always be able to insert drills no matter what :)"});
        public ConfigBase.ConfigBool allowTogglingWithRedstone = this.b(true, "allowTogglingWithRedstone", new String[]{"Whether or not the extractor can be toggled with redstone"});
        public ConfigBase.ConfigBool unbreakableDrills = this.b(false, "unbreakableDrills", new String[]{"Makes drill heads not loose durability", "(why would you use this??)"});
        public ConfigBase.ConfigInt drillDurability = this.i(300, 0, "drillDurability", new String[]{"The durability of the default drill head"});
        public ConfigBase.ConfigEnum<IRotate.SpeedLevel> requiredSpeed = this.e((Enum)IRotate.SpeedLevel.FAST, "requiredSpeed", new String[]{"The speed requirement for the extractor. The exact number has to be configured in Create's config"});
        public ConfigBase.ConfigEnum<MiningAbility> miningAbility = this.e(MiningAbility.NONE, "miningAbility", new String[]{"What types of blocks the extractor can mine. NONE if you want it to only be able to break blocks, ORES for ores only, and ANY for any block"});
        public ConfigBase.ConfigEnum<ContraptionMovementSetting> nodeMovement = this.e((Enum)ContraptionMovementSetting.UNMOVABLE, "nodeMovement", new String[]{"Configure how node blocks can be moved by contraptions"});
        public ConfigBase.ConfigBool nodesDrop = this.b(false, "nodesDrop", new String[]{"If enabled, nodes drop themselves, otherwise they drop nothing"});
        public Nodes nodes = (Nodes)this.nested(1, Nodes::new, new String[0]);

        public static class Nodes
        extends ModConfig.Config {
            protected static List<Supplier<Node>> toReg = new ArrayList<Supplier<Node>>();
            public static final HashMap<ResourceLocation, Node> all = new HashMap();

            public static void reg(Supplier<Node> constructor) {
                toReg.add(constructor);
            }

            @Override
            protected void registerAll(ForgeConfigSpec.Builder builder) {
                super.registerAll(builder);
                for (Supplier<Node> constructor : toReg) {
                    this.registerNow(constructor, builder);
                }
            }

            public Node registerNow(Supplier<Node> constructor, ForgeConfigSpec.Builder builder) {
                Node node = constructor.get();
                builder.push(node.getName());
                node.registerAll(builder);
                builder.pop();
                all.put(node.id, node);
                NodeInfo.info.put(node.id, node);
                return node;
            }

            public static class Node
            extends ModConfig.Config
            implements NodeInfo.Entry {
                public final ResourceLocation id;
                protected ConfigBase.ConfigBool isInfinite;
                public ConfigBase.ConfigInt count;
                public ConfigBase.ConfigBool randomizeDamage;
                public ForgeConfigSpec.ConfigValue<String> blockReplace;
                public final LazyValue<Boolean> infinite = new LazyValue(() -> (Boolean)this.isInfinite.get());

                public Node(ResourceLocation id, boolean defaultInfinite, int defaultCount, boolean defaultRandomizeDamage) {
                    this.depth = 2;
                    this.id = id;
                    this.isInfinite = this.b(defaultInfinite, "isInfinite", new String[]{"Whether or not this node is infinite", ConfigAnnotations.RequiresRestart.SERVER.asComment()});
                    this.count = this.i(defaultCount, 1, "count", new String[]{"How many ore pieces can be extracted. Ignored if is infinite"});
                    this.randomizeDamage = this.b(defaultRandomizeDamage, "randomizeDamage", new String[]{"Whether or not to randomize the amount of ore to remove each time it is extracted"});
                }

                @Override
                public String getName() {
                    return StringUtils.uncapitalize((String)Arrays.stream(this.id.func_110623_a().split("_")).map(StringUtils::capitalize).collect(Collectors.joining()));
                }

                @Override
                protected void registerAll(ForgeConfigSpec.Builder builder) {
                    builder.comment("Which block a node is replaced by once it is drained, set to `minecraft:air` to remove the block instead");
                    this.blockReplace = builder.define("blockReplace", (Object)Blocks.field_150346_d.getRegistryName().toString());
                    super.registerAll(builder);
                }

                @Override
                public boolean isInfinite() {
                    return (Boolean)this.infinite.func_179281_c();
                }

                @Override
                public int getCount() {
                    return (Integer)this.count.get();
                }

                @Override
                public boolean randomizeDamage() {
                    return (Boolean)this.randomizeDamage.get();
                }
            }
        }

        public static enum InventoryAbility {
            HOPPERS_AND_ARMS,
            HOPPERS_ONLY,
            NONE;


            public boolean canHopperInteract() {
                return this.canArmInteract() || this == HOPPERS_ONLY;
            }

            public boolean canArmInteract() {
                return this == HOPPERS_AND_ARMS;
            }
        }

        public static enum MiningAbility {
            NONE,
            ORES,
            ANY;

        }
    }

    protected static class Comments {
        public static final String inventoryAbility = "Hoppers and arms allows mechanical arms and any block of the hopper sort (funnel, chute, etc), hoppers only allows only blocks of the hopper sort, none allows none";

        protected Comments() {
        }
    }
}

