/*
 * Decompiled with CFR 0.152.
 */
package com.kotakotik.createautomated.content.processing.oreExtractor;

import com.kotakotik.createautomated.api.IDrillHead;
import com.kotakotik.createautomated.api.IExtractable;
import com.kotakotik.createautomated.content.base.IOreExtractorBlock;
import com.kotakotik.createautomated.content.simple.drillHead.DrillHeadItem;
import com.kotakotik.createautomated.register.ModTags;
import com.kotakotik.createautomated.register.RecipeItems;
import com.kotakotik.createautomated.register.config.ModConfig;
import com.kotakotik.createautomated.register.config.ModServerConfig;
import com.simibubi.create.content.contraptions.components.actors.BlockBreakingKineticTileEntity;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmInteractionPoint;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.OreBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.RandomUtils;

public class OreExtractorTile
extends BlockBreakingKineticTileEntity {
    public ResourceLocation drillId;
    public final ItemStackHandler inventory = new Inv();
    public int extractProgress = 0;
    public int durability = 0;
    public float drillPos = 0.0f;
    protected LazyOptional<IItemHandler> invHandler = LazyOptional.of(() -> this.inventory);
    public int maxDurability;
    int timeToParticle = 5;
    int lastRenderDurability = this.durability;

    public OreExtractorTile(TileEntityType<?> typeIn) {
        super(typeIn);
    }

    public BlockPos getBreakingPos() {
        return this.func_174877_v().func_177979_c(2);
    }

    public boolean isBreakableOre(BlockPos pos) {
        ModServerConfig.Extractor.MiningAbility miningAbility = OreExtractorTile.getMiningAbility();
        return miningAbility == ModServerConfig.Extractor.MiningAbility.ORES && this.getBlockToMine() instanceof OreBlock || miningAbility == ModServerConfig.Extractor.MiningAbility.ANY && !this.isExtractable(null) && !this.field_145850_b.func_175623_d(this.getBreakingPos());
    }

    public boolean isExtractable(BlockPos pos) {
        return this.getBlockToMine() instanceof IExtractable || IExtractable.getRecipe(this.field_145850_b, this.getBreakingPos()).isPresent();
    }

    public float calculateStressApplied() {
        return super.calculateStressApplied();
    }

    public boolean isDrillLowEnough() {
        return (double)this.drillPos < 0.05 || (Boolean)ModConfig.SERVER.machines.extractor.allowTogglingWithRedstone.get() == false;
    }

    public boolean shouldRun() {
        return super.shouldRun() && this.isBreakableOre(this.getBreakingPos()) && this.isSpeedRequirementFulfilled() && this.isDrillLowEnough();
    }

    public boolean shouldRunExtracting() {
        return this.isExtractable(this.getBreakingPos()) && this.isSpeedRequirementFulfilled() && this.durability > 0 && this.isDrillLowEnough();
    }

    public Block getBlockToMine() {
        return this.field_145850_b.func_180495_p(this.getBreakingPos()).func_177230_c();
    }

    protected float getBreakSpeed() {
        return super.getBreakSpeed() * 3.0f;
    }

    public void func_73660_a() {
        assert (this.field_145850_b != null);
        if (this.field_145850_b.field_72995_K && (this.shouldRunExtracting() || this.shouldRun())) {
            this.particles();
        }
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.doRedstoneStuff();
        }
        if (this.shouldRunExtracting()) {
            IExtractable.tryExtract(this);
        } else if (this.extractProgress != 0) {
            this.extractProgress = 0;
            this.notifyUpdate();
        }
    }

    public boolean isRedstonePowered() {
        return this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_235903_d_((Property)BlockStateProperties.field_208194_u).orElse(false) != false || (Boolean)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208194_u) != false;
    }

    protected void doRedstoneStuff() {
        if (!((Boolean)ModConfig.SERVER.machines.extractor.allowTogglingWithRedstone.get()).booleanValue()) {
            return;
        }
        float toSet = this.drillPos;
        toSet = this.isRedstonePowered() ? (toSet += 0.03f) : (toSet -= 0.03f);
        toSet = MathHelper.func_76131_a((float)toSet, (float)0.0f, (float)0.4f);
        if (toSet != this.drillPos) {
            this.drillPos = toSet;
            this.sendData();
        }
    }

    public static ModServerConfig.Extractor.MiningAbility getMiningAbility() {
        return (ModServerConfig.Extractor.MiningAbility)((Object)ModConfig.SERVER.machines.extractor.miningAbility.get());
    }

    public void write(CompoundNBT compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.func_218657_a("Inventory", (INBT)this.inventory.serializeNBT());
        compound.func_74768_a("ExtractProgress", this.extractProgress);
        compound.func_74768_a("Durability", this.durability);
        compound.func_74768_a("MaxDurability", this.maxDurability);
        compound.func_74776_a("DrillPos", this.drillPos);
        if (this.drillId != null && this.durability != 0) {
            compound.func_74778_a("DrillId", this.drillId == null ? "createautomated:block/ore_extractor/drill" : this.drillId.toString());
        }
    }

    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        super.fromTag(state, compound, clientPacket);
        this.inventory.deserializeNBT(compound.func_74775_l("Inventory"));
        this.extractProgress = compound.func_74762_e("ExtractProgress");
        this.durability = compound.func_74762_e("Durability");
        this.maxDurability = compound.func_74762_e("MaxDurability");
        this.drillPos = compound.func_74760_g("DrillPos");
        String drillIdTempt = compound.func_74779_i("DrillId");
        if (!drillIdTempt.equals("")) {
            this.drillId = new ResourceLocation(drillIdTempt);
        }
    }

    public void setDrill(int durability, ResourceLocation id) {
        this.maxDurability = durability;
        this.durability = durability;
        this.drillId = id;
    }

    @Nullable
    public IDrillHead getDrillHeadItem() {
        return this.drillId.equals((Object)new ResourceLocation("")) ? (IDrillHead)RecipeItems.DRILL_HEAD.item.get() : IDrillHead.getFromId(this.drillId);
    }

    public void takeDamage(int amount) {
        IDrillHead drill = this.getDrillHeadItem();
        if (drill == null) {
            return;
        }
        drill.takeDamage(this, amount);
    }

    public void setDrill(IDrillHead head, ResourceLocation id) {
        this.setDrill(head.getDurability(), id);
    }

    public void setDrill(DrillHeadItem head) {
        this.setDrill(head, head.getRegistryName());
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.invHandler.invalidate();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.invHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public World getWorld() {
        return this.field_145850_b;
    }

    public void particle(IParticleData data) {
        float angle = this.field_145850_b.field_73012_v.nextFloat() * 360.0f;
        Vector3d offset = new Vector3d(0.0, 0.0, 0.25);
        offset = VecHelper.rotate((Vector3d)offset, (double)angle, (Direction.Axis)Direction.Axis.Y);
        Vector3d target = VecHelper.rotate((Vector3d)offset, (double)(this.getSpeed() > 0.0f ? 25.0 : -25.0), (Direction.Axis)Direction.Axis.Y).func_72441_c(0.0, 0.25, 0.0);
        Vector3d center = offset.func_178787_e(VecHelper.getCenterOf((Vector3i)this.field_174879_c));
        target = VecHelper.offsetRandomly((Vector3d)target.func_178788_d(offset), (Random)this.field_145850_b.field_73012_v, (float)0.0078125f);
        this.field_145850_b.func_195594_a(data, center.field_72450_a, center.field_72448_b - 1.75, center.field_72449_c, target.field_72450_a, target.field_72448_b, target.field_72449_c);
    }

    public void particles(int amount, ItemStack stack) {
        for (int i = 0; i < amount; ++i) {
            this.particle((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack));
        }
    }

    public void particles() {
        if (this.durability > 0) {
            float s = Math.abs(this.getSpeed());
            int t = 0;
            if (s >= 192.0f) {
                t = 9;
            } else if (s >= 128.0f) {
                t = 6;
            } else if (s >= 64.0f) {
                t = 3;
            } else if (s >= 16.0f) {
                t = 2;
            }
            this.timeToParticle -= t;
            if (this.timeToParticle <= 0) {
                this.timeToParticle = RandomUtils.nextInt((int)15, (int)17);
                this.particles(RandomUtils.nextInt((int)3, (int)8), new ItemStack((IItemProvider)this.getBlockToMine()));
            }
        } else if (this.lastRenderDurability != this.durability && this.durability == 0) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187635_cQ, SoundCategory.BLOCKS, 1.0f, 10.0f);
            this.particles(RandomUtils.nextInt((int)30, (int)50), new ItemStack((IItemProvider)Blocks.field_150339_S));
        }
        this.lastRenderDurability = this.durability;
    }

    public static int getDefaultStress() {
        return 64;
    }

    static {
        ArmInteractionPoint.addPoint((ArmInteractionPoint)new OreExtractorInteractionPoint(), OreExtractorInteractionPoint::new);
    }

    public static class OreExtractorInteractionPoint
    extends ArmInteractionPoint {
        protected boolean armCanInsertDrills() {
            if (ModConfig.SERVER.machines.extractor.insertionAbility != null) {
                return ((ModServerConfig.Extractor.InventoryAbility)((Object)ModConfig.SERVER.machines.extractor.insertionAbility.get())).canArmInteract();
            }
            return true;
        }

        protected boolean armCanExtractOrePieces() {
            if (ModConfig.SERVER.machines.extractor.extractionAbility != null) {
                return ((ModServerConfig.Extractor.InventoryAbility)((Object)ModConfig.SERVER.machines.extractor.extractionAbility.get())).canArmInteract();
            }
            return false;
        }

        protected boolean isValid(IBlockReader iBlockReader, BlockPos blockPos, BlockState blockState) {
            return (this.armCanExtractOrePieces() || this.armCanInsertDrills()) && blockState.func_177230_c() instanceof IOreExtractorBlock;
        }

        protected ItemStack insert(World world, ItemStack stack, boolean simulate) {
            if (!this.armCanInsertDrills()) {
                return stack;
            }
            if (!(stack.func_77973_b() instanceof IDrillHead)) {
                return stack;
            }
            TileEntity t = world.func_175625_s(this.pos);
            OreExtractorTile tile = t instanceof OreExtractorTile ? (OreExtractorTile)t : (OreExtractorTile)world.func_175625_s(this.pos.func_177984_a());
            if (tile == null) {
                return stack;
            }
            if (tile.durability == 0) {
                if (!simulate) {
                    tile.setDrill((DrillHeadItem)stack.func_77973_b());
                    tile.sendData();
                }
                ItemStack copy = stack.func_77946_l();
                copy.func_190918_g(1);
                return copy;
            }
            return stack;
        }

        protected ItemStack extract(World world, int slot, int amount, boolean simulate) {
            return this.armCanExtractOrePieces() ? super.extract(world, slot, amount, simulate) : ItemStack.field_190927_a;
        }

        protected void cycleMode() {
            if (this.armCanInsertDrills() && this.armCanExtractOrePieces()) {
                super.cycleMode();
            } else if (this.armCanInsertDrills() && !this.armCanExtractOrePieces()) {
                this.mode = ArmInteractionPoint.Mode.DEPOSIT;
            } else if (this.armCanExtractOrePieces() && !this.armCanInsertDrills()) {
                this.mode = ArmInteractionPoint.Mode.TAKE;
            }
        }
    }

    public class Inv
    extends ItemStackHandler {
        public Inv() {
            super(1);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.func_77973_b().getTags().contains(ModTags.Items.ORE_PIECES.func_230234_a_());
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!((ModServerConfig.Extractor.InventoryAbility)((Object)ModConfig.SERVER.machines.extractor.extractionAbility.get())).canHopperInteract()) {
                return ItemStack.field_190927_a;
            }
            return super.extractItem(slot, amount, simulate);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (((ModServerConfig.Extractor.InventoryAbility)((Object)ModConfig.SERVER.machines.extractor.insertionAbility.get())).canHopperInteract() && stack.func_77973_b() instanceof IDrillHead && OreExtractorTile.this.durability == 0) {
                IDrillHead d = (IDrillHead)stack.func_77973_b();
                OreExtractorTile.this.setDrill((DrillHeadItem)stack.func_77973_b());
                stack.func_190920_e(0);
            }
            return stack;
        }
    }
}

