/*
 * Decompiled with CFR 0.152.
 */
package com.kotakotik.createautomated.content.ponder;

import com.kotakotik.createautomated.content.processing.oreExtractor.OreExtractorTile;
import com.kotakotik.createautomated.content.simple.drillHead.DrillHeadItem;
import com.kotakotik.createautomated.register.RecipeItems;
import com.simibubi.create.content.contraptions.components.deployer.DeployerTileEntity;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.elements.InputWindowElement;
import com.simibubi.create.foundation.utility.Pointing;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;

public class OreExtractorScenes {
    public static void intro(SceneBuilder scene, SceneBuildingUtil util) {
        BlockPos extractorBottom = util.grid.at(1, 1, 1);
        BlockPos extractorTop = extractorBottom.func_177984_a();
        BlockPos funnel = util.grid.at(1, 2, 0);
        scene.title("ore_extractor.intro", "Extracting from nodes using Ore Extractors");
        scene.world.setKineticSpeed(util.select.everywhere(), 32.0f);
        scene.showBasePlate();
        scene.idle(5);
        scene.overlay.showText(80).attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(extractorBottom.func_177977_b())).text("Resource nodes can be found in the world, however cannot be moved");
        scene.idle(80);
        scene.world.showSection(util.select.layersFrom(1), Direction.DOWN);
        scene.overlay.showText(80).attachKeyFrame().placeNearTarget().pointAt(util.vector.centerOf(extractorTop)).text("Ore Extractors can be used to extract from resource nodes");
        scene.idle(85);
        scene.overlay.showText(80).attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(extractorTop.func_177982_a(-1, 0, 0))).text("However they require high speed and stress capacity");
        scene.idle(20);
        scene.world.setKineticSpeed(util.select.everywhere(), 128.0f);
        scene.effects.rotationSpeedIndicator(extractorTop.func_177984_a().func_177974_f());
        scene.effects.indicateSuccess(extractorBottom);
        scene.effects.indicateSuccess(extractorTop);
        scene.idle(60);
        scene.overlay.showControls(new InputWindowElement(util.vector.centerOf(extractorTop), Pointing.DOWN).rightClick().withItem(new ItemStack((IItemProvider)RecipeItems.DRILL_HEAD.item.get())), 60);
        scene.idle(10);
        scene.overlay.showText(160).attachKeyFrame().pointAt(util.vector.centerOf(extractorTop)).placeNearTarget().text("Extractors require drill heads to operate, which can be inserted by players by right clicking");
        scene.world.setKineticSpeed(util.select.everywhere(), 128.0f);
        scene.world.modifyTileEntity(extractorTop, OreExtractorTile.class, entity -> {
            entity.setDrill((DrillHeadItem)RecipeItems.DRILL_HEAD.item.get());
            entity.func_70296_d();
        });
        scene.idle(60);
        scene.world.flapFunnel(funnel, true);
        ElementLink piece = scene.world.createItemEntity(util.vector.centerOf(funnel), Vector3d.field_186680_a, new ItemStack((IItemProvider)RecipeItems.LAPIS_EXTRACTABLE.ORE_PIECE.get()));
        scene.idle(40);
        scene.world.modifyEntity(piece, Entity::func_70106_y);
    }

    public static void automation(SceneBuilder scene, SceneBuildingUtil util) {
        BlockPos extractorBottom = util.grid.at(3, 1, 1);
        BlockPos extractorTop = extractorBottom.func_177984_a();
        BlockPos deployer = util.grid.at(3, 1, 3);
        BlockPos hopper = util.grid.at(3, 2, 2);
        BlockPos funnelIn = util.grid.at(2, 2, 1);
        BlockPos funnelOut = funnelIn.func_177977_b();
        BlockPos chute = extractorTop.func_177984_a();
        ItemStack drill = new ItemStack((IItemProvider)RecipeItems.DRILL_HEAD.item.get());
        scene.title("ore_extractor.automation", "Automating ore extraction");
        scene.world.setKineticSpeed(util.select.everywhere(), 128.0f);
        scene.showBasePlate();
        scene.world.showSection(util.select.fromTo(extractorBottom, extractorTop), Direction.UP);
        scene.idle(5);
        scene.world.showSection(util.select.position(deployer), Direction.UP);
        scene.idle(5);
        scene.overlay.showControls(new InputWindowElement(util.vector.centerOf(deployer), Pointing.DOWN).rightClick().withItem(new ItemStack((IItemProvider)RecipeItems.DRILL_HEAD.item.get())), 60);
        scene.overlay.showText(60).placeNearTarget().pointAt(util.vector.centerOf(deployer)).text("Deployers can insert drill heads into Ore Extractors");
        scene.world.modifyTileNBT(util.select.position(deployer), DeployerTileEntity.class, nbt -> nbt.func_218657_a("HeldItem", (INBT)new ItemStack((IItemProvider)RecipeItems.DRILL_HEAD.item.get()).serializeNBT()));
        scene.idle(61);
        scene.world.moveDeployer(deployer, 0.7f, 25);
        scene.idle(26);
        scene.world.modifyTileEntity(extractorTop, OreExtractorTile.class, tile -> tile.setDrill((DrillHeadItem)drill.func_77973_b()));
        scene.idle(81);
        scene.world.hideSection(util.select.position(deployer), Direction.UP);
        scene.world.modifyTileEntity(extractorTop, OreExtractorTile.class, tile -> {
            tile.durability = 0;
            tile.maxDurability = 0;
        });
        scene.idle(5);
        scene.rotateCameraY(-75.0f);
        scene.world.showSection(util.select.position(funnelIn), Direction.WEST.func_176734_d());
        scene.world.showSection(util.select.position(hopper), Direction.SOUTH.func_176734_d());
        scene.world.showSection(util.select.position(chute), Direction.UP.func_176734_d());
        scene.idle(5);
        scene.overlay.showControls(new InputWindowElement(util.vector.centerOf(funnelIn), Pointing.UP).withItem(drill), 60);
        scene.overlay.showControls(new InputWindowElement(util.vector.centerOf(hopper), Pointing.DOWN).withItem(drill), 60);
        scene.overlay.showControls(new InputWindowElement(util.vector.centerOf(chute), Pointing.DOWN).withItem(drill), 60);
        scene.overlay.showText(60).attachKeyFrame().placeNearTarget().pointAt(util.vector.centerOf(extractorTop)).text("Funnels, hoppers, and chutes can also all be used to input drill heads");
        scene.idle(81);
        scene.world.hideSection(util.select.position(funnelIn), Direction.WEST);
        scene.world.hideSection(util.select.position(hopper), Direction.SOUTH);
        scene.world.hideSection(util.select.position(chute), Direction.UP);
        scene.idle(5);
        scene.world.modifyTileEntity(extractorTop, OreExtractorTile.class, tile -> tile.setDrill((DrillHeadItem)drill.func_77973_b()));
        scene.rotateCameraY(75.0f);
        scene.world.showSection(util.select.position(funnelOut), Direction.WEST);
        scene.idle(5);
        scene.overlay.showText(60).attachKeyFrame().placeNearTarget().pointAt(util.vector.centerOf(funnelOut)).text("Funnels and fan chutes can extract any output items");
        scene.idle(20);
        ElementLink piece = scene.world.createItemEntity(util.vector.topOf(funnelOut.func_177977_b()), Vector3d.field_186680_a, new ItemStack((IItemProvider)RecipeItems.GOLD_EXTRACTABLE.ORE_PIECE.get(), 34));
        scene.world.flapFunnel(funnelOut, false);
        scene.idle(81);
        scene.world.modifyEntity(piece, Entity::func_70106_y);
        scene.world.showSection(util.select.position(funnelIn), Direction.EAST);
        scene.world.showSection(util.select.position(chute), Direction.DOWN);
        scene.world.showSection(util.select.position(hopper), Direction.NORTH);
        scene.world.showSection(util.select.position(deployer), Direction.DOWN);
        scene.rotateCameraY(-75.0f);
    }
}

