/*
 * Decompiled with CFR 0.152.
 */
package com.kotakotik.createautomated.compat.jei.categories;

import com.kotakotik.createautomated.CALocalization;
import com.kotakotik.createautomated.CreateAutomated;
import com.kotakotik.createautomated.compat.jei.animations.AnimatedPicker;
import com.kotakotik.createautomated.content.processing.picker.recipe.PickingRecipe;
import com.kotakotik.createautomated.register.ModItems;
import com.kotakotik.createautomated.register.ModRecipeTypes;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.content.contraptions.processing.ProcessingOutput;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.GuiGameElement;
import com.simibubi.create.foundation.utility.Lang;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class PickingCategory
implements IRecipeCategory<PickingRecipe> {
    protected final IDrawable background;
    protected final IDrawable icon;
    public static final ResourceLocation id = CreateAutomated.asResource("picking");
    public static PickingCategory INSTANCE;
    private IGuiHelper guiHelper;
    protected AnimatedPicker picker = new AnimatedPicker();

    public PickingCategory(IGuiHelper guiHelper) {
        INSTANCE = this;
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModItems.PICKER.get()));
        this.background = new EmptyBackground(177, 55);
        this.guiHelper = guiHelper;
    }

    public static List<IRecipe<?>> getRecipes() {
        return Minecraft.func_71410_x().field_71441_e.func_199532_z().func_199510_b().stream().filter(r -> r.func_222127_g() == ModRecipeTypes.PICKING).collect(Collectors.toList());
    }

    public static List<ItemStack> getCatalysts() {
        return Arrays.asList(new ItemStack((IItemProvider)ModItems.PICKER.get()));
    }

    public ResourceLocation getUid() {
        return id;
    }

    public Class<? extends PickingRecipe> getRecipeClass() {
        return PickingRecipe.class;
    }

    public String getTitle() {
        return CALocalization.JEI_PICKER_TITLE.translate(new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(PickingRecipe pickingRecipe, IIngredients iIngredients) {
        iIngredients.setInputIngredients((List)pickingRecipe.func_192400_c());
        iIngredients.setOutputs(VanillaTypes.ITEM, pickingRecipe.output.stream().map(o -> o.getStack().func_77946_l()).collect(Collectors.toList()));
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, PickingRecipe pickingRecipe, IIngredients iIngredients) {
        IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
        List<ProcessingOutput> results = pickingRecipe.output;
        itemStacks.init(0, true, 26, 28);
        itemStacks.set(0, Arrays.asList(pickingRecipe.input.func_193365_a()));
        itemStacks.init(1, false, 131, 28);
        itemStacks.set(1, results.get(0).getStack());
        itemStacks.addTooltipCallback((i, input, stack, tooltip) -> {
            ProcessingOutput output;
            float chance;
            if (!input && (chance = (output = (ProcessingOutput)results.get(i - 1)).getChance()) != 1.0f) {
                tooltip.add(1, Lang.translate((String)"recipe.processing.chance", (Object[])new Object[]{(double)chance < (double)0.01f ? "<1" : Integer.valueOf((int)(chance * 100.0f))}).func_240699_a_(TextFormatting.GOLD));
            }
        });
    }

    public void draw(PickingRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        AllGuiTextures.JEI_SLOT.draw(matrixStack, 26, 28);
        (recipe.output.stream().noneMatch(o -> o.getChance() != 1.0f) ? AllGuiTextures.JEI_SLOT : AllGuiTextures.JEI_CHANCE_SLOT).draw(matrixStack, 131, 28);
        AllGuiTextures.JEI_SHADOW.draw(matrixStack, 61, 21);
        AllGuiTextures.JEI_LONG_ARROW.draw(matrixStack, 52, 32);
        ItemStack[] matchingStacks = recipe.input.func_193365_a();
        if (matchingStacks.length == 0) {
            return;
        }
        ItemStack s = matchingStacks[0];
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(1.4f, 1.4f, 1.4f);
        GuiGameElement.of((ItemStack)s).draw(matrixStack, 55, 3);
        matrixStack.func_227865_b_();
        this.picker.draw(matrixStack, 80, -10);
    }
}

