/*
 * Decompiled with CFR 0.152.
 */
package com.kotakotik.createautomated.compat.jei.categories;

import com.google.common.collect.Lists;
import com.kotakotik.createautomated.CALocalization;
import com.kotakotik.createautomated.CreateAutomated;
import com.kotakotik.createautomated.compat.jei.animations.AnimatedOreExtractor;
import com.kotakotik.createautomated.content.processing.oreExtractor.recipe.ExtractingRecipe;
import com.kotakotik.createautomated.register.ModBlocks;
import com.kotakotik.createautomated.register.ModRecipeTypes;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class OreExtractionCategory
implements IRecipeCategory<ExtractingRecipe> {
    protected final IDrawable background;
    protected final IDrawable icon;
    private final IGuiHelper helper;
    public static final ResourceLocation id = CreateAutomated.asResource("extraction");
    public static OreExtractionCategory INSTANCE;
    protected AnimatedOreExtractor oreExtractor = new AnimatedOreExtractor();

    public OreExtractionCategory(IGuiHelper helper) {
        INSTANCE = this;
        this.icon = helper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.ORE_EXTRACTOR_TOP.get()));
        this.background = new EmptyBackground(177, 100);
        this.helper = helper;
    }

    public ResourceLocation getUid() {
        return id;
    }

    public Class<? extends ExtractingRecipe> getRecipeClass() {
        return ExtractingRecipe.class;
    }

    public String getTitle() {
        return CALocalization.JEI_ORE_EXTRACTOR_TITLE.translate(new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(ExtractingRecipe recipe, IIngredients iIngredients) {
        iIngredients.setInput(VanillaTypes.ITEM, (Object)new ItemStack((IItemProvider)recipe.node.func_193365_a()[0].func_77973_b()));
        iIngredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getCraftingResult1Size());
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, ExtractingRecipe recipe, IIngredients iIngredients) {
        IGuiItemStackGroup guiItemStacks = iRecipeLayout.getItemStacks();
        guiItemStacks.init(1, false, 85, 45);
        guiItemStacks.set(1, (List)iIngredients.getOutputs(VanillaTypes.ITEM).get(0));
        guiItemStacks.addTooltipCallback((i, input, stack, tooltip) -> {
            if (!input) {
                if (recipe.minOre != recipe.maxOre) {
                    tooltip.add(CALocalization.JEI_ORE_EXTRACTOR_BETWEEN.getComponent(recipe.minOre, recipe.maxOre).func_240699_a_(TextFormatting.GOLD));
                } else {
                    stack.func_190920_e(recipe.minOre);
                }
            }
        });
    }

    public List<ITextComponent> getTooltipStrings(ExtractingRecipe recipe, double mouseX, double mouseY) {
        ItemStack node = recipe.node.func_193365_a()[0];
        if (mouseX > 30.0 && mouseX < 60.0 && mouseY > 56.0 && mouseX < 86.0) {
            return Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent(node.func_77973_b().func_77658_a()), CALocalization.JEI_ORE_EXTRACTOR_DRILL_DAMAGE.getComponent(recipe.drillDamage).func_240699_a_(TextFormatting.GOLD), CALocalization.JEI_ORE_EXTRACTOR_TIME.getComponent(Float.valueOf((float)recipe.requiredProgress / 128.0f / 20.0f)).func_240699_a_(TextFormatting.GOLD)});
        }
        return super.getTooltipStrings((Object)recipe, mouseX, mouseY);
    }

    public void draw(ExtractingRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        this.oreExtractor.drawWithBlock(matrixStack, 30, 30, ((BlockItem)recipe.node.func_193365_a()[0].func_77973_b()).func_179223_d().func_176223_P());
        AllGuiTextures.JEI_DOWN_ARROW.draw(matrixStack, 80, 30);
        (recipe.minOre > 0 ? AllGuiTextures.JEI_SLOT : AllGuiTextures.JEI_CHANCE_SLOT).draw(matrixStack, 85, 45);
    }

    public static List<IRecipe<?>> getRecipes() {
        return Minecraft.func_71410_x().field_71441_e.func_199532_z().func_199510_b().stream().filter(r -> r.func_222127_g() == ModRecipeTypes.EXTRACTING).collect(Collectors.toList());
    }

    public static List<ItemStack> getCatalysts() {
        return Arrays.asList(new ItemStack((IItemProvider)ModBlocks.ORE_EXTRACTOR_TOP.get()));
    }
}

