/*
 * Decompiled with CFR 0.152.
 */
package mod.grimmauld.windowlogging;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mod.grimmauld.windowlogging.RegistryEntries;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.fml.DistExecutor;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class WindowInABlockTileEntity
extends TileEntity {
    public static final ModelProperty<BlockState> PARTIAL_BLOCK = new ModelProperty();
    public static final ModelProperty<BlockState> WINDOW_BLOCK = new ModelProperty();
    public static final ModelProperty<BlockPos> POSITION = new ModelProperty();
    public static final ModelProperty<TileEntity> PARTIAL_TE = new ModelProperty();
    private BlockState partialBlock = Blocks.field_150350_a.func_176223_P();
    private BlockState windowBlock = Blocks.field_150350_a.func_176223_P();
    private CompoundNBT partialBlockTileData;
    private TileEntity partialBlockTileEntity = null;
    @OnlyIn(value=Dist.CLIENT)
    private IModelData modelData;

    public WindowInABlockTileEntity() {
        super(RegistryEntries.WINDOW_IN_A_BLOCK_TILE_ENTITY);
        this.setPartialBlockTileData(new CompoundNBT());
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::initDataMap);
    }

    public CompoundNBT getPartialBlockTileData() {
        return this.partialBlockTileData;
    }

    public void setPartialBlockTileData(CompoundNBT partialBlockTileData) {
        this.partialBlockTileData = partialBlockTileData;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void initDataMap() {
        this.modelData = new ModelDataMap.Builder().withInitial(WINDOW_BLOCK, (Object)Blocks.field_150350_a.func_176223_P()).withInitial(PARTIAL_BLOCK, (Object)Blocks.field_150350_a.func_176223_P()).withInitial(POSITION, (Object)BlockPos.field_177992_a).withInitial(PARTIAL_TE, null).build();
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.partialBlock = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("PartialBlock"));
        this.windowBlock = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("WindowBlock"));
        this.setPartialBlockTileData(compound.func_74775_l("PartialData"));
        super.func_230337_a_(state, compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("PartialBlock", (INBT)NBTUtil.func_190009_a((BlockState)this.getPartialBlock()));
        compound.func_218657_a("WindowBlock", (INBT)NBTUtil.func_190009_a((BlockState)this.getWindowBlock()));
        compound.func_218657_a("PartialData", (INBT)this.partialBlockTileData);
        return super.func_189515_b(compound);
    }

    public void updateWindowConnections() {
        if (this.field_145850_b == null) {
            return;
        }
        for (Direction side : Direction.values()) {
            BlockPos offsetPos = this.field_174879_c.func_177972_a(side);
            this.windowBlock = this.getWindowBlock().func_196956_a(side, this.field_145850_b.func_180495_p(offsetPos), (IWorld)this.field_145850_b, this.field_174879_c, offsetPos);
        }
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 18);
        this.func_70296_d();
    }

    @OnlyIn(value=Dist.CLIENT)
    public IModelData getModelData() {
        this.modelData.setData(PARTIAL_BLOCK, (Object)this.partialBlock);
        this.modelData.setData(WINDOW_BLOCK, (Object)this.windowBlock);
        this.modelData.setData(POSITION, (Object)this.field_174879_c);
        this.modelData.setData(PARTIAL_TE, (Object)this.getPartialBlockTileEntityIfPresent());
        return this.modelData;
    }

    public BlockState getPartialBlock() {
        return this.partialBlock;
    }

    public void setPartialBlock(BlockState partialBlock) {
        this.partialBlock = partialBlock;
    }

    public BlockState getWindowBlock() {
        return this.windowBlock;
    }

    public void setWindowBlock(BlockState windowBlock) {
        this.windowBlock = windowBlock;
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, this.func_189515_b(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    @Nullable
    public TileEntity getPartialBlockTileEntityIfPresent() {
        if (!this.getPartialBlock().hasTileEntity() || this.field_145850_b == null) {
            return null;
        }
        if (this.partialBlockTileEntity == null) {
            try {
                this.partialBlockTileEntity = this.getPartialBlock().createTileEntity((IBlockReader)this.field_145850_b);
                if (this.partialBlockTileEntity != null) {
                    this.partialBlockTileEntity.field_195045_e = this.getPartialBlock();
                    this.partialBlockTileEntity.deserializeNBT(this.partialBlockTileData);
                    this.partialBlockTileEntity.func_226984_a_(this.field_145850_b, this.field_174879_c);
                }
            }
            catch (Exception e) {
                this.partialBlockTileEntity = null;
            }
        }
        return this.partialBlockTileEntity;
    }

    public void requestModelDataUpdate() {
        try {
            super.requestModelDataUpdate();
        }
        catch (IllegalArgumentException e) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::requestModelUpdateOnClient);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void requestModelUpdateOnClient() {
        World world = this.field_145850_b;
        try {
            this.field_145850_b = Minecraft.func_71410_x().field_71441_e;
            super.requestModelDataUpdate();
        }
        finally {
            this.field_145850_b = world;
        }
    }
}

