/*
 * Decompiled with CFR 0.152.
 */
package com.haoict.tiab.common.items;

import com.haoict.tiab.common.items.AbstractItemTiab;
import com.haoict.tiab.config.TiabConfig;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemTimeInABottle
extends AbstractItemTiab {
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flagIn) {
        CompoundNBT nbtTagCompound = stack.func_190925_c("timeData");
        int storedTime = nbtTagCompound.func_74762_e("storedTime");
        int storedSeconds = storedTime / 20;
        int hours = storedSeconds / 3600;
        int minutes = storedSeconds % 3600 / 60;
        int seconds = storedSeconds % 60;
        tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"item.tiab.timeinabottle.tooltip", (Object[])new Object[]{hours, String.format("%02d", minutes), String.format("%02d", seconds)})).func_240699_a_(TextFormatting.GREEN));
    }

    public void func_77663_a(@Nonnull ItemStack stack, @Nonnull World worldIn, @Nonnull Entity entityIn, int itemSlot, boolean isSelected) {
        CompoundNBT nbtTagCompound;
        int storedTime;
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (worldIn.field_72995_K) {
            return;
        }
        if (worldIn.func_72912_H().func_82573_f() % 20L == 0L && (storedTime = (nbtTagCompound = stack.func_190925_c("timeData")).func_74762_e("storedTime")) < (Integer)TiabConfig.COMMON.maxStoredTime.get()) {
            nbtTagCompound.func_74768_a("storedTime", storedTime + 20);
        }
        if (worldIn.func_72912_H().func_82573_f() % 200L == 0L) {
            if (!(entityIn instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)entityIn;
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack invStack = player.field_71071_by.func_70301_a(i);
                if (invStack.func_77973_b() != this || invStack == stack) continue;
                int otherTimeData = invStack.func_190925_c("timeData").func_74762_e("storedTime");
                int myTimeData = stack.func_190925_c("timeData").func_74762_e("storedTime");
                if (myTimeData >= otherTimeData) continue;
                this.setStoredEnergy(stack, 0);
            }
        }
    }

    @Override
    public int getStoredEnergy(ItemStack stack) {
        CompoundNBT timeData = stack.func_179543_a("timeData");
        return timeData == null ? 0 : timeData.func_74762_e("storedTime");
    }

    @Override
    public void setStoredEnergy(ItemStack stack, int energy) {
        CompoundNBT timeData = stack.func_179543_a("timeData");
        if (timeData == null) {
            return;
        }
        int newStoredTime = Math.min(energy, (Integer)TiabConfig.COMMON.maxStoredTime.get());
        timeData.func_74768_a("storedTime", newStoredTime);
    }

    @Override
    public void applyDamage(ItemStack stack, int damage) {
        this.setStoredEnergy(stack, this.getStoredEnergy(stack) - damage);
    }
}

