/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.concurrent;

import com.direwolf20.buildinggadgets.common.blocks.EffectBlock;
import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.PlacementChecker;
import com.direwolf20.buildinggadgets.common.tainted.building.PlacementTarget;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.building.view.IBuildView;
import com.direwolf20.buildinggadgets.common.tainted.concurrent.ServerTickingScheduler;
import com.direwolf20.buildinggadgets.common.tainted.concurrent.SteppedScheduler;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.IUniqueObject;
import com.direwolf20.buildinggadgets.common.tainted.save.Undo;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multiset;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.world.IBlockReader;

public final class PlacementScheduler
extends SteppedScheduler {
    private final IBuildView view;
    private final Spliterator<PlacementTarget> spliterator;
    private final PlacementChecker checker;
    private boolean lastWasSuccess;
    private Consumer<PlacementScheduler> finisher;
    private Undo.Builder undoBuilder;

    public static PlacementScheduler schedulePlacement(IBuildView view, PlacementChecker checker, int steps) {
        Preconditions.checkArgument((steps > 0 ? 1 : 0) != 0);
        PlacementScheduler res = new PlacementScheduler(Objects.requireNonNull(view), Objects.requireNonNull(checker), steps);
        ServerTickingScheduler.runTicked(res);
        return res;
    }

    private PlacementScheduler(IBuildView view, PlacementChecker checker, int steps) {
        super(steps);
        this.checker = checker;
        this.view = view;
        this.spliterator = view.spliterator();
        this.undoBuilder = Undo.builder();
        this.finisher = p -> {};
    }

    @Override
    protected void onFinish() {
        this.finisher.accept(this);
    }

    @Override
    protected SteppedScheduler.StepResult advance() {
        if (!this.spliterator.tryAdvance(this::checkTarget)) {
            return SteppedScheduler.StepResult.END;
        }
        return this.lastWasSuccess ? SteppedScheduler.StepResult.SUCCESS : SteppedScheduler.StepResult.FAILURE;
    }

    public Undo.Builder getUndoBuilder() {
        return this.undoBuilder;
    }

    public PlacementScheduler withFinisher(Consumer<PlacementScheduler> runnable) {
        this.finisher = Objects.requireNonNull(runnable);
        return this;
    }

    private void checkTarget(PlacementTarget target) {
        PlacementChecker.CheckResult res = this.checker.checkPositionWithResult(this.view.getContext(), target, false);
        this.lastWasSuccess = res.isSuccess();
        if (this.lastWasSuccess) {
            this.undoBuilder.record((IBlockReader)this.view.getContext().getWorld(), target.getPos(), target.getData(), (Multiset<IUniqueObject<?>>)res.getMatch().getChosenOption(), res.getInsertedItems());
            EffectBlock.spawnEffectBlock(this.view.getContext(), target, EffectBlock.Mode.PLACE, res.isUsingPaste());
            BuildContext context = this.view.getContext();
            BlockData targetBlock = target.getData();
            if (target.getData().getState().func_177230_c() instanceof DoorBlock && targetBlock.getState().func_177229_b((Property)BlockStateProperties.field_208163_P) == DoubleBlockHalf.LOWER && context.getWorld().func_175623_d(target.getPos().func_177984_a())) {
                EffectBlock.spawnEffectBlock(context.getWorld(), target.getPos().func_177984_a(), new BlockData((BlockState)targetBlock.getState().func_206870_a((Property)BlockStateProperties.field_208163_P, (Comparable)DoubleBlockHalf.UPPER), TileSupport.dummyTileEntityData()), EffectBlock.Mode.PLACE, false);
            }
        }
    }
}

