/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.network.split;

import com.direwolf20.buildinggadgets.common.network.split.SplitPacket;
import com.google.common.collect.AbstractIterator;
import io.netty.buffer.Unpooled;
import java.util.Iterator;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;

final class PacketEncoder<MSG> {
    private final BiConsumer<MSG, PacketBuffer> messageEncoder;
    private final int id;
    private short curSession;

    PacketEncoder(BiConsumer<MSG, PacketBuffer> messageEncoder, int id) {
        this.messageEncoder = messageEncoder;
        this.id = id;
        this.curSession = 0;
    }

    Iterable<SplitPacket> encode(final MSG msg) {
        return new Iterable<SplitPacket>(){
            private short curSession;
            {
                this.curSession = PacketEncoder.access$008(PacketEncoder.this);
            }

            @Override
            @Nonnull
            public Iterator<SplitPacket> iterator() {
                return new AbstractIterator<SplitPacket>(){
                    private PacketBuffer messageBuffer = new PacketBuffer(Unpooled.buffer((int)Short.MAX_VALUE, (int)Integer.MAX_VALUE));
                    private int index = 0;
                    {
                        this.messageBuffer.markReaderIndex();
                        this.messageBuffer.markWriterIndex();
                        PacketEncoder.this.messageEncoder.accept(msg, this.messageBuffer);
                        this.messageBuffer.resetReaderIndex();
                    }

                    protected SplitPacket computeNext() {
                        PacketBuffer payload;
                        boolean hasMore;
                        if (this.messageBuffer == null) {
                            return (SplitPacket)this.endOfData();
                        }
                        boolean bl = hasMore = this.messageBuffer.readableBytes() > 30000;
                        if (hasMore) {
                            payload = new PacketBuffer(this.messageBuffer.copy(this.messageBuffer.readerIndex(), 30000));
                            this.messageBuffer.readerIndex(this.messageBuffer.readerIndex() + 30000);
                        } else {
                            payload = new PacketBuffer(this.messageBuffer.copy());
                            this.messageBuffer = null;
                        }
                        return new SplitPacket(PacketEncoder.this.id, this.index++, curSession, hasMore, payload);
                    }
                };
            }
        };
    }

    static /* synthetic */ short access$008(PacketEncoder x0) {
        short s = x0.curSession;
        x0.curSession = (short)(s + 1);
        return s;
    }
}

