/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.network.split;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.network.split.SplitPacket;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.minecraft.network.PacketBuffer;

final class PacketDecoder<MSG> {
    private final Cache<Short, PendingPacket> pendingPackets = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private final Function<PacketBuffer, MSG> decoder;

    PacketDecoder(Function<PacketBuffer, MSG> decoder) {
        this.decoder = decoder;
    }

    Optional<MSG> decode(SplitPacket packet) {
        try {
            return ((PendingPacket)this.pendingPackets.get((Object)packet.getSessionId(), () -> new PendingPacket())).add(packet);
        }
        catch (Exception e) {
            BuildingGadgets.LOG.error("An error occurred whilst assembling packet {} ins session {} with index {} which {}. Discarding.", (Object)packet.getId(), (Object)packet.getSessionId(), (Object)packet.getIndex(), (Object)(packet.hasMore() ? "has follow up packets" : "no follow up packets"), (Object)e);
            this.pendingPackets.invalidate((Object)packet.getSessionId());
            return Optional.empty();
        }
    }

    private final class PendingPacket {
        private final List<SplitPacket> partialPackets = new LinkedList<SplitPacket>();
        private boolean receivedLast;

        private PendingPacket() {
        }

        private Optional<MSG> add(SplitPacket packet) {
            if (!packet.hasMore()) {
                this.receivedLast = true;
            }
            ListIterator<SplitPacket> it = this.partialPackets.listIterator();
            while (it.hasNext() && packet != null) {
                SplitPacket curPacket = it.next();
                if (packet.getIndex() >= curPacket.getIndex()) continue;
                it.set(packet);
                it.add(curPacket);
                packet = null;
            }
            if (packet != null) {
                this.partialPackets.add(packet);
            }
            if (this.receivedLast) {
                return this.checkComplete();
            }
            return Optional.empty();
        }

        private Optional<MSG> checkComplete() {
            int index = 0;
            for (SplitPacket packet : this.partialPackets) {
                if (packet.getIndex() == index++) continue;
                return Optional.empty();
            }
            return this.assemble();
        }

        private Optional<MSG> assemble() {
            PacketBuffer payloadBuffer = new PacketBuffer(Unpooled.buffer((int)Short.MAX_VALUE, (int)Integer.MAX_VALUE));
            for (SplitPacket packet : this.partialPackets) {
                PacketBuffer payload = packet.getPayload();
                payloadBuffer.writeBytes((ByteBuf)payload);
            }
            return Optional.of(PacketDecoder.this.decoder.apply(payloadBuffer));
        }
    }
}

