/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.blocks;

import com.direwolf20.buildinggadgets.common.tileentities.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.tileentities.OurTileEntities;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.DiggingParticle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ConstructionBlock
extends Block {
    public static final Property<Boolean> BRIGHT = BooleanProperty.func_177716_a((String)"bright");
    public static final Property<Boolean> NEIGHBOR_BRIGHTNESS = BooleanProperty.func_177716_a((String)"neighbor_brightness");
    public static final Property<Boolean> AMBIENT_OCCLUSION = BooleanProperty.func_177716_a((String)"ambient_occlusion");

    public ConstructionBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151595_p).func_200948_a(1.5f, 6.0f));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(BRIGHT, (Comparable)Boolean.valueOf(true))).func_206870_a(NEIGHBOR_BRIGHTNESS, (Comparable)Boolean.valueOf(false))).func_206870_a(AMBIENT_OCCLUSION, (Comparable)Boolean.valueOf(false)));
    }

    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof ConstructionBlockTileEntity)) {
            return super.addDestroyEffects(state, world, pos, manager);
        }
        manager.func_180533_a(pos, tileEntity.func_195044_w());
        return true;
    }

    public boolean addHitEffects(BlockState state, World world, RayTraceResult target, ParticleManager manager) {
        if (target.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return super.addHitEffects(state, world, target, manager);
        }
        BlockPos pos = ((BlockRayTraceResult)target).func_216350_a();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof ConstructionBlockTileEntity)) {
            return super.addHitEffects(state, world, target, manager);
        }
        this.addBlockHitEffects(world, pos, tileEntity.func_195044_w(), ((BlockRayTraceResult)target).func_216354_b(), manager);
        return true;
    }

    public void addBlockHitEffects(World world, BlockPos pos, BlockState blockstate, Direction side, ParticleManager manager) {
        if (blockstate.func_185901_i() == BlockRenderType.INVISIBLE) {
            return;
        }
        Random rand = new Random();
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        AxisAlignedBB axisalignedbb = blockstate.func_196954_c((IBlockReader)world, pos).func_197752_a();
        double x = (double)i + rand.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - (double)0.2f) + (double)0.1f + axisalignedbb.field_72340_a;
        double y = (double)j + rand.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - (double)0.2f) + (double)0.1f + axisalignedbb.field_72338_b;
        double z = (double)k + rand.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - (double)0.2f) + (double)0.1f + axisalignedbb.field_72339_c;
        if (side == Direction.DOWN || side == Direction.UP) {
            double d = y = side == Direction.DOWN ? (double)j + axisalignedbb.field_72338_b - (double)0.1f : (double)j + axisalignedbb.field_72337_e + (double)0.1f;
        }
        if (side == Direction.NORTH || side == Direction.SOUTH) {
            double d = z = side == Direction.NORTH ? (double)k + axisalignedbb.field_72339_c - (double)0.1f : (double)k + axisalignedbb.field_72334_f + (double)0.1f;
        }
        if (side == Direction.WEST || side == Direction.EAST) {
            x = side == Direction.WEST ? (double)i + axisalignedbb.field_72340_a - (double)0.1f : (double)i + axisalignedbb.field_72336_d + (double)0.1f;
        }
        manager.func_78873_a(new DiggingParticle((ClientWorld)world, x, y, z, 0.0, 0.0, 0.0, blockstate).func_174846_a(pos).func_70543_e(0.2f).func_70541_f(0.6f));
    }

    public boolean func_208619_r() {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{BRIGHT, NEIGHBOR_BRIGHTNESS, AMBIENT_OCCLUSION});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)OurTileEntities.CONSTRUCTION_BLOCK_TILE_ENTITY.get()).func_200968_a();
    }

    public boolean isMimicNull(BlockState mimicBlock) {
        return mimicBlock == null || mimicBlock == Blocks.field_150350_a.func_176223_P();
    }

    @Nullable
    private BlockState getActualMimicBlock(IBlockReader blockAccess, BlockPos pos) {
        TileEntity te = blockAccess.func_175625_s(pos);
        if (te instanceof ConstructionBlockTileEntity) {
            return ((ConstructionBlockTileEntity)te).getConstructionBlockData().getState();
        }
        return null;
    }

    @Deprecated
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        Boolean bright = (Boolean)state.func_177229_b(BRIGHT);
        if (bright.booleanValue()) {
            return 0;
        }
        return 255;
    }

    public void initColorHandler(BlockColors blockColors) {
        blockColors.func_186722_a((state, world, pos, tintIndex) -> {
            if (world != null) {
                BlockState mimicBlock = this.getActualMimicBlock((IBlockReader)world, pos);
                try {
                    return blockColors.func_228054_a_(mimicBlock, world, pos, tintIndex);
                }
                catch (Exception var8) {
                    return -1;
                }
            }
            return -1;
        }, new Block[]{this});
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext selectionContext) {
        BlockState mimic = this.getActualMimicBlock(worldIn, pos);
        return !this.isMimicNull(mimic) ? mimic.func_196952_d(worldIn, pos) : super.func_220071_b(state, worldIn, pos, selectionContext);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        BlockState mimic = this.getActualMimicBlock((IBlockReader)worldIn, pos);
        if (!this.isMimicNull(mimic)) {
            mimic.func_196950_a(worldIn, pos, entityIn);
        } else {
            super.func_196262_a(state, worldIn, pos, entityIn);
        }
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        BlockState mimic = this.getActualMimicBlock(worldIn, pos);
        return !this.isMimicNull(mimic) ? mimic.func_196957_g(worldIn, pos, type) : super.func_196266_a(state, worldIn, pos, type);
    }

    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        if (state.func_177230_c().equals(adjacentBlockState.func_177230_c())) {
            return false;
        }
        return super.func_200122_a(state, adjacentBlockState, side);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext selectionContext) {
        BlockState mimic = this.getActualMimicBlock(worldIn, pos);
        return !this.isMimicNull(mimic) ? mimic.func_196954_c(worldIn, pos) : super.func_220053_a(state, worldIn, pos, selectionContext);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        BlockState mimic = this.getActualMimicBlock(worldIn, pos);
        if (!mimic.func_200132_m()) {
            return VoxelShapes.func_197880_a();
        }
        return !this.isMimicNull(mimic) ? mimic.func_196951_e(worldIn, pos) : super.func_196247_c(state, worldIn, pos);
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        BlockState mimic = this.getActualMimicBlock(worldIn, pos);
        return !this.isMimicNull(mimic) ? mimic.func_199611_f(worldIn, pos, ISelectionContext.func_216377_a()) : super.func_199600_g(state, worldIn, pos);
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        BlockState mimic = this.getActualMimicBlock(reader, pos);
        return !this.isMimicNull(mimic) ? mimic.func_200131_a(reader, pos) : super.func_200123_i(state, reader, pos);
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        Boolean bright = (Boolean)state.func_177229_b(BRIGHT);
        Boolean neighborBrightness = (Boolean)state.func_177229_b(NEIGHBOR_BRIGHTNESS);
        if (bright.booleanValue() || neighborBrightness.booleanValue()) {
            return 1.0f;
        }
        return 0.2f;
    }
}

