/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.screen;

import com.direwolf20.buildinggadgets.client.screen.ScrollingMaterialList;
import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.capability.CapabilityTemplate;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.template.ITemplateKey;
import com.direwolf20.buildinggadgets.common.tainted.template.ITemplateProvider;
import com.direwolf20.buildinggadgets.common.tainted.template.Template;
import com.direwolf20.buildinggadgets.common.tainted.template.TemplateHeader;
import com.direwolf20.buildinggadgets.common.util.lang.MaterialListTranslation;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class MaterialListGUI
extends Screen
implements ITemplateProvider.IUpdateListener {
    public static final int BUTTON_HEIGHT = 20;
    public static final int BUTTONS_PADDING = 4;
    public static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("buildinggadgets", "textures/gui/material_list.png");
    public static final int BACKGROUND_WIDTH = 256;
    public static final int BACKGROUND_HEIGHT = 200;
    public static final int BORDER_SIZE = 4;
    public static final int WINDOW_WIDTH = 248;
    public static final int WINDOW_HEIGHT = 192;
    private int backgroundX;
    private int backgroundY;
    private ItemStack item;
    private String title;
    private int titleLeft;
    private int titleTop;
    private ScrollingMaterialList scrollingList;
    private Button buttonClose;
    private Button buttonSortingModes;
    private Button buttonCopyList;
    private int hoveringTextX;
    private int hoveringTextY;
    private List<ITextComponent> hoveringText;
    private TemplateHeader header;

    public MaterialListGUI(ItemStack item) {
        super((ITextComponent)MaterialListTranslation.TITLE.componentTranslation(new Object[0]));
        Preconditions.checkArgument((boolean)item.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).isPresent());
        this.item = item;
    }

    public void func_231160_c_() {
        this.backgroundX = MaterialListGUI.getXForAlignedCenter(0, this.field_230708_k_, 256);
        this.backgroundY = MaterialListGUI.getYForAlignedCenter(0, this.field_230709_l_, 200);
        this.header = this.evaluateTemplateHeader();
        this.evaluateTitle();
        this.scrollingList = new ScrollingMaterialList(this);
        this.func_231035_a_((IGuiEventListener)this.scrollingList);
        this.field_230705_e_.add(this.scrollingList);
        int buttonY = this.getWindowBottomY() - 26;
        this.buttonClose = new Button(0, buttonY, 0, 20, (ITextComponent)MaterialListTranslation.BUTTON_CLOSE.componentTranslation(new Object[0]), b -> this.getMinecraft().field_71439_g.func_71053_j());
        this.buttonSortingModes = new Button(0, buttonY, 0, 20, (ITextComponent)this.scrollingList.getSortingMode().getTranslationProvider().componentTranslation(new Object[0]), button -> {
            this.scrollingList.setSortingMode(this.scrollingList.getSortingMode().next());
            this.buttonSortingModes.func_238482_a_((ITextComponent)this.scrollingList.getSortingMode().getTranslationProvider().componentTranslation(new Object[0]));
        });
        this.buttonCopyList = new Button(0, buttonY, 0, 20, (ITextComponent)MaterialListTranslation.BUTTON_COPY.componentTranslation(new Object[0]), button -> {
            this.getMinecraft().field_195559_v.func_197960_a(this.evaluateTemplateHeader().toJson(false, MaterialListGUI.func_231172_r_()));
            if (this.getMinecraft().field_71439_g != null) {
                this.getMinecraft().field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent(MaterialListTranslation.MESSAGE_COPY_SUCCESS.getTranslationKey()), true);
            }
        });
        this.func_230480_a_((Widget)this.buttonSortingModes);
        this.func_230480_a_((Widget)this.buttonCopyList);
        this.func_230480_a_((Widget)this.buttonClose);
        this.field_230705_e_.add(this.scrollingList);
        this.calculateButtonsWidthAndX();
    }

    public TemplateHeader evaluateTemplateHeader() {
        Template template = this.getTemplateCapability();
        BuildContext context = BuildContext.builder().player((PlayerEntity)this.getMinecraft().field_71439_g).stack(this.getTemplateItem()).build((IWorld)this.getMinecraft().field_71441_e);
        return template.getHeaderAndForceMaterials(context);
    }

    public TemplateHeader getHeader() {
        return this.header;
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float particleTicks) {
        this.getMinecraft().func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        GuiUtils.drawTexturedModalRect((int)this.backgroundX, (int)this.backgroundY, (int)0, (int)0, (int)256, (int)200, (float)0.0f);
        this.scrollingList.func_230430_a_(matrices, mouseX, mouseY, particleTicks);
        MaterialListGUI.func_238476_c_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (String)this.title, (int)this.titleLeft, (int)this.titleTop, (int)Color.WHITE.getRGB());
        super.func_230430_a_(matrices, mouseX, mouseY, particleTicks);
        if (this.buttonCopyList.func_231047_b_((double)mouseX, (double)mouseY)) {
            this.func_238654_b_(matrices, Lists.transform((List)ImmutableList.of((Object)MaterialListTranslation.HELP_COPY_LIST.componentTranslation(new Object[0])), ITextComponent::func_241878_f), mouseX, mouseY);
        } else if (this.hoveringText != null) {
            this.func_238654_b_(matrices, Lists.transform(this.hoveringText, ITextComponent::func_241878_f), mouseX, mouseY);
            this.hoveringText = null;
        }
    }

    private void calculateButtonsWidthAndX() {
        int amountButtons = this.field_230710_m_.size();
        int amountMargins = amountButtons - 1;
        int totalMarginWidth = amountMargins * 4;
        int usableWidth = this.getWindowWidth();
        int buttonWidth = (usableWidth - totalMarginWidth) / amountButtons;
        int nextX = this.getWindowLeftX();
        for (Widget widget : this.field_230710_m_) {
            widget.func_230991_b_(buttonWidth);
            widget.field_230690_l_ = nextX;
            nextX += buttonWidth + 4;
        }
    }

    public Template getTemplateCapability() {
        if (this.getMinecraft().field_71441_e == null || this.getMinecraft().field_71439_g == null) {
            return null;
        }
        LazyOptional providerCap = this.getMinecraft().field_71441_e.getCapability(CapabilityTemplate.TEMPLATE_PROVIDER_CAPABILITY);
        if (providerCap.isPresent()) {
            LazyOptional keyCap = this.item.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY);
            ITemplateProvider provider = (ITemplateProvider)providerCap.orElseThrow(RuntimeException::new);
            if (keyCap.isPresent()) {
                provider.registerUpdateListener(this);
                ITemplateKey key = (ITemplateKey)keyCap.orElseThrow(RuntimeException::new);
                return provider.getTemplateForKey(key);
            }
            BuildingGadgets.LOG.warn("Item used for material list does not have an ITemplateKey capability!");
            this.getMinecraft().field_71439_g.func_71053_j();
            return null;
        }
        BuildingGadgets.LOG.warn("Client world used for material list does not have an ITemplateProvider capability!");
        this.getMinecraft().field_71439_g.func_71053_j();
        return null;
    }

    public void setTaskHoveringText(int x, int y, List<ITextComponent> text) {
        this.hoveringTextX = x;
        this.hoveringTextY = y;
        this.hoveringText = text;
    }

    @Override
    public void onTemplateUpdate(ITemplateProvider provider, ITemplateKey key, Template template) {
        this.item.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).ifPresent(itemKey -> {
            UUID itemId;
            UUID keyId = provider.getId(key);
            if (keyId.equals(itemId = provider.getId((ITemplateKey)itemKey))) {
                this.header = this.evaluateTemplateHeader();
                this.evaluateTitle();
                this.scrollingList.reset();
            }
        });
    }

    private void evaluateTitle() {
        String name = this.getHeader().getName();
        String author = this.getHeader().getAuthor();
        this.title = name == null && author == null ? MaterialListTranslation.TITLE_EMPTY.format(new Object[0]) : (name == null ? MaterialListTranslation.TITLE_AUTHOR_ONLY.format(author) : (author == null ? MaterialListTranslation.TITLE_NAME_ONLY.format(name) : MaterialListTranslation.TITLE.format(name, author)));
        int n = this.getWindowTopY() + 16;
        this.field_230712_o_.getClass();
        this.titleTop = MaterialListGUI.getYForAlignedCenter(this.backgroundY, n, 9);
        this.titleLeft = MaterialListGUI.getXForAlignedCenter(this.backgroundX, this.getWindowRightX(), this.field_230712_o_.func_78256_a(this.title));
    }

    public boolean func_231177_au__() {
        return false;
    }

    public int getWindowLeftX() {
        return this.backgroundX + 4;
    }

    public int getWindowRightX() {
        return this.backgroundX + 256 - 4;
    }

    public int getWindowTopY() {
        return this.backgroundY + 4;
    }

    public int getWindowBottomY() {
        return this.backgroundY + 200 - 4;
    }

    public int getWindowWidth() {
        return 248;
    }

    public int getWindowHeight() {
        return 192;
    }

    public ItemStack getTemplateItem() {
        return this.item;
    }

    public static int getXForAlignedRight(int right, int width) {
        return right - width;
    }

    public static int getXForAlignedCenter(int left, int right, int width) {
        return left + (right - left) / 2 - width / 2;
    }

    public static int getYForAlignedCenter(int top, int bottom, int height) {
        return top + (bottom - top) / 2 - height / 2;
    }

    public static void renderTextVerticalCenter(MatrixStack matrices, String text, int leftX, int top, int bottom, int color) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.getClass();
        int y = MaterialListGUI.getYForAlignedCenter(top, bottom, 9);
        RenderSystem.enableTexture();
        fontRenderer.func_238421_b_(matrices, text, (float)leftX, (float)y, color);
    }

    public static void renderTextHorizontalRight(MatrixStack matrices, String text, int right, int y, int color) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int x = MaterialListGUI.getXForAlignedRight(right, fontRenderer.func_78256_a(text));
        RenderSystem.enableTexture();
        fontRenderer.func_238421_b_(matrices, text, (float)x, (float)y, color);
    }

    public static boolean isPointInBox(double x, double y, int bx, int by, int width, int height) {
        return x >= (double)bx && y >= (double)by && x < (double)(bx + width) && y < (double)(by + height);
    }
}

