/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.screen;

import com.direwolf20.buildinggadgets.client.screen.components.GuiIncrementer;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.items.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.packets.PacketCopyCoords;
import com.direwolf20.buildinggadgets.common.tainted.building.Region;
import com.direwolf20.buildinggadgets.common.util.lang.GuiTranslation;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class CopyGUI
extends Screen {
    private GuiIncrementer startX;
    private GuiIncrementer startY;
    private GuiIncrementer startZ;
    private GuiIncrementer endX;
    private GuiIncrementer endY;
    private GuiIncrementer endZ;
    private boolean absoluteCoords;
    private int x;
    private int y;
    private ItemStack copyPasteTool;
    private BlockPos startPos;
    private BlockPos endPos;
    private List<GuiIncrementer> fields;

    public CopyGUI(ItemStack tool) {
        super((ITextComponent)new StringTextComponent(""));
        this.absoluteCoords = (Boolean)Config.GENERAL.absoluteCoordDefault.get() != false && (Boolean)Config.GENERAL.allowAbsoluteCoords.get() != false;
        this.fields = new ArrayList<GuiIncrementer>();
        this.copyPasteTool = tool;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.fields.clear();
        this.x = this.field_230708_k_ / 2;
        this.y = this.field_230709_l_ / 2;
        Region reg = GadgetCopyPaste.getSelectedRegion(this.copyPasteTool).orElse(Region.singleZero());
        this.startPos = reg.getMin();
        this.endPos = reg.getMax();
        int incrementerWidth = 96;
        this.startX = new GuiIncrementer(this.x - incrementerWidth - 35, this.y - 40);
        this.fields.add(this.startX);
        this.startY = new GuiIncrementer(this.x - 32, this.y - 40);
        this.fields.add(this.startY);
        this.startZ = new GuiIncrementer(this.x + 32 + 35, this.y - 40);
        this.fields.add(this.startZ);
        this.endX = new GuiIncrementer(this.x - incrementerWidth - 35, this.y - 15);
        this.fields.add(this.endX);
        this.endY = new GuiIncrementer(this.x - 32, this.y - 15);
        this.fields.add(this.endY);
        this.endZ = new GuiIncrementer(this.x + 32 + 35, this.y - 15);
        this.fields.add(this.endZ);
        this.fields.forEach(arg_0 -> ((CopyGUI)this).func_230480_a_(arg_0));
        this.updateTextFields();
        ArrayList<AbstractButton> buttons = new ArrayList<AbstractButton>(){
            {
                this.add(new CenteredButton(CopyGUI.this.y + 20, 50, (ITextComponent)GuiTranslation.SINGLE_CONFIRM.componentTranslation(new Object[0]), button -> {
                    if (CopyGUI.this.absoluteCoords) {
                        CopyGUI.this.startPos = new BlockPos(CopyGUI.this.startX.getValue(), CopyGUI.this.startY.getValue(), CopyGUI.this.startZ.getValue());
                        CopyGUI.this.endPos = new BlockPos(CopyGUI.this.endX.getValue(), CopyGUI.this.endY.getValue(), CopyGUI.this.endZ.getValue());
                    } else {
                        CopyGUI.this.startPos = new BlockPos(CopyGUI.this.startPos.func_177958_n() + CopyGUI.this.startX.getValue(), CopyGUI.this.startPos.func_177956_o() + CopyGUI.this.startY.getValue(), CopyGUI.this.startPos.func_177952_p() + CopyGUI.this.startZ.getValue());
                        CopyGUI.this.endPos = new BlockPos(CopyGUI.this.startPos.func_177958_n() + CopyGUI.this.endX.getValue(), CopyGUI.this.startPos.func_177956_o() + CopyGUI.this.endY.getValue(), CopyGUI.this.startPos.func_177952_p() + CopyGUI.this.endZ.getValue());
                    }
                    PacketHandler.sendToServer(new PacketCopyCoords(CopyGUI.this.startPos, CopyGUI.this.endPos));
                }));
                this.add(new CenteredButton(CopyGUI.this.y + 20, 50, (ITextComponent)GuiTranslation.SINGLE_CLOSE.componentTranslation(new Object[0]), button -> CopyGUI.this.func_231175_as__()));
                this.add(new CenteredButton(CopyGUI.this.y + 20, 50, (ITextComponent)GuiTranslation.SINGLE_CLEAR.componentTranslation(new Object[0]), button -> {
                    PacketHandler.sendToServer(new PacketCopyCoords(BlockPos.field_177992_a, BlockPos.field_177992_a));
                    CopyGUI.this.func_231175_as__();
                }));
                if (((Boolean)Config.GENERAL.allowAbsoluteCoords.get()).booleanValue()) {
                    this.add(new CenteredButton(CopyGUI.this.y + 20, 120, (ITextComponent)GuiTranslation.COPY_BUTTON_ABSOLUTE.componentTranslation(new Object[0]), button -> {
                        CopyGUI.this.coordsModeSwitch();
                        CopyGUI.this.updateTextFields();
                    }));
                }
            }
        };
        CenteredButton.centerButtonList((List<AbstractButton>)buttons, this.x);
        buttons.forEach(arg_0 -> ((CopyGUI)this).func_230480_a_(arg_0));
    }

    private void drawFieldLabel(MatrixStack matrices, String name, int x, int y) {
        this.field_230712_o_.func_238405_a_(matrices, name, (float)(this.x + x), (float)(this.y + y), 0xFFFFFF);
    }

    private void coordsModeSwitch() {
        this.absoluteCoords = !this.absoluteCoords;
    }

    private void updateTextFields() {
        if (this.absoluteCoords) {
            BlockPos start = this.startX.getValue() != 0 ? new BlockPos(this.startPos.func_177958_n() + this.startX.getValue(), this.startPos.func_177956_o() + this.startY.getValue(), this.startPos.func_177952_p() + this.startZ.getValue()) : this.startPos;
            BlockPos end = this.endX.getValue() != 0 ? new BlockPos(this.startPos.func_177958_n() + this.endX.getValue(), this.startPos.func_177956_o() + this.endY.getValue(), this.startPos.func_177952_p() + this.endZ.getValue()) : this.endPos;
            this.startX.setValue(start.func_177958_n());
            this.startY.setValue(start.func_177956_o());
            this.startZ.setValue(start.func_177952_p());
            this.endX.setValue(end.func_177958_n());
            this.endY.setValue(end.func_177956_o());
            this.endZ.setValue(end.func_177952_p());
        } else {
            this.startX.setValue(this.startX.getValue() != 0 ? this.startX.getValue() - this.startPos.func_177958_n() : 0);
            this.startY.setValue(this.startY.getValue() != 0 ? this.startY.getValue() - this.startPos.func_177956_o() : 0);
            this.startZ.setValue(this.startZ.getValue() != 0 ? this.startZ.getValue() - this.startPos.func_177952_p() : 0);
            this.endX.setValue(this.endX.getValue() != 0 ? this.endX.getValue() - this.startPos.func_177958_n() : this.endPos.func_177958_n() - this.startPos.func_177958_n());
            this.endY.setValue(this.endY.getValue() != 0 ? this.endY.getValue() - this.startPos.func_177956_o() : this.endPos.func_177956_o() - this.startPos.func_177956_o());
            this.endZ.setValue(this.endZ.getValue() != 0 ? this.endZ.getValue() - this.startPos.func_177952_p() : this.endPos.func_177952_p() - this.startPos.func_177952_p());
        }
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float partialTicks) {
        this.drawFieldLabel(matrices, GuiTranslation.FIELD_START.format(new Object[0]) + " X", -175, -36);
        this.drawFieldLabel(matrices, "Y", -45, -36);
        this.drawFieldLabel(matrices, "Z", 55, -36);
        this.drawFieldLabel(matrices, GuiTranslation.FIELD_END.format(new Object[0]) + " X", -167, -11);
        this.drawFieldLabel(matrices, "Y", -45, -11);
        this.drawFieldLabel(matrices, "Z", 55, -11);
        CopyGUI.func_238471_a_((MatrixStack)matrices, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)I18n.func_135052_a((String)GuiTranslation.COPY_LABEL_HEADING.getTranslationKey(), (Object[])new Object[0]), (int)this.x, (int)(this.y - 80), (int)0xFFFFFF);
        CopyGUI.func_238471_a_((MatrixStack)matrices, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)I18n.func_135052_a((String)GuiTranslation.COPY_LABEL_SUBHEADING.getTranslationKey(), (Object[])new Object[0]), (int)this.x, (int)(this.y - 68), (int)0xFFFFFF);
        super.func_230430_a_(matrices, mouseX, mouseY, partialTicks);
    }

    public boolean func_231046_a_(int mouseX, int mouseY, int __unused) {
        this.fields.forEach(button -> button.func_231046_a_(mouseX, mouseY, __unused));
        return super.func_231046_a_(mouseX, mouseY, __unused);
    }

    public boolean func_231042_a_(char charTyped, int __unused) {
        this.fields.forEach(button -> button.func_231042_a_(charTyped, __unused));
        return false;
    }

    public boolean func_231177_au__() {
        return false;
    }

    static class CenteredButton
    extends Button {
        CenteredButton(int y, int width, ITextComponent text, Button.IPressable onPress) {
            super(0, y, width, 20, text, onPress);
        }

        static void centerButtonList(List<AbstractButton> buttons, int startX) {
            int collectiveWidth = buttons.stream().mapToInt(Widget::func_230998_h_).sum() + (buttons.size() - 1) * 5;
            int nextX = startX - collectiveWidth / 2;
            for (AbstractButton button : buttons) {
                button.field_230690_l_ = nextX;
                nextX += button.func_230998_h_() + 5;
            }
        }
    }
}

