/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.shadowed.me.shedaniel.autoconfig1u.serializer;

import com.therandomlabs.randompatches.shadowed.me.shedaniel.autoconfig1u.ConfigData;
import com.therandomlabs.randompatches.shadowed.me.shedaniel.autoconfig1u.annotation.Config;
import com.therandomlabs.randompatches.shadowed.me.shedaniel.autoconfig1u.serializer.ConfigSerializer;
import com.therandomlabs.randompatches.shadowed.me.shedaniel.autoconfig1u.shadowed.com.moandjiezana.toml.Toml;
import com.therandomlabs.randompatches.shadowed.me.shedaniel.autoconfig1u.shadowed.com.moandjiezana.toml.TomlWriter;
import com.therandomlabs.randompatches.shadowed.me.shedaniel.autoconfig1u.util.Utils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraftforge.fml.loading.FMLPaths;

public class Toml4jConfigSerializer<T extends ConfigData>
implements ConfigSerializer<T> {
    private Config definition;
    private Class<T> configClass;
    private TomlWriter tomlWriter;

    public Toml4jConfigSerializer(Config definition, Class<T> configClass, TomlWriter tomlWriter) {
        this.definition = definition;
        this.configClass = configClass;
        this.tomlWriter = tomlWriter;
    }

    public Toml4jConfigSerializer(Config definition, Class<T> configClass) {
        this(definition, configClass, new TomlWriter());
    }

    private Path getConfigPath() {
        return FMLPaths.CONFIGDIR.get().toAbsolutePath().resolve(this.definition.name() + ".toml");
    }

    @Override
    public void serialize(T config) throws ConfigSerializer.SerializationException {
        Path configPath = this.getConfigPath();
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            this.tomlWriter.write(config, configPath.toFile());
        }
        catch (IOException e) {
            throw new ConfigSerializer.SerializationException(e);
        }
    }

    @Override
    public T deserialize() throws ConfigSerializer.SerializationException {
        Path configPath = this.getConfigPath();
        if (Files.exists(configPath, new LinkOption[0])) {
            try {
                return (T)((ConfigData)new Toml().read(configPath.toFile()).to(this.configClass));
            }
            catch (IllegalStateException e) {
                throw new ConfigSerializer.SerializationException(e);
            }
        }
        return this.createDefault();
    }

    @Override
    public T createDefault() {
        return (T)((ConfigData)Utils.constructUnsafely(this.configClass));
    }
}

