/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual.gui;

import blusunrize.lib.manual.ManualEntry;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.Tree;
import blusunrize.lib.manual.gui.ClickableList;
import blusunrize.lib.manual.gui.GuiButtonManualNavigation;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class ManualScreen
extends Screen {
    private Minecraft mc = Minecraft.func_71410_x();
    private float scaleFactor = 1.0f;
    private int xSize = 186;
    private int ySize = 198;
    private int guiLeft;
    private int guiTop;
    private List<Button> pageButtons = new ArrayList<Button>();
    @Nonnull
    public Tree.AbstractNode<ResourceLocation, ManualEntry> currentNode;
    public Stack<ManualInstance.ManualLink> previousSelectedEntry = new Stack();
    public int page;
    public static ManualScreen lastActiveManual;
    ManualInstance manual;
    ResourceLocation texture;
    private double[] lastClick;
    private double[] lastDrag;
    private TextFieldWidget searchField;
    private ClickableList entryList;
    private ClickableList suggestionList;
    private final boolean setLastActive;

    public ManualScreen(ManualInstance manual, ResourceLocation texture) {
        this(manual, texture, true);
    }

    public ManualScreen(ManualInstance manual, ResourceLocation texture, boolean setLastActive) {
        super((ITextComponent)new StringTextComponent("manual"));
        this.manual = manual;
        this.currentNode = manual.getRoot();
        this.texture = texture;
        this.setLastActive = setLastActive;
    }

    public ManualEntry getCurrentPage() {
        return this.currentNode.getLeafData();
    }

    public void setCurrentNode(@Nonnull Tree.AbstractNode<ResourceLocation, ManualEntry> entry) {
        this.currentNode = entry;
        if (this.currentNode.isLeaf()) {
            this.manual.openEntry(this.currentNode.getLeafData());
        }
    }

    public ManualInstance getManual() {
        return this.manual;
    }

    public void func_231160_c_() {
        MainWindow res = this.mc.func_228018_at_();
        double oldGuiScale = res.func_216521_a(this.mc.field_71474_y.field_74335_Z, this.mc.func_211821_e());
        int guiScaleInt = Math.min(this.manual.getGuiRescale(), this.getMinecraft().func_228018_at_().func_216521_a(0, true));
        double newGuiScale = res.func_216521_a(guiScaleInt, true);
        if (guiScaleInt > 0 && newGuiScale != oldGuiScale) {
            this.scaleFactor = (float)newGuiScale / (float)res.func_198100_s();
            res.func_216525_a(newGuiScale);
            this.field_230708_k_ = res.func_198107_o();
            this.field_230709_l_ = res.func_198087_p();
            res.func_216525_a(oldGuiScale);
        } else {
            this.scaleFactor = 1.0f;
        }
        this.manual.openManual();
        this.guiLeft = (this.field_230708_k_ - this.xSize) / 2;
        this.guiTop = (this.field_230709_l_ - this.ySize) / 2;
        boolean textField = false;
        this.pageButtons.clear();
        if (this.currentNode.isLeaf()) {
            this.currentNode.getLeafData().addButtons(this, this.guiLeft + 32, this.guiTop + 28, this.page, this.pageButtons);
            for (Button b : this.pageButtons) {
                this.func_230480_a_((Widget)b);
            }
        } else {
            ArrayList<Tree.AbstractNode<ResourceLocation, ManualEntry>> children = new ArrayList<Tree.AbstractNode<ResourceLocation, ManualEntry>>();
            for (Tree.AbstractNode<ResourceLocation, ManualEntry> node : this.currentNode.getChildren()) {
                if (!this.manual.showNodeInList(node)) continue;
                children.add(node);
            }
            Consumer<Tree.AbstractNode<ResourceLocation, ManualEntry>> openEntry = sel -> {
                if (sel != null) {
                    this.previousSelectedEntry.clear();
                    this.setCurrentNode((Tree.AbstractNode<ResourceLocation, ManualEntry>)sel);
                    this.fullInit();
                }
            };
            this.entryList = new ClickableList(this, this.guiLeft + 40, this.guiTop + 20, 100, 168, 1.0f, children, openEntry);
            this.func_230480_a_((Widget)this.entryList);
            this.suggestionList = new ClickableList(this, this.guiLeft + 180, this.guiTop + 138, 100, 80, 1.0f, new ArrayList<Tree.AbstractNode<ResourceLocation, ManualEntry>>(), openEntry);
            this.suggestionList.field_230694_p_ = false;
            this.func_230480_a_((Widget)this.suggestionList);
            textField = true;
        }
        if (this.currentNode.getSuperNode() != null) {
            this.func_230480_a_((Widget)new GuiButtonManualNavigation(this, this.guiLeft + 24, this.guiTop + 10, 10, 10, 0, btn -> {
                if (this.currentNode.isLeaf() && !this.previousSelectedEntry.isEmpty()) {
                    this.previousSelectedEntry.pop().changePage(this, false);
                } else if (this.currentNode.getSuperNode() != null) {
                    this.setCurrentNode(this.currentNode.getSuperNode());
                }
                this.page = 0;
                this.fullInit();
            }));
        }
        if (textField) {
            this.mc.field_195559_v.func_197967_a(true);
            this.searchField = new TextFieldWidget(this.field_230712_o_, this.guiLeft + 166, this.guiTop + 78, 120, 12, StringTextComponent.field_240750_d_);
            this.searchField.func_146193_g(-1);
            this.searchField.func_146204_h(-1);
            this.searchField.func_146185_a(false);
            this.searchField.func_146203_f(17);
            this.searchField.func_146195_b(true);
            this.searchField.func_146205_d(false);
        } else if (this.searchField != null) {
            this.searchField = null;
        }
        if (this.setLastActive) {
            lastActiveManual = this;
        }
    }

    public void fullInit() {
        super.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
    }

    public void func_230430_a_(MatrixStack transform, int mouseX, int mouseY, float f) {
        transform.func_227860_a_();
        if (this.scaleFactor != 1.0f) {
            transform.func_227862_a_(this.scaleFactor, this.scaleFactor, this.scaleFactor);
            mouseX = (int)((float)mouseX / this.scaleFactor);
            mouseY = (int)((float)mouseY / this.scaleFactor);
        }
        this.manual.entryRenderPre();
        ManualUtils.bindTexture(this.texture);
        this.func_238474_b_(transform, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        if (this.searchField != null) {
            int l = this.searchField.func_146179_b().length() * 6;
            if (l > 20) {
                this.func_238474_b_(transform, this.guiLeft + 166, this.guiTop + 74, 136 + (120 - l), 238, l, 18);
            }
            if (this.suggestionList.field_230694_p_) {
                this.func_238474_b_(transform, this.guiLeft + 174, this.guiTop + 100, 214, 212, 16, 26);
                int h = this.suggestionList.getHeight();
                int w = 76;
                this.func_238474_b_(transform, this.guiLeft + 174, this.guiTop + 116, 230, 212, 16, 16);
                this.func_238474_b_(transform, this.guiLeft + 174, this.guiTop + 132 + h, 230, 228, 16, 10);
                this.func_238474_b_(transform, this.guiLeft + 190 + w, this.guiTop + 116, 246, 212, 10, 16);
                this.func_238474_b_(transform, this.guiLeft + 190 + w, this.guiTop + 132 + h, 246, 228, 10, 10);
                for (int hh = 0; hh < h; ++hh) {
                    this.func_238474_b_(transform, this.guiLeft + 174, this.guiTop + 132 + hh, 230, 228, 16, 1);
                    for (int ww = 0; ww < w; ++ww) {
                        this.func_238474_b_(transform, this.guiLeft + 190 + ww, this.guiTop + 132 + hh, 246, 228, 1, 1);
                    }
                    this.func_238474_b_(transform, this.guiLeft + 190 + w, this.guiTop + 132 + hh, 246, 228, 10, 1);
                }
                for (int ww = 0; ww < w; ++ww) {
                    this.func_238474_b_(transform, this.guiLeft + 190 + ww, this.guiTop + 116, 246, 212, 1, 16);
                    this.func_238474_b_(transform, this.guiLeft + 190 + ww, this.guiTop + 132 + h, 246, 228, 1, 10);
                }
            }
        }
        if (this.currentNode.isLeaf()) {
            ManualEntry selectedEntry = this.currentNode.getLeafData();
            boolean b0 = (mouseX -= this.guiLeft) > 32 && mouseX < 49 && (mouseY -= this.guiTop) > 179 && mouseY < 189;
            boolean b1 = mouseX > 135 && mouseX < 152 && mouseY > 179 && mouseY < 189;
            RenderSystem.enableBlend();
            if (this.page > 0) {
                this.func_238474_b_(transform, this.guiLeft + 32, this.guiTop + 179, 0, 216 + (b0 ? 20 : 0), 16, 10);
            }
            if (this.page < selectedEntry.getPageCount() - 1) {
                this.func_238474_b_(transform, this.guiLeft + 136, this.guiTop + 179, 0, 226 + (b1 ? 20 : 0), 16, 10);
            }
            this.manual.titleRenderPre();
            this.drawCenteredStringScaled(transform, this.manual.fontRenderer(), TextFormatting.BOLD + selectedEntry.getTitle(), this.guiLeft + this.xSize / 2, this.guiTop + 14, this.manual.getTitleColour(), 1.0f, true);
            this.drawCenteredStringScaled(transform, this.manual.fontRenderer(), this.manual.formatEntrySubtext(selectedEntry.getSubtext()), this.guiLeft + this.xSize / 2, this.guiTop + 22, this.manual.getSubTitleColour(), 1.0f, true);
            this.drawCenteredStringScaled(transform, this.manual.fontRenderer(), TextFormatting.BOLD.toString() + (this.page + 1), this.guiLeft + this.xSize / 2, this.guiTop + 183, this.manual.getPagenumberColour(), 1.0f, false);
            this.manual.titleRenderPost();
            selectedEntry.renderPage(transform, this, this.guiLeft + 32, this.guiTop + 28, mouseX - 32, mouseY - 28);
            mouseX += this.guiLeft;
            mouseY += this.guiTop;
        } else {
            String title = ManualUtils.getTitleForNode(this.currentNode, this.manual);
            this.manual.titleRenderPre();
            this.drawCenteredStringScaled(transform, this.manual.fontRenderer(), TextFormatting.BOLD + title, this.guiLeft + this.xSize / 2, this.guiTop + 12, this.manual.getTitleColour(), 1.0f, true);
            this.manual.titleRenderPost();
        }
        if (this.searchField != null) {
            this.searchField.func_230430_a_(transform, mouseX, mouseY, f);
            if (this.suggestionList.field_230694_p_) {
                this.manual.fontRenderer().func_238421_b_(transform, "It looks like you meant:", (float)(this.guiLeft + 180), (float)(this.guiTop + 128), this.manual.getTextColour());
            }
        }
        for (Button btn : this.pageButtons) {
            btn.func_230430_a_(transform, mouseX, mouseY, f);
        }
        super.func_230430_a_(transform, mouseX, mouseY, f);
        RenderSystem.enableBlend();
        this.manual.entryRenderPost();
        transform.func_227865_b_();
    }

    public void func_231164_f_() {
        this.manual.closeManual();
        super.func_231164_f_();
    }

    private void drawCenteredStringScaled(MatrixStack transform, FontRenderer fr, String s, int x, int y, int colour, float scale, boolean shadow) {
        int xx = (int)Math.floor((double)((float)x / scale) - (double)fr.func_78256_a(s) / 2.0);
        double d = (float)y / scale;
        fr.getClass();
        int yy = (int)Math.floor(d - 9.0 / 2.0);
        if (scale != 1.0f) {
            transform.func_227860_a_();
            transform.func_227862_a_(scale, scale, scale);
        }
        if (shadow) {
            fr.func_238405_a_(transform, s, (float)xx, (float)yy, colour);
        } else {
            fr.func_238421_b_(transform, s, (float)xx, (float)yy, colour);
        }
        if (scale != 1.0f) {
            transform.func_227865_b_();
        }
    }

    public List<ITextComponent> func_231151_a_(ItemStack stack) {
        ManualInstance.ManualLink link;
        List tooltip = super.func_231151_a_(stack);
        if (this.currentNode.isLeaf() && this.currentNode.getLeafData().getHighlightedStack(this.page) == stack && (link = this.manual.getManualLink(stack)) != null) {
            tooltip.add(new StringTextComponent(this.manual.formatLink(link)));
        }
        return tooltip;
    }

    public void renderToolTip(MatrixStack transform, List<? extends IReorderingProcessor> text, int x, int y, FontRenderer font) {
        transform.func_227860_a_();
        transform.func_227862_a_(1.0f, 1.0f, 1.0f / this.scaleFactor);
        this.manual.tooltipRenderPre();
        super.renderToolTip(transform, text, x, y, font);
        this.manual.tooltipRenderPost();
        transform.func_227865_b_();
    }

    public boolean func_231043_a_(double x, double y, double wheel) {
        super.func_231043_a_(x, y, wheel);
        if (wheel != 0.0 && this.currentNode.isLeaf()) {
            if (wheel > 0.0 && this.page > 0) {
                --this.page;
                this.fullInit();
                return true;
            }
            if (wheel < 0.0 && this.page < this.currentNode.getLeafData().getPageCount() - 1) {
                ++this.page;
                this.fullInit();
                return true;
            }
        }
        return false;
    }

    public boolean func_231044_a_(double mx, double my, int button) {
        mx /= (double)this.scaleFactor;
        my /= (double)this.scaleFactor;
        if (button == 0 && this.currentNode.isLeaf()) {
            ManualEntry selectedEntry = this.currentNode.getLeafData();
            double mxRelative = mx - (double)this.guiLeft;
            double myRelative = my - (double)this.guiTop;
            if (this.page > 0 && mxRelative > 32.0 && mxRelative < 49.0 && myRelative > 179.0 && myRelative < 189.0) {
                --this.page;
                this.fullInit();
                return true;
            }
            if (this.page < selectedEntry.getPageCount() - 1 && mxRelative > 135.0 && mxRelative < 152.0 && myRelative > 179.0 && myRelative < 189.0) {
                ++this.page;
                this.fullInit();
                return true;
            }
            ItemStack highlighted = selectedEntry.getHighlightedStack(this.page);
            if (!highlighted.func_190926_b()) {
                ManualInstance.ManualLink link = this.getManual().getManualLink(highlighted);
                if (link != null) {
                    link.changePage(this, true);
                }
                return true;
            }
        } else if (button == 1) {
            if (this.searchField != null && !this.searchField.func_146179_b().isEmpty()) {
                this.searchField.func_146180_a("");
            } else if (this.currentNode.isLeaf() && !this.previousSelectedEntry.isEmpty()) {
                this.previousSelectedEntry.pop().changePage(this, false);
            } else if (this.currentNode.getSuperNode() != null) {
                this.setCurrentNode(this.currentNode.getSuperNode());
                this.page = 0;
            }
            this.fullInit();
            return true;
        }
        this.lastClick = new double[]{mx - (double)this.guiLeft, my - (double)this.guiTop};
        if (super.func_231044_a_(mx, my, button)) {
            return true;
        }
        if (this.searchField != null) {
            this.searchField.func_231044_a_(mx, my, button);
        }
        return false;
    }

    public boolean func_231048_c_(double mx, double my, int action) {
        this.lastClick = null;
        this.lastDrag = null;
        return super.func_231048_c_(mx, my, action);
    }

    public boolean func_231045_a_(double mx, double my, int button, double deltaX, double deltaY) {
        mx /= (double)this.scaleFactor;
        my /= (double)this.scaleFactor;
        if (this.lastClick != null && this.currentNode.isLeaf()) {
            if (this.lastDrag == null) {
                this.lastDrag = new double[]{mx - (double)this.guiLeft, my - (double)this.guiTop};
            }
            this.currentNode.getLeafData().mouseDragged(this, this.guiLeft + 32, this.guiTop + 28, this.lastClick[0], this.lastClick[1], mx - (double)this.guiLeft, my - (double)this.guiTop, this.lastDrag[0], this.lastDrag[1], button);
            this.lastDrag = new double[]{mx - (double)this.guiLeft, my - (double)this.guiTop};
            return true;
        }
        return false;
    }

    public boolean func_231042_a_(char p_charTyped_1_, int p_charTyped_2_) {
        if (this.searchField != null && this.searchField.func_231042_a_(p_charTyped_1_, p_charTyped_2_)) {
            this.updateSearch();
            return true;
        }
        return super.func_231042_a_(p_charTyped_1_, p_charTyped_2_);
    }

    public boolean func_231046_a_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.searchField != null && this.searchField.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) {
            this.updateSearch();
            return true;
        }
        return super.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    private void updateSearch() {
        String search = this.searchField.func_146179_b();
        if (search.trim().isEmpty()) {
            this.suggestionList.field_230694_p_ = false;
            this.fullInit();
        } else {
            search = search.toLowerCase(Locale.ENGLISH);
            ArrayList<Tree.AbstractNode<ResourceLocation, ManualEntry>> lHeaders = new ArrayList<Tree.AbstractNode<ResourceLocation, ManualEntry>>();
            HashSet lSpellcheck = new HashSet();
            String searchFinal = search;
            this.manual.getAllEntriesAndCategories().forEach(node -> {
                if (this.manual.showNodeInList((Tree.AbstractNode<ResourceLocation, ManualEntry>)node)) {
                    String title = ManualUtils.getTitleForNode(node, this.manual).toLowerCase(Locale.ENGLISH);
                    if (title.contains(searchFinal)) {
                        lHeaders.add((Tree.AbstractNode<ResourceLocation, ManualEntry>)node);
                    } else {
                        lSpellcheck.add(node);
                    }
                }
            });
            List<Tree.AbstractNode<ResourceLocation, ManualEntry>> lCorrections = ManualUtils.getPrimitiveSpellingCorrections(search, lSpellcheck, 4, e -> ManualUtils.getTitleForNode(e, this.manual));
            for (Tree.AbstractNode node2 : lSpellcheck) {
                if (lCorrections.contains(node2) || !node2.isLeaf() || !((ManualEntry)node2.getLeafData()).listForSearch(search)) continue;
                lHeaders.add(node2);
                lCorrections.add(node2);
                break;
            }
            this.entryList.setEntries(lHeaders);
            if (!lCorrections.isEmpty()) {
                this.suggestionList.setEntries(lCorrections);
            }
            this.suggestionList.field_230694_p_ = !lCorrections.isEmpty();
        }
    }

    public void func_238468_a_(MatrixStack transform, int x1, int yA, int x2, int yB, int colorA, int colorB) {
        super.func_238468_a_(transform, x1, yA, x2, yB, colorA, colorB);
    }

    public boolean func_231177_au__() {
        return false;
    }
}

