/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.loot;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import blusunrize.immersiveengineering.common.util.loot.IELootFunctions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootPoolEntryType;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class DropInventoryLootEntry
extends StandaloneLootEntry {
    public static final ResourceLocation ID = new ResourceLocation("immersiveengineering", "drop_inv");

    protected DropInventoryLootEntry(int weightIn, int qualityIn, ILootCondition[] conditionsIn, ILootFunction[] functionsIn) {
        super(weightIn, qualityIn, conditionsIn, functionsIn);
    }

    protected void func_216154_a(@Nonnull Consumer<ItemStack> output, LootContext context) {
        if (context.func_216033_a(LootParameters.field_216288_h)) {
            TileEntity te = (TileEntity)context.func_216031_c(LootParameters.field_216288_h);
            if (te instanceof IEBlockInterfaces.IGeneralMultiblock) {
                te = (TileEntity)((IEBlockInterfaces.IGeneralMultiblock)te).master();
            }
            if (te instanceof IIEInventory && ((IIEInventory)te).getDroppedItems() != null) {
                ((IIEInventory)te).getDroppedItems().forEach(output);
            } else if (te != null) {
                LazyOptional itemHandler = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
                itemHandler.ifPresent(h -> {
                    if (h instanceof IEInventoryHandler) {
                        for (int i = 0; i < h.getSlots(); ++i) {
                            if (h.getStackInSlot(i).func_190926_b()) continue;
                            output.accept(h.getStackInSlot(i));
                            ((IEInventoryHandler)h).setStackInSlot(i, ItemStack.field_190927_a);
                        }
                    }
                });
            }
        }
    }

    public static StandaloneLootEntry.Builder<?> builder() {
        return DropInventoryLootEntry.func_216156_a(DropInventoryLootEntry::new);
    }

    @Nonnull
    public LootPoolEntryType func_230420_a_() {
        return IELootFunctions.dropInventory;
    }

    public static class Serializer
    extends StandaloneLootEntry.Serializer<DropInventoryLootEntry> {
        @Nonnull
        protected DropInventoryLootEntry deserialize(@Nonnull JsonObject json, @Nonnull JsonDeserializationContext context, int weight, int quality, @Nonnull ILootCondition[] conditions, @Nonnull ILootFunction[] functions) {
            return new DropInventoryLootEntry(weight, quality, conditions, functions);
        }
    }
}

