/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.fluids;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

public class IEItemFluidHandler
extends FluidHandlerItemStack {
    public static ITextComponent fluidItemInfoFlavor(@Nullable FluidStack fluid, int fluidCapacity) {
        if (fluid != null && fluid.getAmount() > 0) {
            FluidAttributes attr = fluid.getFluid().getAttributes();
            TextFormatting rarity = attr.getRarity() == Rarity.COMMON ? TextFormatting.GRAY : attr.getRarity().field_77937_e;
            return ClientUtils.applyFormat((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.flavour.fluidStack", new Object[]{fluid.getDisplayName(), fluid.getAmount(), fluidCapacity}), rarity);
        }
        return ClientUtils.applyFormat((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.flavour.drill.empty"), TextFormatting.GRAY);
    }

    public IEItemFluidHandler(ItemStack container, int capacity) {
        super(container, capacity);
    }

    public int getCapacity() {
        if (this.container.func_77973_b() instanceof IEItemInterfaces.IAdvancedFluidItem) {
            return ((IEItemInterfaces.IAdvancedFluidItem)this.container.func_77973_b()).getCapacity(this.container, this.capacity);
        }
        return this.capacity;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        if (this.container.func_77973_b() instanceof IEItemInterfaces.IAdvancedFluidItem) {
            return ((IEItemInterfaces.IAdvancedFluidItem)this.container.func_77973_b()).allowFluid(this.container, fluid);
        }
        return true;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack fluid) {
        FluidStack tankFluid = this.getFluidInTank(tank);
        return tankFluid.isEmpty() && this.canFillFluidType(fluid) || tankFluid.isFluidEqual(fluid);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
        if (this.container.func_190916_E() != 1 || resource.isEmpty() || !this.canFillFluidType(resource)) {
            return 0;
        }
        FluidStack contained = this.getFluid();
        if (contained.isEmpty()) {
            int fillAmount = Math.min(this.getCapacity(), resource.getAmount());
            if (doFill.execute()) {
                FluidStack filled = resource.copy();
                filled.setAmount(fillAmount);
                this.setFluid(filled);
            }
            return fillAmount;
        }
        if (contained.isFluidEqual(resource)) {
            int fillAmount = Math.min(this.getCapacity() - contained.getAmount(), resource.getAmount());
            if (doFill.execute() && fillAmount > 0) {
                contained.grow(fillAmount);
                this.setFluid(contained);
            }
            return fillAmount;
        }
        return 0;
    }

    public int getTankCapacity(int tank) {
        return this.getCapacity();
    }
}

