/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.excavator.ExcavatorHandler;
import blusunrize.immersiveengineering.api.excavator.MineralVein;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ColumnPos;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;

public class SurveyToolsItem
extends IEBaseItem {
    private static final List<BiPredicate<World, BlockPos>> CAN_USE_ON = new ArrayList<BiPredicate<World, BlockPos>>();
    private static final String DATA_KEY = "veinData";

    public SurveyToolsItem() {
        super("survey_tools", new Item.Properties().func_200917_a(1).func_200915_b(300));
        CAN_USE_ON.add((world, pos) -> {
            BlockState state = world.func_180495_p(pos);
            return state.func_185904_a() == Material.field_151571_B || state.func_185904_a() == Material.field_151578_c || state.func_185904_a() == Material.field_151577_b || state.func_185904_a() == Material.field_151595_p;
        });
        CAN_USE_ON.add((world, pos) -> Tags.Blocks.STONE.func_230235_a_((Object)world.func_180495_p(pos).func_177230_c()));
        CAN_USE_ON.add((world, pos) -> {
            Block block = world.func_180495_p(pos).func_177230_c();
            return block == Blocks.field_235406_np_ || block == Blocks.field_235337_cO_;
        });
        CAN_USE_ON.add((world, pos) -> {
            BlockState state = world.func_180495_p(pos);
            return state.func_185904_a() == Material.field_151576_e && (double)state.func_185887_b((IBlockReader)world, pos) < 0.5;
        });
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 50;
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.PASS;
        }
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        if (!CAN_USE_ON.stream().anyMatch(predicate -> predicate.test(world, pos))) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.info.survey.wrong_block"), true);
            return ActionResultType.FAIL;
        }
        player.func_184598_c(context.func_221531_n());
        return ActionResultType.SUCCESS;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity entityLiving) {
        TranslationTextComponent response;
        if (!(entityLiving instanceof ServerPlayerEntity)) {
            return stack;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)entityLiving;
        BlockRayTraceResult rtr = SurveyToolsItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
        if (!(rtr instanceof BlockRayTraceResult)) {
            return stack;
        }
        BlockPos pos = rtr.func_216350_a();
        MineralVein vein = ExcavatorHandler.getRandomMineral(world, pos);
        if (vein == null || vein.getMineral() == null) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.info.survey.no_vein"), true);
            return stack;
        }
        ListNBT data = SurveyToolsItem.getVeinData(stack, (RegistryKey<World>)world.func_234923_W_(), vein.getPos());
        int dataCount = data.size();
        boolean tooClose = data.stream().anyMatch(inbt -> {
            int dZ;
            int dX = ((CompoundNBT)inbt).func_74762_e("x") - pos.func_177958_n();
            return dX * dX + (dZ = ((CompoundNBT)inbt).func_74762_e("z") - pos.func_177952_p()) * dZ < 16;
        });
        if (tooClose) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.info.survey.too_close"), true);
            return stack;
        }
        Vector2f vecToCenter = new Vector2f((float)(vein.getPos().field_219439_a - pos.func_177958_n()), (float)(vein.getPos().field_219440_b - pos.func_177952_p()));
        if (vecToCenter.field_189982_i == 0.0f && vecToCenter.field_189983_j == 0.0f) {
            response = new TranslationTextComponent("chat.immersiveengineering.info.survey.hint.center", new Object[]{new TranslationTextComponent(vein.getMineral().getTranslationKey())});
        } else {
            double angle = Math.toDegrees(Math.atan2(vecToCenter.field_189983_j, vecToCenter.field_189982_i));
            int segment = (int)((angle + 270.0) % 360.0 / 45.0);
            switch (dataCount) {
                case 0: {
                    response = new TranslationTextComponent("chat.immersiveengineering.info.survey.hint.1", new Object[]{new TranslationTextComponent(vein.getMineral().getTranslationKey())});
                    break;
                }
                case 1: {
                    response = new TranslationTextComponent("chat.immersiveengineering.info.survey.hint.2", new Object[]{new TranslationTextComponent(vein.getMineral().getTranslationKey()), new TranslationTextComponent("chat.immersiveengineering.info.survey.direction." + segment)});
                    break;
                }
                default: {
                    response = new TranslationTextComponent("chat.immersiveengineering.info.survey.hint.3", new Object[]{new TranslationTextComponent(vein.getMineral().getTranslationKey()), Math.round(Math.sqrt(vecToCenter.field_189982_i * vecToCenter.field_189982_i + vecToCenter.field_189983_j * vecToCenter.field_189983_j)), new TranslationTextComponent("chat.immersiveengineering.info.survey.direction." + segment)});
                }
            }
        }
        player.func_146105_b((ITextComponent)response, true);
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("x", pos.func_177958_n());
        tag.func_74768_a("z", pos.func_177952_p());
        tag.func_74778_a("hint", ITextComponent.Serializer.func_150696_a((ITextComponent)response));
        data.add((Object)tag);
        world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_219617_ah, SoundCategory.NEUTRAL, 1.0f, 1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.4f);
        stack.func_222118_a(1, (LivingEntity)player, user -> user.func_213334_d(user.func_184600_cs()));
        return stack;
    }

    public static ListNBT getVeinData(ItemStack surveyTools, RegistryKey<World> dimension, ColumnPos veinPos) {
        ListNBT list = surveyTools.func_196082_o().func_150295_c(DATA_KEY, 10);
        CompoundNBT tag = null;
        String dimString = dimension.func_240901_a_().toString();
        for (INBT nbt : list) {
            CompoundNBT tmp = (CompoundNBT)nbt;
            if (!dimString.equals(tmp.func_74779_i("dimension")) || tmp.func_74762_e("x") != veinPos.field_219439_a || tmp.func_74762_e("z") != veinPos.field_219440_b) continue;
            tag = tmp;
            break;
        }
        if (tag == null) {
            tag = new CompoundNBT();
            tag.func_74778_a("dimension", dimString);
            tag.func_74768_a("x", veinPos.field_219439_a);
            tag.func_74768_a("z", veinPos.field_219440_b);
            list.add((Object)tag);
            surveyTools.func_196082_o().func_218657_a(DATA_KEY, (INBT)list);
        }
        if (tag.func_150297_b("data", 9)) {
            return tag.func_150295_c("data", 10);
        }
        ListNBT data = new ListNBT();
        tag.func_218657_a("data", (INBT)data);
        return data;
    }

    public boolean doesSneakBypassUse(ItemStack stack, IWorldReader world, BlockPos pos, PlayerEntity player) {
        return true;
    }

    public boolean func_77616_k(@Nonnull ItemStack stack) {
        return false;
    }
}

