/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class IEProjectileEntity
extends AbstractArrowEntity {
    private static final DataParameter<Optional<UUID>> SHOOTER_PARAMETER = EntityDataManager.func_187226_a(IEProjectileEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    protected BlockPos stuckIn = null;
    protected BlockState field_195056_av;
    public boolean field_70254_i;
    public int field_70252_j;
    public int ticksInAir;
    protected IntSet field_213878_az;
    @Nullable
    protected UUID shooterUUID;
    private int tickLimit = 40;

    public IEProjectileEntity(EntityType<? extends IEProjectileEntity> type, World world) {
        super(type, world);
        this.field_70251_a = AbstractArrowEntity.PickupStatus.DISALLOWED;
    }

    public IEProjectileEntity(EntityType<? extends IEProjectileEntity> type, World world, double x, double y, double z) {
        this(type, world);
        this.func_70012_b(x, y, z, this.field_70177_z, this.field_70125_A);
        this.func_70107_b(x, y, z);
    }

    public IEProjectileEntity(EntityType<? extends IEProjectileEntity> type, World world, LivingEntity living, double ax, double ay, double az) {
        this(type, world, living, living.func_226277_ct_(), living.func_226278_cu_() + (double)living.func_70047_e(), living.func_226281_cx_(), ax, ay, az);
    }

    public IEProjectileEntity(EntityType<? extends IEProjectileEntity> type, World world, LivingEntity living, double x, double y, double z, double ax, double ay, double az) {
        this(type, world);
        float yaw = living != null ? living.field_70177_z : 0.0f;
        float pitch = living != null ? living.field_70125_A : 0.0f;
        this.func_70012_b(x, y, z, yaw, pitch);
        this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        this.func_213293_j(ax, ay, az);
        this.func_212361_a((Entity)living);
        this.setShooterSynced();
        Vector3d motion = this.func_213322_ci();
        this.func_70186_c(motion.field_72450_a, motion.field_72448_b, motion.field_72449_c, 3.0f, 1.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SHOOTER_PARAMETER, Optional.empty());
    }

    @Nonnull
    public EntitySize func_213305_a(Pose p_213305_1_) {
        return new EntitySize(0.125f, 0.125f, true);
    }

    public void setTickLimit(int limit) {
        this.tickLimit = limit;
    }

    public void setShooterSynced() {
        this.field_70180_af.func_187227_b(SHOOTER_PARAMETER, Optional.ofNullable(this.shooterUUID));
    }

    public UUID getShooterSynced() {
        Optional s = (Optional)this.field_70180_af.func_187225_a(SHOOTER_PARAMETER);
        return s.orElse(null);
    }

    @Nullable
    public UUID getShooterUUID() {
        return this.shooterUUID;
    }

    @Nonnull
    protected ItemStack func_184550_j() {
        return ItemStack.field_190927_a;
    }

    public void func_70071_h_() {
        if (this.func_234616_v_() == null && this.field_70170_p.field_72995_K) {
            this.shooterUUID = this.getShooterSynced();
        }
        this.func_70030_z();
        BlockState localState = this.stuckIn != null ? this.field_70170_p.func_180495_p(this.stuckIn) : Blocks.field_150350_a.func_176223_P();
        if (localState.func_185904_a() != Material.field_151579_a) {
            VoxelShape shape = localState.func_196952_d((IBlockReader)this.field_70170_p, this.stuckIn);
            for (AxisAlignedBB subbox : shape.func_197756_d()) {
                if (!subbox.func_197744_e(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_())) continue;
                this.field_70254_i = true;
                break;
            }
        }
        if (this.field_70254_i) {
            if (localState == this.field_195056_av) {
                ++this.field_70252_j;
                if (this.field_70252_j >= this.getMaxTicksInGround()) {
                    this.func_70106_y();
                }
            } else {
                this.field_70254_i = false;
                this.func_213317_d(this.func_213322_ci().func_186678_a((double)(this.field_70146_Z.nextFloat() / 5.0f)));
                this.field_70252_j = 0;
                this.ticksInAir = 0;
            }
        } else {
            Vector3d nextPos;
            ++this.ticksInAir;
            if (this.ticksInAir >= this.tickLimit) {
                this.func_70106_y();
                return;
            }
            Vector3d currentPos = new Vector3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            BlockRayTraceResult mop = this.field_70170_p.func_217299_a(new RayTraceContext(currentPos, nextPos = new Vector3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()).func_178787_e(this.func_213322_ci()), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
            if (mop.func_216346_c() == RayTraceResult.Type.BLOCK) {
                nextPos = mop.func_216347_e();
            }
            if (mop.func_216346_c() != RayTraceResult.Type.ENTITY) {
                Entity entity = null;
                List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), Entity::func_70067_L);
                double d0 = 0.0;
                for (Entity entity1 : list) {
                    double d1;
                    if (!entity1.func_70067_L() || entity1.func_110124_au().equals(this.shooterUUID) && this.ticksInAir <= 5) continue;
                    float f = 0.3f;
                    AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_72314_b((double)f, (double)f, (double)f);
                    Optional movingobjectposition1 = axisalignedbb.func_216365_b(currentPos, nextPos);
                    if (!movingobjectposition1.isPresent() || !((d1 = currentPos.func_72438_d((Vector3d)movingobjectposition1.get())) < d0) && d0 != 0.0) continue;
                    entity = entity1;
                    d0 = d1;
                }
                if (entity != null) {
                    mop = new EntityRayTraceResult(entity);
                }
            }
            if (mop.func_216346_c() != RayTraceResult.Type.MISS) {
                if (mop.func_216346_c() == RayTraceResult.Type.ENTITY) {
                    PlayerEntity shooter;
                    EntityRayTraceResult entityHit = (EntityRayTraceResult)mop;
                    if (!this.func_70027_ad() && this.canIgnite() && entityHit.func_216348_a().func_70027_ad()) {
                        this.func_70015_d(3);
                    }
                    boolean allowHit = true;
                    if (this.shooterUUID != null && (shooter = this.field_70170_p.func_217371_b(this.shooterUUID)) != null && entityHit.func_216348_a() instanceof PlayerEntity) {
                        allowHit = shooter.func_96122_a((PlayerEntity)entityHit.func_216348_a());
                    }
                    if (allowHit) {
                        this.func_70227_a((RayTraceResult)mop);
                    }
                    this.handlePiecing(entityHit.func_216348_a());
                } else if (mop.func_216346_c() == RayTraceResult.Type.BLOCK) {
                    BlockRayTraceResult blockHit = mop;
                    this.func_70227_a((RayTraceResult)blockHit);
                    this.stuckIn = blockHit.func_216350_a();
                    this.field_195056_av = this.field_70170_p.func_180495_p(blockHit.func_216350_a());
                    this.func_213317_d(blockHit.func_216347_e().func_178788_d(this.func_213303_ch()));
                    float f2 = (float)this.func_213322_ci().func_72433_c();
                    Vector3d motion = this.func_213322_ci();
                    this.func_70107_b(this.func_226277_ct_() - motion.field_72450_a / (double)f2 * 0.05, this.func_226278_cu_() - motion.field_72448_b / (double)f2 * 0.05, this.func_226281_cx_() - motion.field_72449_c / (double)f2 * 0.05);
                    this.field_70254_i = true;
                    if (this.field_195056_av.func_185904_a() != Material.field_151579_a) {
                        this.field_195056_av.func_196950_a(this.field_70170_p, blockHit.func_216350_a(), (Entity)this);
                    }
                }
            }
            this.func_70107_b(this.func_226277_ct_() + this.func_213322_ci().field_72450_a, this.func_226278_cu_() + this.func_213322_ci().field_72448_b, this.func_226281_cx_() + this.func_213322_ci().field_72449_c);
            float absMotion = (float)this.func_213322_ci().func_72433_c();
            this.field_70177_z = (float)(Math.atan2(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72449_c) * 180.0 / Math.PI);
            this.field_70125_A = (float)(Math.atan2(this.func_213322_ci().field_72448_b, absMotion) * 180.0 / Math.PI);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float movementDecay = this.getMotionDecayFactor();
            if (this.func_70090_H()) {
                for (int j = 0; j < 4; ++j) {
                    float f3 = 0.25f;
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_() - this.func_213322_ci().field_72450_a * (double)f3, this.func_226278_cu_() - this.func_213322_ci().field_72448_b * (double)f3, this.func_226281_cx_() - this.func_213322_ci().field_72449_c * (double)f3, this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c);
                }
                movementDecay *= 0.8f;
            }
            if (movementDecay > 0.0f) {
                this.func_213317_d(this.func_213322_ci().func_186678_a((double)movementDecay).func_72441_c(0.0, -this.getGravity(), 0.0));
            }
            this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            this.func_145775_I();
        }
    }

    public void func_70100_b_(PlayerEntity player) {
        if (!this.field_70170_p.field_72995_K && (this.field_70254_i || this.func_203047_q()) && this.field_70249_b <= 0) {
            boolean flag;
            boolean bl = flag = this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED || this.field_70251_a == AbstractArrowEntity.PickupStatus.CREATIVE_ONLY && player.field_71075_bZ.field_75098_d || this.func_203047_q() && this.func_234616_v_().func_110124_au() == player.func_110124_au();
            if (this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED && !player.field_71071_by.func_70441_a(this.func_184550_j())) {
                flag = false;
            }
            if (flag) {
                player.func_71001_a((Entity)this, 1);
                this.func_70106_y();
            }
        }
    }

    protected void handlePiecing(Entity target) {
        if (this.func_213874_s() > 0) {
            if (this.field_213878_az == null) {
                this.field_213878_az = new IntOpenHashSet((int)this.func_213874_s());
            }
            if (this.field_213878_az.size() >= this.func_213874_s() + 1) {
                this.func_70106_y();
                return;
            }
            this.field_213878_az.add(target.func_145782_y());
        } else {
            this.func_70106_y();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distSq) {
        double d1 = this.func_174813_aQ().func_72320_b() * 4.0;
        return distSq < (d1 *= 64.0) * d1;
    }

    public double getGravity() {
        return 0.05f;
    }

    public boolean canIgnite() {
        return false;
    }

    public int getMaxTicksInGround() {
        return 100;
    }

    public abstract void func_70227_a(RayTraceResult var1);

    protected void onHitBlock(BlockRayTraceResult mop) {
        BlockState blockstate = this.field_70170_p.func_180495_p(mop.func_216350_a());
        blockstate.func_215690_a(this.field_70170_p, blockstate, mop, (ProjectileEntity)this);
    }

    protected float getMotionDecayFactor() {
        return 0.99f;
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        if (this.field_195056_av != null) {
            nbt.func_218657_a("inPos", (INBT)NBTUtil.func_186859_a((BlockPos)this.stuckIn));
            nbt.func_218657_a("inTile", (INBT)NBTUtil.func_190009_a((BlockState)this.field_195056_av));
        }
        nbt.func_74774_a("inGround", (byte)(this.field_70254_i ? 1 : 0));
        if (this.shooterUUID != null) {
            nbt.func_186854_a("Owner", this.shooterUUID);
        }
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_150297_b("inTile", 10)) {
            this.field_195056_av = NBTUtil.func_190008_d((CompoundNBT)nbt.func_74775_l("inTile"));
            this.stuckIn = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("inPos"));
        } else {
            this.field_195056_av = null;
            this.stuckIn = null;
        }
        this.field_70254_i = nbt.func_74771_c("inGround") == 1;
        this.shooterUUID = nbt.func_74764_b("Owner") ? nbt.func_186857_a("Owner") : null;
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        return false;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_212361_a(@Nullable Entity entityIn) {
        super.func_212361_a(entityIn);
        if (entityIn != null) {
            this.shooterUUID = entityIn.func_110124_au();
        }
    }
}

