/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.fluidaware;

import blusunrize.immersiveengineering.common.crafting.fluidaware.AbstractFluidAwareRecipe;
import blusunrize.immersiveengineering.common.crafting.fluidaware.AbstractShapedRecipe;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class BasicShapedRecipe
extends AbstractShapedRecipe<MatchLocation> {
    public BasicShapedRecipe(ResourceLocation idIn, String groupIn, int recipeWidthIn, int recipeHeightIn, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn) {
        super(idIn, groupIn, recipeWidthIn, recipeHeightIn, recipeItemsIn, recipeOutputIn);
    }

    public BasicShapedRecipe(ShapedRecipe vanillaBase) {
        this(vanillaBase.func_199560_c(), vanillaBase.func_193358_e(), vanillaBase.func_192403_f(), vanillaBase.func_192404_g(), (NonNullList<Ingredient>)vanillaBase.func_192400_c(), vanillaBase.func_77571_b());
    }

    protected boolean checkMatch(CraftingInventory craftingInventory, MatchLocation loc) {
        for (int invX = 0; invX < craftingInventory.func_174922_i(); ++invX) {
            for (int invY = 0; invY < craftingInventory.func_174923_h(); ++invY) {
                int recX = invX - loc.xOffset;
                int recY = invY - loc.yOffset;
                Ingredient expectedContent = Ingredient.field_193370_a;
                if (recX >= 0 && recY >= 0 && recX < this.getWidth() && recY < this.getHeight()) {
                    int recipeSlot = loc.mirrored ? this.getWidth() - recX - 1 + recY * this.getWidth() : recX + recY * this.getWidth();
                    expectedContent = (Ingredient)this.func_192400_c().get(recipeSlot);
                }
                if (expectedContent.test(craftingInventory.func_70301_a(invX + invY * craftingInventory.func_174922_i()))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @Nullable
    protected MatchLocation findMatch(CraftingInventory inv) {
        for (int xOffset = 0; xOffset <= inv.func_174922_i() - this.getWidth(); ++xOffset) {
            for (int yOffset = 0; yOffset <= inv.func_174923_h() - this.getHeight(); ++yOffset) {
                for (boolean mirror : BOOLEANS) {
                    MatchLocation loc = new MatchLocation(xOffset, yOffset, mirror, this.getWidth());
                    if (!this.checkMatch(inv, loc)) continue;
                    return loc;
                }
            }
        }
        return null;
    }

    public static class MatchLocation
    implements AbstractFluidAwareRecipe.IMatchLocation {
        private final int xOffset;
        private final int yOffset;
        private final boolean mirrored;
        private final int recipeWidth;

        private MatchLocation(int x, int y, boolean mirrored, int recipeWidth) {
            this.xOffset = x;
            this.yOffset = y;
            this.mirrored = mirrored;
            this.recipeWidth = recipeWidth;
        }

        @Override
        public int getListIndex(int x, int y) {
            int localX = x - this.xOffset;
            int localY = y - this.yOffset;
            if (this.mirrored) {
                return this.recipeWidth - localX - 1 + localY * this.recipeWidth;
            }
            return localX + localY * this.recipeWidth;
        }
    }
}

