/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.common.crafting.ArcRecyclingCalculator;
import blusunrize.immersiveengineering.common.crafting.PotionRecipeGenerators;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;

public class GeneratedListRecipe
extends IESerializableRecipe {
    public static Map<ResourceLocation, RecipeListGenerator<?>> LIST_GENERATORS = new HashMap();
    public static RegistryObject<IERecipeSerializer<GeneratedListRecipe>> SERIALIZER;
    @Nullable
    private List<? extends IESerializableRecipe> cachedRecipes;
    private final RecipeListGenerator<?> generator;

    public GeneratedListRecipe(ResourceLocation id) {
        super(ItemStack.field_190927_a, ((RecipeListGenerator)Preconditions.checkNotNull(LIST_GENERATORS.get(id), (Object)id)).recipeType, id);
        this.generator = LIST_GENERATORS.get(id);
    }

    public GeneratedListRecipe(ResourceLocation id, @Nullable List<IESerializableRecipe> subRecipes) {
        this(id);
        this.cachedRecipes = subRecipes;
    }

    @Override
    protected IERecipeSerializer<GeneratedListRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean func_192399_d() {
        return true;
    }

    public List<? extends IESerializableRecipe> getSubRecipes() {
        if (this.cachedRecipes == null) {
            this.cachedRecipes = (List)((RecipeListGenerator)this.generator).generator.get();
        }
        return this.cachedRecipes;
    }

    public ResourceLocation getSubSerializer() {
        return ((RecipeListGenerator)this.generator).serialized;
    }

    static {
        LIST_GENERATORS.put(ImmersiveEngineering.rl("mixer_potion_list"), new RecipeListGenerator<MixerRecipe>(PotionRecipeGenerators::initPotionRecipes, MixerRecipe.SERIALIZER.getId(), MixerRecipe.TYPE));
        LIST_GENERATORS.put(ImmersiveEngineering.rl("potion_bottling_list"), new RecipeListGenerator<BottlingMachineRecipe>(PotionRecipeGenerators::getPotionBottlingRecipes, BottlingMachineRecipe.SERIALIZER.getId(), BottlingMachineRecipe.TYPE));
        LIST_GENERATORS.put(ImmersiveEngineering.rl("arc_recycling_list"), new RecipeListGenerator<ArcFurnaceRecipe>(ArcRecyclingCalculator::getRecipesFromRunningThreads, ArcFurnaceRecipe.SERIALIZER.getId(), ArcFurnaceRecipe.TYPE));
    }

    public static class RecipeListGenerator<T extends IESerializableRecipe> {
        private final Supplier<List<T>> generator;
        private final ResourceLocation serialized;
        private final IRecipeType<T> recipeType;

        public RecipeListGenerator(Supplier<List<T>> generator, ResourceLocation serializer, IRecipeType<T> recipeType) {
            this.generator = generator;
            this.serialized = serializer;
            this.recipeType = recipeType;
        }
    }
}

