/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.stone;

import blusunrize.immersiveengineering.api.crafting.AlloyRecipe;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartTileEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class AlloySmelterTileEntity
extends MultiblockPartTileEntity<AlloySmelterTileEntity>
implements IIEInventory,
IEBlockInterfaces.IActiveState,
IEBlockInterfaces.IInteractionObjectIE,
IEBlockInterfaces.IProcessTile,
IEBlockInterfaces.IBlockBounds {
    NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    public int process = 0;
    public int processMax = 0;
    public int burnTime = 0;
    public int lastBurnTime = 0;
    public final AlloySmelterState guiState = new AlloySmelterState();

    public AlloySmelterTileEntity() {
        super(IEMultiblocks.ALLOY_SMELTER, (TileEntityType)IETileTypes.ALLOY_SMELTER.get(), false);
    }

    @Override
    public boolean canUseGui(PlayerEntity player) {
        return this.formed;
    }

    @Override
    public IEBlockInterfaces.IInteractionObjectIE getGuiMaster() {
        return (IEBlockInterfaces.IInteractionObjectIE)((Object)this.master());
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        return VoxelShapes.func_197868_b();
    }

    public void func_73660_a() {
        this.checkForNeedlessTicking();
        if (!this.field_145850_b.field_72995_K && this.formed && !this.isDummy()) {
            boolean activeAfterTick;
            ItemStack fuel;
            int newBurnTime;
            boolean activeBeforeTick = this.getIsActive();
            if (this.burnTime > 0) {
                AlloyRecipe recipe;
                boolean doneWork = false;
                if (this.process > 0) {
                    if (((ItemStack)this.inventory.get(0)).func_190926_b() || ((ItemStack)this.inventory.get(1)).func_190926_b()) {
                        this.process = 0;
                        this.processMax = 0;
                    } else {
                        recipe = this.getRecipe();
                        if (recipe != null && recipe.time != this.processMax) {
                            this.processMax = 0;
                            this.process = 0;
                            this.setActive(false);
                        } else {
                            --this.process;
                            doneWork = true;
                            if (!activeBeforeTick) {
                                this.setActive(true);
                            }
                        }
                    }
                    this.markContainingBlockForUpdate(null);
                }
                --this.burnTime;
                if (this.process <= 0) {
                    if (this.processMax > 0) {
                        recipe = this.getRecipe();
                        if (recipe != null) {
                            boolean flip = !recipe.input0.test((ItemStack)this.inventory.get(0));
                            Utils.modifyInvStackSize(this.inventory, flip ? 1 : 0, -recipe.input0.getCount());
                            Utils.modifyInvStackSize(this.inventory, flip ? 0 : 1, -recipe.input1.getCount());
                            if (!((ItemStack)this.inventory.get(3)).func_190926_b()) {
                                ((ItemStack)this.inventory.get(3)).func_190917_f(recipe.output.func_77946_l().func_190916_E());
                            } else {
                                this.inventory.set(3, (Object)recipe.output.func_77946_l());
                            }
                        }
                        this.processMax = 0;
                    }
                    if ((recipe = this.getRecipe()) != null) {
                        this.process = recipe.time;
                        if (!doneWork) {
                            --this.process;
                        }
                        this.processMax = recipe.time;
                        this.setActive(true);
                    }
                }
            } else if (activeBeforeTick) {
                this.setActive(false);
            }
            if (this.burnTime <= 10 && this.getRecipe() != null && (newBurnTime = ForgeHooks.getBurnTime((ItemStack)(fuel = (ItemStack)this.inventory.get(2)))) > 0) {
                this.lastBurnTime = newBurnTime;
                this.burnTime += this.lastBurnTime;
                Item itemFuel = fuel.func_77973_b();
                fuel.func_190918_g(1);
                if (fuel.func_190926_b()) {
                    this.inventory.set(2, (Object)itemFuel.getContainerItem(fuel));
                }
                this.markContainingBlockForUpdate(null);
            }
            if (activeBeforeTick != (activeAfterTick = this.getIsActive())) {
                this.func_70296_d();
                for (int x = 0; x < 2; ++x) {
                    for (int y = 0; y < 2; ++y) {
                        for (int z = 0; z < 2; ++z) {
                            BlockPos actualPos = this.getBlockPosForPos(new BlockPos(x, y, z));
                            TileEntity te = Utils.getExistingTileEntity(this.field_145850_b, actualPos);
                            if (!(te instanceof AlloySmelterTileEntity)) continue;
                            ((AlloySmelterTileEntity)te).setActive(activeAfterTick);
                        }
                    }
                }
            }
        }
    }

    public AlloyRecipe getRecipe() {
        if (((ItemStack)this.inventory.get(0)).func_190926_b() || ((ItemStack)this.inventory.get(1)).func_190926_b()) {
            return null;
        }
        AlloyRecipe recipe = AlloyRecipe.findRecipe((ItemStack)this.inventory.get(0), (ItemStack)this.inventory.get(1));
        if (recipe == null) {
            return null;
        }
        if (((ItemStack)this.inventory.get(3)).func_190926_b() || ItemStack.func_179545_c((ItemStack)((ItemStack)this.inventory.get(3)), (ItemStack)recipe.output) && ((ItemStack)this.inventory.get(3)).func_190916_E() + recipe.output.func_190916_E() <= this.getSlotLimit(3)) {
            return recipe;
        }
        return null;
    }

    @Override
    public int[] getCurrentProcessesStep() {
        AlloySmelterTileEntity master = (AlloySmelterTileEntity)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesStep();
        }
        return new int[]{this.processMax - this.process};
    }

    @Override
    public int[] getCurrentProcessesMax() {
        AlloySmelterTileEntity master = (AlloySmelterTileEntity)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesMax();
        }
        return new int[]{this.processMax};
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (id == 0) {
            this.formed = arg == 1;
        }
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
        return true;
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (!descPacket) {
            ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.inventory);
            this.process = nbt.func_74762_e("process");
            this.processMax = nbt.func_74762_e("processMax");
            this.burnTime = nbt.func_74762_e("burnTime");
            this.lastBurnTime = nbt.func_74762_e("lastBurnTime");
        }
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (!descPacket) {
            nbt.func_74768_a("process", this.process);
            nbt.func_74768_a("processMax", this.processMax);
            nbt.func_74768_a("burnTime", this.burnTime);
            nbt.func_74768_a("lastBurnTime", this.lastBurnTime);
            ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.inventory);
        }
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return slot == 0 || slot == 1 && FurnaceTileEntity.func_213991_b((ItemStack)stack);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(Direction side) {
        return new FluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, Direction side, FluidStack resources) {
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, Direction side) {
        return false;
    }

    private static int getBurnTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        return ForgeHooks.getBurnTime((ItemStack)stack);
    }

    public class AlloySmelterState
    implements IIntArray {
        public static final int LAST_BURN_TIME = 0;
        public static final int BURN_TIME = 1;
        public static final int PROCESS_MAX = 2;
        public static final int CURRENT_PROCESS = 3;

        public int getLastBurnTime() {
            return this.func_221476_a(0);
        }

        public int getBurnTime() {
            return this.func_221476_a(1);
        }

        public int getMaxProcess() {
            return this.func_221476_a(2);
        }

        public int getProcess() {
            return this.func_221476_a(3);
        }

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return AlloySmelterTileEntity.this.lastBurnTime;
                }
                case 1: {
                    return AlloySmelterTileEntity.this.burnTime;
                }
                case 2: {
                    return AlloySmelterTileEntity.this.processMax;
                }
                case 3: {
                    return AlloySmelterTileEntity.this.process;
                }
            }
            throw new IllegalArgumentException("Unknown index " + index);
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    AlloySmelterTileEntity.this.lastBurnTime = value;
                    break;
                }
                case 1: {
                    AlloySmelterTileEntity.this.burnTime = value;
                    break;
                }
                case 2: {
                    AlloySmelterTileEntity.this.processMax = value;
                    break;
                }
                case 3: {
                    AlloySmelterTileEntity.this.process = value;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown index " + index);
                }
            }
        }

        public int func_221478_a() {
            return 4;
        }
    }
}

