/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.utils.shapes.CachedVoxelShapes;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.ImmersiveConnectableTileEntity;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.localhandlers.EnergyTransferHandler;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.state.EnumProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RazorWireTileEntity
extends ImmersiveConnectableTileEntity
implements IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.ICollisionBounds,
IOBJModelCallback<BlockState>,
EnergyTransferHandler.EnergyConnector,
IEBlockInterfaces.ISelectionBounds {
    private static final CachedVoxelShapes<BoundingBoxKey> SHAPES = new CachedVoxelShapes<BoundingBoxKey>(RazorWireTileEntity::getShape);

    public RazorWireTileEntity() {
        super((TileEntityType<? extends ImmersiveConnectableTileEntity>)((TileEntityType)IETileTypes.RAZOR_WIRE.get()));
    }

    @Override
    public EnumProperty<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vector3d hit, LivingEntity entity) {
        return true;
    }

    @Override
    public boolean canRotate(Direction axis) {
        return true;
    }

    @Override
    public void onEntityCollision(World world, Entity entity) {
        if (entity instanceof LivingEntity) {
            Vector3d motion = entity.func_213322_ci();
            entity.func_213293_j(motion.func_82615_a() / 5.0, motion.func_82617_b(), motion.func_82616_c() / 5.0);
            RazorWireTileEntity.applyDamage((LivingEntity)entity);
        }
    }

    public static void applyDamage(LivingEntity entity) {
        int protection = (!entity.func_184582_a(EquipmentSlotType.FEET).func_190926_b() ? 1 : 0) + (!entity.func_184582_a(EquipmentSlotType.LEGS).func_190926_b() ? 1 : 0);
        float dmg = protection == 2 ? 0.5f : (protection == 1 ? 1.0f : 1.5f);
        entity.func_70097_a(IEDamageSources.razorWire, dmg);
    }

    @Override
    public VoxelShape getSelectionShape(@Nullable ISelectionContext ctx) {
        return VoxelShapes.func_197868_b();
    }

    @Override
    public VoxelShape getCollisionShape(ISelectionContext ctx) {
        return SHAPES.get(new BoundingBoxKey(this));
    }

    private static List<AxisAlignedBB> getShape(BoundingBoxKey key) {
        if (!key.onGround && !key.stacked || !key.wallL && !key.wallR) {
            return ImmutableList.of();
        }
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>(key.wallL && key.wallR ? 2 : 1);
        if (key.wallL) {
            list.add(new AxisAlignedBB(key.facing == Direction.SOUTH ? 0.8125 : 0.0, 0.0, key.facing == Direction.WEST ? 0.8125 : 0.0, key.facing == Direction.NORTH ? 0.1875 : 1.0, 1.0, key.facing == Direction.EAST ? 0.1875 : 1.0));
        }
        if (key.wallR) {
            list.add(new AxisAlignedBB(key.facing == Direction.NORTH ? 0.8125 : 0.0, 0.0, key.facing == Direction.EAST ? 0.8125 : 0.0, key.facing == Direction.SOUTH ? 0.1875 : 1.0, 1.0, key.facing == Direction.WEST ? 0.1875 : 1.0));
        }
        return list;
    }

    private boolean renderWall(boolean left) {
        Direction dir = left ? this.getFacing().func_176746_e() : this.getFacing().func_176735_f();
        BlockPos neighbourPos = this.func_174877_v().func_177967_a(dir, -1);
        if (!this.field_145850_b.func_175667_e(neighbourPos)) {
            return true;
        }
        if (this.field_145850_b.func_175625_s(neighbourPos) instanceof RazorWireTileEntity) {
            return false;
        }
        BlockState neighbour = this.field_145850_b.func_180495_p(neighbourPos);
        return !Block.func_208061_a((VoxelShape)neighbour.func_196954_c((IBlockReader)this.field_145850_b, neighbourPos), (Direction)dir);
    }

    private boolean isOnGround() {
        BlockPos down = this.func_174877_v().func_177977_b();
        return Block.func_208061_a((VoxelShape)this.field_145850_b.func_180495_p(down).func_196954_c((IBlockReader)this.field_145850_b, down), (Direction)Direction.UP);
    }

    private boolean isStacked() {
        BlockPos down = this.func_174877_v().func_177977_b();
        TileEntity te = this.field_145850_b.func_175625_s(down);
        if (te instanceof RazorWireTileEntity) {
            return ((RazorWireTileEntity)te).isOnGround();
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderGroup(BlockState object, String group) {
        if (group == null) {
            return false;
        }
        boolean stack = this.isStacked();
        if (!stack && !this.isOnGround()) {
            return !group.startsWith("wood");
        }
        if (group.startsWith("wood") && group.endsWith("inverted") != stack) {
            return false;
        }
        if (group.startsWith("wood_left")) {
            return this.renderWall(true);
        }
        if ("wire_left".equals(group) || "barbs_left".equals(group)) {
            return !this.renderWall(true);
        }
        if (group.startsWith("wood_right")) {
            return this.renderWall(false);
        }
        if ("wire_right".equals(group) || "barbs_right".equals(group)) {
            return !this.renderWall(false);
        }
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getCacheKey(BlockState object) {
        boolean stack = this.isStacked();
        if (!stack && !this.isOnGround()) {
            return "default";
        }
        return (this.renderWall(true) ? "L" : " ") + (this.renderWall(false) ? "R" : " ") + (stack ? "_stack" : "");
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vector3i offset) {
        return "LV".equals(cableType.getCategory());
    }

    @Override
    public Vector3d getConnectionOffset(@Nonnull Connection con, ConnectionPoint here) {
        boolean wallN;
        BlockPos other = con.getOtherEnd(here).getPosition();
        int xDif = other.func_177958_n() - this.field_174879_c.func_177958_n();
        int yDif = other.func_177956_o() - this.field_174879_c.func_177956_o();
        int zDif = other.func_177952_p() - this.field_174879_c.func_177952_p();
        boolean wallL = this.renderWall(true);
        boolean wallR = this.renderWall(false);
        if (!this.isOnGround() || !wallL && !wallR) {
            if (yDif > 0) {
                return new Vector3d(this.getFacing().func_82601_c() != 0 ? 0.5 : (xDif < 0 ? 0.40625 : 0.59375), 0.9375, this.getFacing().func_82599_e() != 0 ? 0.5 : (zDif < 0 ? 0.40625 : 0.59375));
            }
            boolean right = (float)this.getFacing().func_176746_e().func_176743_c().func_179524_a() == Math.copySign(1.0f, this.getFacing().func_82601_c() != 0 ? (float)zDif : (float)xDif);
            int faceX = this.getFacing().func_82601_c();
            int faceZ = this.getFacing().func_82599_e();
            return new Vector3d(faceX != 0 ? 0.5 + (right ? 0.0 : (double)faceX * 0.1875) : (double)(xDif >= 0 ? 1 : 0), 0.046875, faceZ != 0 ? 0.5 + (right ? 0.0 : (double)faceZ * 0.1875) : (double)(zDif >= 0 ? 1 : 0));
        }
        boolean bl = wallN = this.getFacing() == Direction.NORTH || this.getFacing() == Direction.EAST ? wallL : wallR;
        return new Vector3d(this.getFacing().func_82601_c() != 0 ? 0.5 : (xDif < 0 && wallN ? 0.125 : 0.875), 0.9375, this.getFacing().func_82599_e() != 0 ? 0.5 : (zDif < 0 && wallN ? 0.125 : 0.875));
    }

    @Override
    public boolean isSource(ConnectionPoint cp) {
        return false;
    }

    @Override
    public boolean isSink(ConnectionPoint cp) {
        return true;
    }

    @Override
    public int getRequestedEnergy() {
        return 64;
    }

    @Override
    public void insertEnergy(int amount) {
        int maxReach = amount / 8;
        int widthP = 0;
        boolean connectP = true;
        int widthN = 0;
        boolean connectN = true;
        Direction dir = this.getFacing().func_176746_e();
        if (dir.func_176743_c() == Direction.AxisDirection.NEGATIVE) {
            dir = dir.func_176734_d();
        }
        for (int i = 1; i <= maxReach; ++i) {
            BlockPos posP = this.func_174877_v().func_177967_a(dir, i);
            if (connectP && this.field_145850_b.func_175667_e(posP) && this.field_145850_b.func_175625_s(posP) instanceof RazorWireTileEntity) {
                ++widthP;
            } else {
                connectP = false;
            }
            BlockPos posN = this.func_174877_v().func_177967_a(dir, -i);
            if (connectN && this.field_145850_b.func_175667_e(posN) && this.field_145850_b.func_175625_s(posN) instanceof RazorWireTileEntity) {
                ++widthN;
                continue;
            }
            connectN = false;
        }
        AxisAlignedBB aabb = new AxisAlignedBB(this.func_174877_v().func_177982_a(this.getFacing().func_176740_k() == Direction.Axis.Z ? -widthN : 0, 0, this.getFacing().func_176740_k() == Direction.Axis.X ? -widthN : 0), this.func_174877_v().func_177982_a(this.getFacing().func_176740_k() == Direction.Axis.Z ? 1 + widthP : 1, 1, this.getFacing().func_176740_k() == Direction.Axis.X ? 1 + widthP : 1));
        List entities = this.field_145850_b.func_217357_a(LivingEntity.class, aabb);
        for (LivingEntity ent : entities) {
            ent.func_70097_a(IEDamageSources.razorShock, 2.0f);
        }
    }

    private static class BoundingBoxKey {
        public final boolean wallL;
        public final boolean wallR;
        public final boolean onGround;
        public final boolean stacked;
        public final Direction facing;

        public BoundingBoxKey(RazorWireTileEntity te) {
            this.facing = te.getFacing();
            this.wallL = te.renderWall(true);
            this.wallR = te.renderWall(false);
            this.onGround = te.isOnGround();
            this.stacked = te.isStacked();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BoundingBoxKey that = (BoundingBoxKey)o;
            return this.wallL == that.wallL && this.wallR == that.wallR && this.onGround == that.onGround && this.stacked == that.stacked && this.facing == that.facing;
        }

        public int hashCode() {
            return Objects.hash(this.wallL, this.wallR, this.onGround, this.stacked, this.facing);
        }
    }
}

