/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.gui.GuiHandler;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.client.model.data.IModelData;

public class IEBlockInterfaces {

    public static interface IModelDataBlock {
        public IModelData getModelData(@Nonnull IBlockDisplayReader var1, @Nonnull BlockPos var2, @Nonnull BlockState var3, @Nonnull IModelData var4);
    }

    public static interface ICacheData {
        public Object[] getCacheData();
    }

    public static interface IPropertyPassthrough {
    }

    public static interface IProcessTile {
        public int[] getCurrentProcessesStep();

        public int[] getCurrentProcessesMax();
    }

    public static interface IInteractionObjectIE
    extends INamedContainerProvider {
        @Nullable
        public IInteractionObjectIE getGuiMaster();

        public boolean canUseGui(PlayerEntity var1);

        default public boolean isValid() {
            return this.getGuiMaster() != null;
        }

        @Nonnull
        default public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
            IInteractionObjectIE master = this.getGuiMaster();
            Preconditions.checkState((boolean)(master instanceof TileEntity));
            return GuiHandler.createContainer(playerInventory, (TileEntity)master, id);
        }

        default public ITextComponent func_145748_c_() {
            return new StringTextComponent("");
        }
    }

    public static interface IAdvancedHasObjProperty {
        public IEProperties.IEObjState getIEObjState(BlockState var1);
    }

    public static interface IHasObjProperty
    extends IAdvancedHasObjProperty {
        public IEProperties.VisibilityList compileDisplayList(BlockState var1);

        @Override
        default public IEProperties.IEObjState getIEObjState(BlockState state) {
            return new IEProperties.IEObjState(this.compileDisplayList(state), TransformationMatrix.func_227983_a_());
        }
    }

    public static interface IGeneralMultiblock
    extends BlockstateProvider {
        @Nullable
        public IGeneralMultiblock master();

        default public boolean isDummy() {
            BlockState state = this.getState();
            if (state.func_235901_b_((Property)IEProperties.MULTIBLOCKSLAVE)) {
                return (Boolean)state.func_177229_b((Property)IEProperties.MULTIBLOCKSLAVE);
            }
            return true;
        }

        default public void checkForNeedlessTicking() {
            ApiUtils.checkForNeedlessTicking((TileEntity)((IGeneralMultiblock)((TileEntity)this)), te -> ((IGeneralMultiblock)te).isDummy());
        }
    }

    public static interface IHasDummyBlocks
    extends IGeneralMultiblock {
        public void placeDummies(BlockItemUseContext var1, BlockState var2);

        public void breakDummies(BlockPos var1, BlockState var2);
    }

    public static interface ICollisionBounds {
        @Nonnull
        public VoxelShape getCollisionShape(ISelectionContext var1);
    }

    public static interface ISelectionBounds {
        @Nonnull
        public VoxelShape getSelectionShape(@Nullable ISelectionContext var1);
    }

    public static interface IBlockBounds
    extends ISelectionBounds,
    ICollisionBounds {
        @Nonnull
        public VoxelShape getBlockBounds(@Nullable ISelectionContext var1);

        @Override
        @Nonnull
        default public VoxelShape getCollisionShape(ISelectionContext ctx) {
            return this.getBlockBounds(ctx);
        }

        @Override
        @Nonnull
        default public VoxelShape getSelectionShape(@Nullable ISelectionContext ctx) {
            return this.getBlockBounds(ctx);
        }
    }

    public static interface IMirrorAble
    extends BlockstateProvider {
        default public boolean getIsMirrored() {
            BlockState state = this.getState();
            if (state.func_235901_b_((Property)IEProperties.MIRRORED)) {
                return (Boolean)state.func_177229_b((Property)IEProperties.MIRRORED);
            }
            return false;
        }

        default public void setMirrored(boolean mirrored) {
            BlockState state = this.getState();
            BlockState newState = (BlockState)state.func_206870_a((Property)IEProperties.MIRRORED, (Comparable)Boolean.valueOf(mirrored));
            this.setState(newState);
        }
    }

    public static interface IActiveState
    extends BlockstateProvider {
        default public boolean getIsActive() {
            BlockState state = this.getState();
            if (state.func_235901_b_((Property)IEProperties.ACTIVE)) {
                return (Boolean)state.func_177229_b((Property)IEProperties.ACTIVE);
            }
            return false;
        }

        default public void setActive(boolean active) {
            BlockState state = this.getState();
            BlockState newState = (BlockState)state.func_206870_a((Property)IEProperties.ACTIVE, (Comparable)Boolean.valueOf(active));
            this.setState(newState);
        }
    }

    public static interface IPlacementInteraction {
        public void onTilePlaced(World var1, BlockPos var2, BlockState var3, Direction var4, float var5, float var6, float var7, LivingEntity var8, ItemStack var9);
    }

    public static interface IScrewdriverInteraction {
        public ActionResultType screwdriverUseSide(Direction var1, PlayerEntity var2, Hand var3, Vector3d var4);
    }

    public static interface IHammerInteraction {
        public boolean hammerUseSide(Direction var1, PlayerEntity var2, Hand var3, Vector3d var4);
    }

    public static interface IPlayerInteraction {
        public boolean interact(Direction var1, PlayerEntity var2, Hand var3, ItemStack var4, float var5, float var6, float var7);
    }

    public static interface IEntityProof {
        public boolean canEntityDestroy(Entity var1);
    }

    public static interface IAdditionalDrops {
        public Collection<ItemStack> getExtraDrops(PlayerEntity var1, BlockState var2);
    }

    public static interface IReadOnPlacement {
        public void readOnPlacement(@Nullable LivingEntity var1, ItemStack var2);
    }

    public static interface ITileDrop
    extends IReadOnPlacement {
        public List<ItemStack> getTileDrops(LootContext var1);

        default public ItemStack getPickBlock(@Nullable PlayerEntity player, BlockState state, RayTraceResult rayRes) {
            TileEntity tile = (TileEntity)this;
            if (tile.func_145831_w().field_72995_K) {
                return new ItemStack((IItemProvider)state.func_177230_c());
            }
            ServerWorld world = (ServerWorld)tile.func_145831_w();
            return this.getTileDrops(new LootContext.Builder(world).func_216021_b(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216021_b(LootParameters.field_216287_g, (Object)world.func_180495_p(tile.func_174877_v())).func_216021_b(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)tile.func_174877_v())).func_216022_a(LootParameterSets.field_216267_h)).get(0);
        }
    }

    public static interface IConfigurableSides {
        public IEEnums.IOSideConfig getSideConfig(Direction var1);

        public boolean toggleSide(Direction var1, PlayerEntity var2);
    }

    public static interface IAdvancedDirectionalTile
    extends IDirectionalTile {
        public void onDirectionalPlacement(Direction var1, float var2, float var3, float var4, LivingEntity var5);
    }

    public static interface IStateBasedDirectional
    extends IDirectionalTile,
    BlockstateProvider {
        public EnumProperty<Direction> getFacingProperty();

        @Override
        default public Direction getFacing() {
            BlockState state = this.getState();
            if (state.func_235901_b_(this.getFacingProperty())) {
                return (Direction)state.func_177229_b(this.getFacingProperty());
            }
            return Direction.NORTH;
        }

        @Override
        default public void setFacing(Direction facing) {
            BlockState oldState = this.getState();
            BlockState newState = (BlockState)oldState.func_206870_a(this.getFacingProperty(), (Comparable)facing);
            this.setState(newState);
        }
    }

    public static interface BlockstateProvider {
        public BlockState getState();

        public void setState(BlockState var1);
    }

    public static interface IDirectionalTile {
        public Direction getFacing();

        public void setFacing(Direction var1);

        public PlacementLimitation getFacingLimitation();

        default public Direction getFacingForPlacement(LivingEntity placer, BlockPos pos, Direction side, float hitX, float hitY, float hitZ) {
            Direction f;
            PlacementLimitation limit = this.getFacingLimitation();
            switch (limit) {
                case SIDE_CLICKED: {
                    f = side;
                    break;
                }
                case PISTON_LIKE: {
                    f = Direction.func_196054_a((Entity)placer)[0];
                    break;
                }
                case HORIZONTAL: {
                    f = Direction.func_176733_a((double)placer.field_70177_z);
                    break;
                }
                case VERTICAL: {
                    f = side != Direction.DOWN && (side == Direction.UP || (double)hitY <= 0.5) ? Direction.UP : Direction.DOWN;
                    break;
                }
                case HORIZONTAL_AXIS: {
                    f = Direction.func_176733_a((double)placer.field_70177_z);
                    if (f != Direction.SOUTH && f != Direction.WEST) break;
                    f = f.func_176734_d();
                    break;
                }
                case HORIZONTAL_QUADRANT: {
                    if (side.func_176740_k() != Direction.Axis.Y) {
                        f = side.func_176734_d();
                        break;
                    }
                    float xFromMid = hitX - 0.5f;
                    float zFromMid = hitZ - 0.5f;
                    float max = Math.max(Math.abs(xFromMid), Math.abs(zFromMid));
                    if (max == Math.abs(xFromMid)) {
                        f = xFromMid < 0.0f ? Direction.WEST : Direction.EAST;
                        break;
                    }
                    f = zFromMid < 0.0f ? Direction.NORTH : Direction.SOUTH;
                    break;
                }
                case HORIZONTAL_PREFER_SIDE: {
                    f = side.func_176740_k() != Direction.Axis.Y ? side.func_176734_d() : placer.func_174811_aO();
                    break;
                }
                case FIXED_DOWN: {
                    f = Direction.DOWN;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid facing limitation: " + (Object)((Object)limit));
                }
            }
            return this.mirrorFacingOnPlacement(placer) ? f.func_176734_d() : f;
        }

        default public boolean mirrorFacingOnPlacement(LivingEntity placer) {
            return false;
        }

        default public boolean canHammerRotate(Direction side, Vector3d hit, LivingEntity entity) {
            return true;
        }

        default public boolean canRotate(Direction axis) {
            return true;
        }

        default public void afterRotation(Direction oldDir, Direction newDir) {
        }

        public static enum PlacementLimitation {
            SIDE_CLICKED,
            PISTON_LIKE,
            HORIZONTAL,
            VERTICAL,
            HORIZONTAL_AXIS,
            HORIZONTAL_QUADRANT,
            HORIZONTAL_PREFER_SIDE,
            FIXED_DOWN;

        }
    }

    public static interface IColouredTile {
        public int getRenderColour(int var1);
    }

    public static interface IColouredBlock {
        public boolean hasCustomBlockColours();

        public int getRenderColour(BlockState var1, @Nullable IBlockReader var2, @Nullable BlockPos var3, int var4);
    }

    public static interface IRedstoneOutput {
        default public int getWeakRSOutput(Direction side) {
            return this.getStrongRSOutput(side);
        }

        public int getStrongRSOutput(Direction var1);

        public boolean canConnectRedstone(Direction var1);
    }

    public static interface IComparatorOverride {
        public int getComparatorInputOverride();
    }

    public static interface ISpawnInterdiction {
        public double getInterdictionRangeSquared();
    }

    public static interface ISoundTile {
        public boolean shouldPlaySound(String var1);

        default public float getSoundRadiusSq() {
            return 256.0f;
        }
    }

    public static interface IBlockOverlayText {
        @Nullable
        public ITextComponent[] getOverlayText(PlayerEntity var1, RayTraceResult var2, boolean var3);

        @Deprecated
        public boolean useNixieFont(PlayerEntity var1, RayTraceResult var2);
    }

    public static interface IAttachedIntegerProperies {
        public String[] getIntPropertyNames();

        public IntegerProperty getIntProperty(String var1);

        public int getIntPropertyValue(String var1);

        default public void setValue(String name, int value) {
        }
    }
}

