/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.metal.SampleDrillTileEntity;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;

public class SampleDrillRenderer
extends TileEntityRenderer<SampleDrillTileEntity> {
    public static DynamicModel<Void> DRILL;

    public SampleDrillRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(SampleDrillTileEntity tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (tile.isDummy() || !tile.getWorldNonnull().func_175667_e(tile.func_174877_v())) {
            return;
        }
        BlockState state = tile.getWorldNonnull().func_180495_p(tile.func_174877_v());
        if (state.func_177230_c() != IEBlocks.MetalDevices.sampleDrill) {
            return;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        int max = (Integer)IEServerConfig.MACHINES.coredrill_time.get();
        if (tile.process > 0 && tile.process < max) {
            matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), ((float)tile.process + partialTicks) * 22.5f % 360.0f, true));
            float push = (float)tile.process / (float)max;
            if (tile.process > max / 2) {
                push = 1.0f - push;
            }
            matrixStack.func_227861_a_(0.0, (double)(-2.8f * push), 0.0);
        }
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        List<BakedQuad> quads = DRILL.getNullQuads(null, state);
        ClientUtils.renderModelTESRFast(quads, bufferIn.getBuffer(RenderType.func_228639_c_()), matrixStack, combinedLightIn, combinedOverlayIn);
        matrixStack.func_227865_b_();
    }
}

