/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.split;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.ICacheKeyProvider;
import blusunrize.immersiveengineering.client.models.split.AbstractSplitModel;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.client.model.data.IModelData;

public class BakedDynamicSplitModel<K, T extends ICacheKeyProvider<K> & IBakedModel>
extends AbstractSplitModel<T> {
    private final Set<Vector3i> parts;
    private final IModelTransform transform;
    private final Cache<K, Map<Vector3i, List<BakedQuad>>> subModelCache = CacheBuilder.newBuilder().maximumSize(10L).expireAfterAccess(1L, TimeUnit.MINUTES).build();

    public BakedDynamicSplitModel(T base, Set<Vector3i> parts, IModelTransform transform, Vector3i size) {
        super(base, size);
        this.parts = parts;
        this.transform = transform;
    }

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        BlockPos offset = (BlockPos)extraData.getData(IEProperties.Model.SUBMODEL_OFFSET);
        if (offset == null) {
            return super.getQuads(state, side, rand, extraData);
        }
        Object key = ((ICacheKeyProvider)this.base).getKey(state, side, rand, extraData);
        if (key == null) {
            return ImmutableList.of();
        }
        try {
            return (List)((Map)this.subModelCache.get(key, () -> {
                List baseQuads = ((ICacheKeyProvider)this.base).getQuads(state, side, rand, extraData);
                return this.split(baseQuads, this.parts, this.transform);
            })).getOrDefault(offset, ImmutableList.of());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

