/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.IJEIRecipe;
import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleSupplier;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;

public abstract class MultiblockRecipe
extends IESerializableRecipe
implements IMultiblockRecipe,
IJEIRecipe {
    private List<IngredientWithSize> inputList = new ArrayList<IngredientWithSize>(0);
    protected NonNullList<ItemStack> outputList = NonNullList.func_191197_a((int)0, (Object)ItemStack.field_190927_a);
    protected List<FluidTagInput> fluidInputList;
    protected List<FluidStack> fluidOutputList;
    Lazy<Integer> totalProcessTime;
    Lazy<Integer> totalProcessEnergy;

    protected MultiblockRecipe(ItemStack outputDummy, IRecipeType<?> type, ResourceLocation id) {
        super(outputDummy, type, id);
    }

    public ItemStack func_77571_b() {
        NonNullList<ItemStack> outputs = this.getItemOutputs();
        if (outputs != null && outputs.size() > 0) {
            return (ItemStack)outputs.get(0);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public List<IngredientWithSize> getItemInputs() {
        return this.inputList;
    }

    protected void setInputListWithSizes(List<IngredientWithSize> inputList) {
        this.inputList = new ArrayList<IngredientWithSize>(inputList);
    }

    protected void setInputList(List<Ingredient> inputList) {
        this.inputList = inputList.stream().map(IngredientWithSize::new).collect(Collectors.toList());
    }

    @Override
    public NonNullList<ItemStack> getItemOutputs() {
        return this.outputList;
    }

    @Override
    public List<FluidTagInput> getFluidInputs() {
        return this.fluidInputList;
    }

    @Override
    public List<FluidStack> getFluidOutputs() {
        return this.fluidOutputList;
    }

    @Override
    public int getTotalProcessTime() {
        return (Integer)this.totalProcessTime.get();
    }

    @Override
    public int getTotalProcessEnergy() {
        return (Integer)this.totalProcessEnergy.get();
    }

    @Deprecated
    public void modifyTimeAndEnergy(double timeModifier, double energyModifier) {
        this.modifyTimeAndEnergy(() -> timeModifier, () -> energyModifier);
    }

    void setTimeAndEnergy(int time, int energy) {
        this.totalProcessEnergy = Lazy.of(() -> energy);
        this.totalProcessTime = Lazy.of(() -> time);
    }

    public void modifyTimeAndEnergy(DoubleSupplier timeModifier, DoubleSupplier energyModifier) {
        Lazy<Integer> oldTime = this.totalProcessTime;
        Lazy<Integer> oldEnergy = this.totalProcessEnergy;
        this.totalProcessTime = Lazy.of(() -> (int)Math.max(1.0, (double)((Integer)oldTime.get()).intValue() * timeModifier.getAsDouble()));
        this.totalProcessEnergy = Lazy.of(() -> (int)Math.max(1.0, (double)((Integer)oldEnergy.get()).intValue() * energyModifier.getAsDouble()));
    }
}

