/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import java.util.Collections;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;

public class ClocheFertilizer
extends IESerializableRecipe {
    public static IRecipeType<ClocheFertilizer> TYPE = IRecipeType.func_222147_a((String)"immersiveengineering:fertilizer");
    public static RegistryObject<IERecipeSerializer<ClocheFertilizer>> SERIALIZER;
    public static Map<ResourceLocation, ClocheFertilizer> fertilizerList;
    public final Ingredient input;
    public final float growthModifier;

    public ClocheFertilizer(ResourceLocation id, Ingredient input, float growthModifier) {
        super(ItemStack.field_190927_a, TYPE, id);
        this.input = input;
        this.growthModifier = growthModifier;
    }

    public float getGrowthModifier() {
        return this.growthModifier;
    }

    @Override
    protected IERecipeSerializer<ClocheFertilizer> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public static float getFertilizerGrowthModifier(ItemStack stack) {
        for (ClocheFertilizer e : fertilizerList.values()) {
            if (!e.input.test(stack)) continue;
            return e.getGrowthModifier();
        }
        return 0.0f;
    }

    public static boolean isValidFertilizer(ItemStack stack) {
        return ClocheFertilizer.getFertilizerGrowthModifier(stack) > 0.0f;
    }

    static {
        fertilizerList = Collections.emptyMap();
    }
}

