/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.fluids.client;

import java.util.HashMap;
import net.mehvahdjukaar.selene.Selene;
import net.mehvahdjukaar.selene.fluids.SoftFluid;
import net.mehvahdjukaar.selene.fluids.SoftFluidRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidParticleColors {
    public static final HashMap<String, Integer> particleColor = new HashMap();

    public static void refresh() {
        particleColor.clear();
        for (Fluid f : ForgeRegistries.FLUIDS) {
            ResourceLocation location;
            String key = f.getRegistryName().toString();
            if (particleColor.containsKey(key) || (location = f.getAttributes().getStillTexture()) == null) continue;
            AtlasTexture textureMap = Minecraft.func_71410_x().func_209506_al().func_229356_a_(AtlasTexture.field_110575_b);
            TextureAtlasSprite sprite = textureMap.func_195424_a(location);
            int fluidTint = f.getAttributes().getColor();
            int averageColor = -1;
            try {
                averageColor = FluidParticleColors.getColorFrom(sprite, fluidTint);
            }
            catch (Exception e) {
                Selene.LOGGER.warn("failed to load particle color for " + sprite + " using current resource pack. might be a broken png.mcmeta");
            }
            particleColor.put(key, averageColor);
        }
        for (SoftFluid s : SoftFluidRegistry.getFluids()) {
            ResourceLocation location;
            if (particleColor.containsKey(s.getID()) || s.isColored() || (location = s.getStillTexture()) == null) continue;
            AtlasTexture textureMap = Minecraft.func_71410_x().func_209506_al().func_229356_a_(AtlasTexture.field_110575_b);
            TextureAtlasSprite sprite = textureMap.func_195424_a(location);
            int averageColor = -1;
            try {
                averageColor = FluidParticleColors.getColorFrom(sprite, s.getTintColor());
            }
            catch (Exception e) {
                Selene.LOGGER.warn("failed to load particle color for " + sprite + " using current resource pack. might be a broken png.mcmeta");
            }
            particleColor.put(s.getID(), averageColor);
        }
    }

    public static int get(Fluid f) {
        return particleColor.getOrDefault(f.getRegistryName().toString(), -1);
    }

    public static int get(String s) {
        return particleColor.getOrDefault(s, -1);
    }

    private static int getColorFrom(TextureAtlasSprite sprite, int tint) {
        if (sprite == null || sprite.func_110970_k() == 0) {
            return -1;
        }
        int tintR = tint >> 16 & 0xFF;
        int tintG = tint >> 8 & 0xFF;
        int tintB = tint & 0xFF;
        int total = 0;
        int totalR = 0;
        int totalB = 0;
        int totalG = 0;
        for (int tryFrame = 0; tryFrame < sprite.func_110970_k(); ++tryFrame) {
            try {
                for (int x = 0; x < sprite.func_94211_a(); ++x) {
                    for (int y = 0; y < sprite.func_94216_b(); ++y) {
                        int pixel = sprite.getPixelRGBA(tryFrame, x, y);
                        int pixelB = pixel >> 16 & 0xFF;
                        int pixelG = pixel >> 8 & 0xFF;
                        int pixelR = pixel & 0xFF;
                        ++total;
                        totalR += pixelR;
                        totalG += pixelG;
                        totalB += pixelB;
                    }
                }
                break;
            }
            catch (Exception e) {
                total = 0;
                totalR = 0;
                totalB = 0;
                totalG = 0;
                continue;
            }
        }
        if (total <= 0) {
            return -1;
        }
        return ColorHelper.PackedColor.func_233006_a_((int)255, (int)(totalR / total * tintR / 255), (int)(totalG / total * tintG / 255), (int)(totalB / total * tintB / 255));
    }
}

