/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.multipart;

import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.compat.theoneprobe.McJtyLibTOPDriver;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.compat.theoneprobe.TOPInfoProvider;
import mcjty.lib.compat.waila.WailaInfoProvider;
import mcjty.lib.multipart.MultipartHelper;
import mcjty.lib.multipart.MultipartTE;
import mcjty.lib.multipart.PartSlot;
import mcjty.lib.tileentity.GenericTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class MultipartBlock
extends Block
implements WailaInfoProvider,
TOPInfoProvider,
ITileEntityProvider {
    public static final AxisAlignedBB AABB_EMPTY = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final AxisAlignedBB AABB_CENTER = new AxisAlignedBB(0.4, 0.4, 0.4, 0.6, 0.6, 0.6);

    public MultipartBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(2.0f).func_226896_b_().harvestLevel(0).harvestTool(ToolType.PICKAXE).func_200947_a(SoundType.field_185852_e));
        this.setRegistryName("mcjtylib", "multipart");
    }

    @Nullable
    public TileEntity func_196283_a_(@Nonnull IBlockReader worldIn) {
        return new MultipartTE();
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        MultipartTE.Part part = MultipartBlock.getHitPart(state, world, pos, player.func_174824_e(0.0f), target.func_216347_e());
        if (part != null) {
            return new ItemStack((IItemProvider)part.getState().func_177230_c().func_199767_j());
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack func_185473_a(@Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public VoxelShape func_220053_a(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        return this.combinePartShapes(world, pos, s -> s.func_215700_a(world, pos, context));
    }

    @Nonnull
    public VoxelShape func_220071_b(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        return this.combinePartShapes(world, pos, s -> s.func_215685_b(world, pos, context));
    }

    @Nonnull
    public VoxelShape func_199600_g(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        return this.combinePartShapes(world, pos, s -> s.func_199611_f(world, pos, ISelectionContext.func_216377_a()));
    }

    @Nonnull
    public VoxelShape func_196247_c(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        return this.combinePartShapes(world, pos, s -> s.func_235754_c_(world, pos));
    }

    private VoxelShape combinePartShapes(IBlockReader world, BlockPos pos, Function<BlockState, VoxelShape> shapeGetter) {
        VoxelShape combined = VoxelShapes.func_197880_a();
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof MultipartTE) {
            MultipartTE multipartTE = (MultipartTE)te;
            for (Map.Entry<PartSlot, MultipartTE.Part> entry : multipartTE.getParts().entrySet()) {
                MultipartTE.Part part = entry.getValue();
                VoxelShape shape = shapeGetter.apply(part.getState());
                if (combined.func_197766_b()) {
                    combined = shape;
                    continue;
                }
                combined = VoxelShapes.func_197878_a((VoxelShape)combined, (VoxelShape)shape, (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
        }
        return combined;
    }

    @Nonnull
    public ActionResultType func_225533_a_(@Nonnull BlockState state, @Nonnull World world, BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand hand, BlockRayTraceResult result) {
        Vector3d end;
        Vector3d hit = result.func_216347_e();
        Direction facing = result.func_216354_b();
        Vector3d start = MultipartHelper.getPlayerEyes(player);
        MultipartTE.Part part = MultipartBlock.getHitPart(state, (IBlockReader)world, pos, start, end = new Vector3d(start.field_72450_a + ((double)pos.func_177958_n() + hit.field_72450_a - start.field_72450_a) * 3.0, start.field_72448_b + ((double)pos.func_177956_o() + hit.field_72448_b - start.field_72448_b) * 3.0, start.field_72449_c + ((double)pos.func_177952_p() + hit.field_72449_c - start.field_72449_c) * 3.0));
        if (part != null) {
            if (part.getTileEntity() instanceof GenericTileEntity) {
                return ((GenericTileEntity)part.getTileEntity()).onBlockActivated(part.getState(), player, hand, result);
            }
            return part.getState().func_177230_c().func_225533_a_(part.getState(), world, pos, player, hand, result);
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof MultipartTE) {
            ((MultipartTE)te).dump();
        }
        return ActionResultType.CONSUME;
    }

    @Nullable
    public BlockState getHitState(BlockState blockState, World world, BlockPos pos, Vector3d start, Vector3d end) {
        MultipartTE.Part part = MultipartBlock.getHitPart(blockState, (IBlockReader)world, pos, start, end);
        if (part != null) {
            return part.getState();
        }
        return null;
    }

    @Nullable
    public static MultipartTE.Part getHitPart(BlockState blockState, IBlockReader world, BlockPos pos, Vector3d start, Vector3d end) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof MultipartTE) {
            MultipartTE multipartTE = (MultipartTE)te;
            for (Map.Entry<PartSlot, MultipartTE.Part> entry : multipartTE.getParts().entrySet()) {
                BlockRayTraceResult result;
                MultipartTE.Part part = entry.getValue();
                if (part.getState().func_177230_c() instanceof MultipartBlock || (result = part.getState().func_199611_f(world, pos, ISelectionContext.func_216377_a()).func_212433_a(start, end, pos)) == null) continue;
                return part;
            }
            return null;
        }
        return null;
    }

    @Override
    public TOPDriver getProbeDriver() {
        return McJtyLibTOPDriver.DRIVER;
    }
}

