/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.misc;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class BiomeDictionaryHelper {
    public static final BiomeDictionary.Type TWILIGHT = BiomeDictionary.Type.getType((String)"TWILIGHT", (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);

    public static BiomeDictionary.Type getType(String name) {
        Map byName = BiomeDictionary.Type.getAll().stream().collect(Collectors.toMap(BiomeDictionary.Type::getName, Function.identity()));
        name = name.toUpperCase();
        return (BiomeDictionary.Type)byName.get(name);
    }

    public static BiomeDictionary.Type[] toBiomeTypeArray(List<? extends String> strings) {
        BiomeDictionary.Type[] types = new BiomeDictionary.Type[strings.size()];
        for (int i = 0; i < strings.size(); ++i) {
            String string = strings.get(i);
            types[i] = BiomeDictionaryHelper.getType(string);
        }
        return types;
    }

    public static void addSpawn(EntityType<?> entityType, int min, int max, int weight, List<? extends String> include, List<? extends String> exclude, BiomeLoadingEvent event) {
        Biome biome;
        if (weight > 0 && event.getName() != null && (biome = (Biome)ForgeRegistries.BIOMES.getValue(event.getName())) != null) {
            RegistryKey biomeKey = RegistryKey.func_240903_a_((RegistryKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)event.getName());
            List<BiomeDictionary.Type> includeList = Arrays.asList(BiomeDictionaryHelper.toBiomeTypeArray(include));
            List<BiomeDictionary.Type> excludeList = Arrays.asList(BiomeDictionaryHelper.toBiomeTypeArray(exclude));
            if (!includeList.isEmpty()) {
                Set biomeTypes = BiomeDictionary.getTypes((RegistryKey)biomeKey);
                if (biomeTypes.stream().noneMatch(excludeList::contains)) {
                    if (biomeTypes.stream().anyMatch(includeList::contains)) {
                        event.getSpawns().getSpawner(entityType.func_220339_d()).add(new MobSpawnInfo.Spawners(entityType, weight, min, max));
                    }
                }
            } else {
                throw new IllegalArgumentException("Do not leave the BiomeDictionary type inclusion list empty. If you wish to disable spawning of an entity, set the weight to 0 instead.");
            }
        }
    }
}

