/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.module;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.type.CompoundBiomeConfig;
import vazkii.quark.base.module.config.type.DimensionConfig;
import vazkii.quark.base.world.WorldGenHandler;
import vazkii.quark.content.world.block.MyaliteCrystalBlock;
import vazkii.quark.content.world.gen.SpiralSpireGenerator;

@LoadModule(category=ModuleCategory.WORLD, hasSubscriptions=true)
public class SpiralSpiresModule
extends QuarkModule {
    @Config
    public static DimensionConfig dimensions = DimensionConfig.end(false);
    @Config
    public static CompoundBiomeConfig biomes = CompoundBiomeConfig.fromBiomeReslocs(false, "minecraft:end_highlands");
    @Config
    public static int rarity = 200;
    @Config
    public static int radius = 15;
    @Config(description="Set to 0 to turn off Myalite Conduits")
    public static int myaliteConduitDistance = 24;
    @Config
    public static boolean renewableMyalite = true;
    public static Block dusky_myalite;
    public static Block myalite_crystal;

    @Override
    public void construct() {
        AbstractBlock.Properties props = AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_193571_W).func_235861_h_().harvestTool(ToolType.PICKAXE).func_200948_a(1.5f, 6.0f);
        dusky_myalite = new QuarkBlock("dusky_myalite", this, ItemGroup.field_78030_b, props);
        myalite_crystal = new MyaliteCrystalBlock(this);
    }

    @Override
    public void setup() {
        WorldGenHandler.addGenerator(this, new SpiralSpireGenerator(dimensions), GenerationStage.Decoration.SURFACE_STRUCTURES, 0);
    }

    @SubscribeEvent
    public void onTeleport(EnderTeleportEvent event) {
        if (myaliteConduitDistance <= 0) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        BlockPos pos = new BlockPos(event.getTargetX(), event.getTargetY(), event.getTargetZ());
        List<BlockPos> myalite = SpiralSpiresModule.getAdjacentMyalite(null, world, pos, null);
        if (myalite.isEmpty()) {
            pos = pos.func_177977_b();
            myalite = SpiralSpiresModule.getAdjacentMyalite(null, world, pos, null);
        }
        if (!myalite.isEmpty()) {
            BlockPos test;
            ArrayList<BlockPos> found;
            block9: {
                BlockPos prev = null;
                BlockPos cond = pos;
                found = new ArrayList<BlockPos>();
                int moves = 0;
                do {
                    prev = cond;
                    cond = myalite.get(world.field_73012_v.nextInt(myalite.size()));
                    found.add(cond);
                    myalite = SpiralSpiresModule.getAdjacentMyalite(found, world, cond, null);
                    if (myalite != null && ++moves <= myaliteConduitDistance) continue;
                    return;
                } while (!myalite.isEmpty());
                test = cond.func_177982_a(cond.func_177958_n() - prev.func_177958_n(), cond.func_177956_o() - prev.func_177956_o(), cond.func_177952_p() - prev.func_177952_p());
                if (!world.func_180495_p(test).func_196958_f()) {
                    for (Direction d : Direction.values()) {
                        test = cond.func_177972_a(d);
                        if (!world.func_180495_p(test).func_196958_f()) continue;
                        if (d.func_176740_k() == Direction.Axis.Y) {
                            test = test.func_177972_a(d);
                        }
                        break block9;
                    }
                    return;
                }
            }
            event.setTargetX((double)test.func_177958_n() + 0.5);
            event.setTargetY((double)test.func_177956_o() + 0.5);
            event.setTargetZ((double)test.func_177952_p() + 0.5);
            if (world instanceof ServerWorld) {
                ServerWorld sworld = (ServerWorld)world;
                for (BlockPos f : found) {
                    sworld.func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, myalite_crystal.func_176223_P()), (double)f.func_177958_n() + 0.5, (double)f.func_177956_o() + 0.5, (double)f.func_177952_p() + 0.5, 30, 0.25, 0.25, 0.25, 0.0);
                }
            }
        }
    }

    private static List<BlockPos> getAdjacentMyalite(List<BlockPos> found, World world, BlockPos pos, Direction ignore) {
        ArrayList<BlockPos> ret = new ArrayList<BlockPos>(6);
        ArrayList<BlockPos> collisions = new ArrayList<BlockPos>();
        for (Direction d : Direction.values()) {
            BlockPos off;
            if (d == ignore || world.func_180495_p(off = pos.func_177972_a(d)).func_177230_c() != myalite_crystal) continue;
            if (found != null && found.contains(off)) {
                collisions.add(off);
                continue;
            }
            ret.add(off);
        }
        if (ret.isEmpty() && collisions.size() > 1) {
            return null;
        }
        return ret;
    }
}

